/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDnssecResponse extends Route53Response implements
        ToCopyableBuilder<GetDnssecResponse.Builder, GetDnssecResponse> {
    private static final SdkField<DNSSECStatus> STATUS_FIELD = SdkField
            .<DNSSECStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status")
            .getter(getter(GetDnssecResponse::status))
            .setter(setter(Builder::status))
            .constructor(DNSSECStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<List<KeySigningKey>> KEY_SIGNING_KEYS_FIELD = SdkField
            .<List<KeySigningKey>> builder(MarshallingType.LIST)
            .memberName("KeySigningKeys")
            .getter(getter(GetDnssecResponse::keySigningKeys))
            .setter(setter(Builder::keySigningKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySigningKeys")
                    .unmarshallLocationName("KeySigningKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeySigningKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeySigningKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            KEY_SIGNING_KEYS_FIELD));

    private final DNSSECStatus status;

    private final List<KeySigningKey> keySigningKeys;

    private GetDnssecResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.keySigningKeys = builder.keySigningKeys;
    }

    /**
     * <p>
     * A string representing the status of DNSSEC.
     * </p>
     * 
     * @return A string representing the status of DNSSEC.
     */
    public final DNSSECStatus status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeySigningKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKeySigningKeys() {
        return keySigningKeys != null && !(keySigningKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-signing keys (KSKs) in your account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeySigningKeys} method.
     * </p>
     * 
     * @return The key-signing keys (KSKs) in your account.
     */
    public final List<KeySigningKey> keySigningKeys() {
        return keySigningKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeySigningKeys() ? keySigningKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDnssecResponse)) {
            return false;
        }
        GetDnssecResponse other = (GetDnssecResponse) obj;
        return Objects.equals(status(), other.status()) && hasKeySigningKeys() == other.hasKeySigningKeys()
                && Objects.equals(keySigningKeys(), other.keySigningKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDnssecResponse").add("Status", status())
                .add("KeySigningKeys", hasKeySigningKeys() ? keySigningKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "KeySigningKeys":
            return Optional.ofNullable(clazz.cast(keySigningKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDnssecResponse, T> g) {
        return obj -> g.apply((GetDnssecResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, GetDnssecResponse> {
        /**
         * <p>
         * A string representing the status of DNSSEC.
         * </p>
         * 
         * @param status
         *        A string representing the status of DNSSEC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(DNSSECStatus status);

        /**
         * <p>
         * A string representing the status of DNSSEC.
         * </p>
         * This is a convenience method that creates an instance of the {@link DNSSECStatus.Builder} avoiding the need
         * to create one manually via {@link DNSSECStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DNSSECStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(DNSSECStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link DNSSECStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(DNSSECStatus)
         */
        default Builder status(Consumer<DNSSECStatus.Builder> status) {
            return status(DNSSECStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The key-signing keys (KSKs) in your account.
         * </p>
         * 
         * @param keySigningKeys
         *        The key-signing keys (KSKs) in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySigningKeys(Collection<KeySigningKey> keySigningKeys);

        /**
         * <p>
         * The key-signing keys (KSKs) in your account.
         * </p>
         * 
         * @param keySigningKeys
         *        The key-signing keys (KSKs) in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySigningKeys(KeySigningKey... keySigningKeys);

        /**
         * <p>
         * The key-signing keys (KSKs) in your account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53.model.KeySigningKey.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.route53.model.KeySigningKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53.model.KeySigningKey.Builder#build()} is called immediately and
         * its result is passed to {@link #keySigningKeys(List<KeySigningKey>)}.
         * 
         * @param keySigningKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53.model.KeySigningKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keySigningKeys(java.util.Collection<KeySigningKey>)
         */
        Builder keySigningKeys(Consumer<KeySigningKey.Builder>... keySigningKeys);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private DNSSECStatus status;

        private List<KeySigningKey> keySigningKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDnssecResponse model) {
            super(model);
            status(model.status);
            keySigningKeys(model.keySigningKeys);
        }

        public final DNSSECStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(DNSSECStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(DNSSECStatus status) {
            this.status = status;
            return this;
        }

        public final List<KeySigningKey.Builder> getKeySigningKeys() {
            List<KeySigningKey.Builder> result = KeySigningKeysCopier.copyToBuilder(this.keySigningKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeySigningKeys(Collection<KeySigningKey.BuilderImpl> keySigningKeys) {
            this.keySigningKeys = KeySigningKeysCopier.copyFromBuilder(keySigningKeys);
        }

        @Override
        public final Builder keySigningKeys(Collection<KeySigningKey> keySigningKeys) {
            this.keySigningKeys = KeySigningKeysCopier.copy(keySigningKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySigningKeys(KeySigningKey... keySigningKeys) {
            keySigningKeys(Arrays.asList(keySigningKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySigningKeys(Consumer<KeySigningKey.Builder>... keySigningKeys) {
            keySigningKeys(Stream.of(keySigningKeys).map(c -> KeySigningKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDnssecResponse build() {
            return new GetDnssecResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
