/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRolePermissionsBoundaryRequest extends IamRequest implements
        ToCopyableBuilder<PutRolePermissionsBoundaryRequest.Builder, PutRolePermissionsBoundaryRequest> {
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleName").getter(getter(PutRolePermissionsBoundaryRequest::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()).build();

    private static final SdkField<String> PERMISSIONS_BOUNDARY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionsBoundary").getter(getter(PutRolePermissionsBoundaryRequest::permissionsBoundary))
            .setter(setter(Builder::permissionsBoundary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_NAME_FIELD,
            PERMISSIONS_BOUNDARY_FIELD));

    private final String roleName;

    private final String permissionsBoundary;

    private PutRolePermissionsBoundaryRequest(BuilderImpl builder) {
        super(builder);
        this.roleName = builder.roleName;
        this.permissionsBoundary = builder.permissionsBoundary;
    }

    /**
     * <p>
     * The name (friendly name, not ARN) of the IAM role for which you want to set the permissions boundary.
     * </p>
     * 
     * @return The name (friendly name, not ARN) of the IAM role for which you want to set the permissions boundary.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * <p>
     * The ARN of the managed policy that is used to set the permissions boundary for the role.
     * </p>
     * <p>
     * A permissions boundary policy defines the maximum permissions that identity-based policies can grant to an
     * entity, but does not grant permissions. Permissions boundaries do not define the maximum permissions that a
     * resource-based policy can grant to an entity. To learn more, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries
     * for IAM entities</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about policy types, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policy-types">Policy types
     * </a> in the <i>IAM User Guide</i>.
     * </p>
     * 
     * @return The ARN of the managed policy that is used to set the permissions boundary for the role.</p>
     *         <p>
     *         A permissions boundary policy defines the maximum permissions that identity-based policies can grant to
     *         an entity, but does not grant permissions. Permissions boundaries do not define the maximum permissions
     *         that a resource-based policy can grant to an entity. To learn more, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
     *         boundaries for IAM entities</a> in the <i>IAM User Guide</i>.
     *         </p>
     *         <p>
     *         For more information about policy types, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policy-types">Policy
     *         types </a> in the <i>IAM User Guide</i>.
     */
    public final String permissionsBoundary() {
        return permissionsBoundary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsBoundary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRolePermissionsBoundaryRequest)) {
            return false;
        }
        PutRolePermissionsBoundaryRequest other = (PutRolePermissionsBoundaryRequest) obj;
        return Objects.equals(roleName(), other.roleName()) && Objects.equals(permissionsBoundary(), other.permissionsBoundary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRolePermissionsBoundaryRequest").add("RoleName", roleName())
                .add("PermissionsBoundary", permissionsBoundary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "PermissionsBoundary":
            return Optional.ofNullable(clazz.cast(permissionsBoundary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRolePermissionsBoundaryRequest, T> g) {
        return obj -> g.apply((PutRolePermissionsBoundaryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutRolePermissionsBoundaryRequest> {
        /**
         * <p>
         * The name (friendly name, not ARN) of the IAM role for which you want to set the permissions boundary.
         * </p>
         * 
         * @param roleName
         *        The name (friendly name, not ARN) of the IAM role for which you want to set the permissions boundary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The ARN of the managed policy that is used to set the permissions boundary for the role.
         * </p>
         * <p>
         * A permissions boundary policy defines the maximum permissions that identity-based policies can grant to an
         * entity, but does not grant permissions. Permissions boundaries do not define the maximum permissions that a
         * resource-based policy can grant to an entity. To learn more, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         * boundaries for IAM entities</a> in the <i>IAM User Guide</i>.
         * </p>
         * <p>
         * For more information about policy types, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policy-types">Policy types
         * </a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param permissionsBoundary
         *        The ARN of the managed policy that is used to set the permissions boundary for the role.</p>
         *        <p>
         *        A permissions boundary policy defines the maximum permissions that identity-based policies can grant
         *        to an entity, but does not grant permissions. Permissions boundaries do not define the maximum
         *        permissions that a resource-based policy can grant to an entity. To learn more, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         *        boundaries for IAM entities</a> in the <i>IAM User Guide</i>.
         *        </p>
         *        <p>
         *        For more information about policy types, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policy-types"
         *        >Policy types </a> in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsBoundary(String permissionsBoundary);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String roleName;

        private String permissionsBoundary;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRolePermissionsBoundaryRequest model) {
            super(model);
            roleName(model.roleName);
            permissionsBoundary(model.permissionsBoundary);
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getPermissionsBoundary() {
            return permissionsBoundary;
        }

        public final void setPermissionsBoundary(String permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
        }

        @Override
        public final Builder permissionsBoundary(String permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRolePermissionsBoundaryRequest build() {
            return new PutRolePermissionsBoundaryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
