/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyTrustStoreRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<ModifyTrustStoreRequest.Builder, ModifyTrustStoreRequest> {
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustStoreArn").getter(getter(ModifyTrustStoreRequest::trustStoreArn))
            .setter(setter(Builder::trustStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreArn").build()).build();

    private static final SdkField<String> CA_CERTIFICATES_BUNDLE_S3_BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CaCertificatesBundleS3Bucket")
            .getter(getter(ModifyTrustStoreRequest::caCertificatesBundleS3Bucket))
            .setter(setter(Builder::caCertificatesBundleS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaCertificatesBundleS3Bucket")
                    .build()).build();

    private static final SdkField<String> CA_CERTIFICATES_BUNDLE_S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaCertificatesBundleS3Key").getter(getter(ModifyTrustStoreRequest::caCertificatesBundleS3Key))
            .setter(setter(Builder::caCertificatesBundleS3Key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaCertificatesBundleS3Key").build())
            .build();

    private static final SdkField<String> CA_CERTIFICATES_BUNDLE_S3_OBJECT_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CaCertificatesBundleS3ObjectVersion")
            .getter(getter(ModifyTrustStoreRequest::caCertificatesBundleS3ObjectVersion))
            .setter(setter(Builder::caCertificatesBundleS3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CaCertificatesBundleS3ObjectVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_ARN_FIELD,
            CA_CERTIFICATES_BUNDLE_S3_BUCKET_FIELD, CA_CERTIFICATES_BUNDLE_S3_KEY_FIELD,
            CA_CERTIFICATES_BUNDLE_S3_OBJECT_VERSION_FIELD));

    private final String trustStoreArn;

    private final String caCertificatesBundleS3Bucket;

    private final String caCertificatesBundleS3Key;

    private final String caCertificatesBundleS3ObjectVersion;

    private ModifyTrustStoreRequest(BuilderImpl builder) {
        super(builder);
        this.trustStoreArn = builder.trustStoreArn;
        this.caCertificatesBundleS3Bucket = builder.caCertificatesBundleS3Bucket;
        this.caCertificatesBundleS3Key = builder.caCertificatesBundleS3Key;
        this.caCertificatesBundleS3ObjectVersion = builder.caCertificatesBundleS3ObjectVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trust store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trust store.
     */
    public final String trustStoreArn() {
        return trustStoreArn;
    }

    /**
     * <p>
     * The Amazon S3 bucket for the ca certificates bundle.
     * </p>
     * 
     * @return The Amazon S3 bucket for the ca certificates bundle.
     */
    public final String caCertificatesBundleS3Bucket() {
        return caCertificatesBundleS3Bucket;
    }

    /**
     * <p>
     * The Amazon S3 path for the ca certificates bundle.
     * </p>
     * 
     * @return The Amazon S3 path for the ca certificates bundle.
     */
    public final String caCertificatesBundleS3Key() {
        return caCertificatesBundleS3Key;
    }

    /**
     * <p>
     * The Amazon S3 object version for the ca certificates bundle. If undefined the current version is used.
     * </p>
     * 
     * @return The Amazon S3 object version for the ca certificates bundle. If undefined the current version is used.
     */
    public final String caCertificatesBundleS3ObjectVersion() {
        return caCertificatesBundleS3ObjectVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificatesBundleS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificatesBundleS3Key());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificatesBundleS3ObjectVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTrustStoreRequest)) {
            return false;
        }
        ModifyTrustStoreRequest other = (ModifyTrustStoreRequest) obj;
        return Objects.equals(trustStoreArn(), other.trustStoreArn())
                && Objects.equals(caCertificatesBundleS3Bucket(), other.caCertificatesBundleS3Bucket())
                && Objects.equals(caCertificatesBundleS3Key(), other.caCertificatesBundleS3Key())
                && Objects.equals(caCertificatesBundleS3ObjectVersion(), other.caCertificatesBundleS3ObjectVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyTrustStoreRequest").add("TrustStoreArn", trustStoreArn())
                .add("CaCertificatesBundleS3Bucket", caCertificatesBundleS3Bucket())
                .add("CaCertificatesBundleS3Key", caCertificatesBundleS3Key())
                .add("CaCertificatesBundleS3ObjectVersion", caCertificatesBundleS3ObjectVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustStoreArn":
            return Optional.ofNullable(clazz.cast(trustStoreArn()));
        case "CaCertificatesBundleS3Bucket":
            return Optional.ofNullable(clazz.cast(caCertificatesBundleS3Bucket()));
        case "CaCertificatesBundleS3Key":
            return Optional.ofNullable(clazz.cast(caCertificatesBundleS3Key()));
        case "CaCertificatesBundleS3ObjectVersion":
            return Optional.ofNullable(clazz.cast(caCertificatesBundleS3ObjectVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyTrustStoreRequest, T> g) {
        return obj -> g.apply((ModifyTrustStoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyTrustStoreRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trust store.
         * </p>
         * 
         * @param trustStoreArn
         *        The Amazon Resource Name (ARN) of the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreArn(String trustStoreArn);

        /**
         * <p>
         * The Amazon S3 bucket for the ca certificates bundle.
         * </p>
         * 
         * @param caCertificatesBundleS3Bucket
         *        The Amazon S3 bucket for the ca certificates bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificatesBundleS3Bucket(String caCertificatesBundleS3Bucket);

        /**
         * <p>
         * The Amazon S3 path for the ca certificates bundle.
         * </p>
         * 
         * @param caCertificatesBundleS3Key
         *        The Amazon S3 path for the ca certificates bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificatesBundleS3Key(String caCertificatesBundleS3Key);

        /**
         * <p>
         * The Amazon S3 object version for the ca certificates bundle. If undefined the current version is used.
         * </p>
         * 
         * @param caCertificatesBundleS3ObjectVersion
         *        The Amazon S3 object version for the ca certificates bundle. If undefined the current version is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificatesBundleS3ObjectVersion(String caCertificatesBundleS3ObjectVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String trustStoreArn;

        private String caCertificatesBundleS3Bucket;

        private String caCertificatesBundleS3Key;

        private String caCertificatesBundleS3ObjectVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTrustStoreRequest model) {
            super(model);
            trustStoreArn(model.trustStoreArn);
            caCertificatesBundleS3Bucket(model.caCertificatesBundleS3Bucket);
            caCertificatesBundleS3Key(model.caCertificatesBundleS3Key);
            caCertificatesBundleS3ObjectVersion(model.caCertificatesBundleS3ObjectVersion);
        }

        public final String getTrustStoreArn() {
            return trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final String getCaCertificatesBundleS3Bucket() {
            return caCertificatesBundleS3Bucket;
        }

        public final void setCaCertificatesBundleS3Bucket(String caCertificatesBundleS3Bucket) {
            this.caCertificatesBundleS3Bucket = caCertificatesBundleS3Bucket;
        }

        @Override
        public final Builder caCertificatesBundleS3Bucket(String caCertificatesBundleS3Bucket) {
            this.caCertificatesBundleS3Bucket = caCertificatesBundleS3Bucket;
            return this;
        }

        public final String getCaCertificatesBundleS3Key() {
            return caCertificatesBundleS3Key;
        }

        public final void setCaCertificatesBundleS3Key(String caCertificatesBundleS3Key) {
            this.caCertificatesBundleS3Key = caCertificatesBundleS3Key;
        }

        @Override
        public final Builder caCertificatesBundleS3Key(String caCertificatesBundleS3Key) {
            this.caCertificatesBundleS3Key = caCertificatesBundleS3Key;
            return this;
        }

        public final String getCaCertificatesBundleS3ObjectVersion() {
            return caCertificatesBundleS3ObjectVersion;
        }

        public final void setCaCertificatesBundleS3ObjectVersion(String caCertificatesBundleS3ObjectVersion) {
            this.caCertificatesBundleS3ObjectVersion = caCertificatesBundleS3ObjectVersion;
        }

        @Override
        public final Builder caCertificatesBundleS3ObjectVersion(String caCertificatesBundleS3ObjectVersion) {
            this.caCertificatesBundleS3ObjectVersion = caCertificatesBundleS3ObjectVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTrustStoreRequest build() {
            return new ModifyTrustStoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
