/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class Phase2EncryptionAlgorithmsListCopier {
    static List<Phase2EncryptionAlgorithmsListValue> copy(
            Collection<? extends Phase2EncryptionAlgorithmsListValue> phase2EncryptionAlgorithmsListParam) {
        List<Phase2EncryptionAlgorithmsListValue> list;
        if (phase2EncryptionAlgorithmsListParam == null || phase2EncryptionAlgorithmsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Phase2EncryptionAlgorithmsListValue> modifiableList = new ArrayList<>();
            phase2EncryptionAlgorithmsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Phase2EncryptionAlgorithmsListValue> copyFromBuilder(
            Collection<? extends Phase2EncryptionAlgorithmsListValue.Builder> phase2EncryptionAlgorithmsListParam) {
        List<Phase2EncryptionAlgorithmsListValue> list;
        if (phase2EncryptionAlgorithmsListParam == null || phase2EncryptionAlgorithmsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Phase2EncryptionAlgorithmsListValue> modifiableList = new ArrayList<>();
            phase2EncryptionAlgorithmsListParam.forEach(entry -> {
                Phase2EncryptionAlgorithmsListValue member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Phase2EncryptionAlgorithmsListValue.Builder> copyToBuilder(
            Collection<? extends Phase2EncryptionAlgorithmsListValue> phase2EncryptionAlgorithmsListParam) {
        List<Phase2EncryptionAlgorithmsListValue.Builder> list;
        if (phase2EncryptionAlgorithmsListParam == null || phase2EncryptionAlgorithmsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Phase2EncryptionAlgorithmsListValue.Builder> modifiableList = new ArrayList<>();
            phase2EncryptionAlgorithmsListParam.forEach(entry -> {
                Phase2EncryptionAlgorithmsListValue.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
