/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The maintenance options for the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceMaintenanceOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceMaintenanceOptions.Builder, InstanceMaintenanceOptions> {
    private static final SdkField<String> AUTO_RECOVERY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoRecovery")
            .getter(getter(InstanceMaintenanceOptions::autoRecoveryAsString))
            .setter(setter(Builder::autoRecovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRecovery")
                    .unmarshallLocationName("autoRecovery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_RECOVERY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String autoRecovery;

    private InstanceMaintenanceOptions(BuilderImpl builder) {
        this.autoRecovery = builder.autoRecovery;
    }

    /**
     * <p>
     * Provides information on the current automatic recovery behavior of your instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoRecovery} will
     * return {@link InstanceAutoRecoveryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoRecoveryAsString}.
     * </p>
     * 
     * @return Provides information on the current automatic recovery behavior of your instance.
     * @see InstanceAutoRecoveryState
     */
    public final InstanceAutoRecoveryState autoRecovery() {
        return InstanceAutoRecoveryState.fromValue(autoRecovery);
    }

    /**
     * <p>
     * Provides information on the current automatic recovery behavior of your instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoRecovery} will
     * return {@link InstanceAutoRecoveryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoRecoveryAsString}.
     * </p>
     * 
     * @return Provides information on the current automatic recovery behavior of your instance.
     * @see InstanceAutoRecoveryState
     */
    public final String autoRecoveryAsString() {
        return autoRecovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoRecoveryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMaintenanceOptions)) {
            return false;
        }
        InstanceMaintenanceOptions other = (InstanceMaintenanceOptions) obj;
        return Objects.equals(autoRecoveryAsString(), other.autoRecoveryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceMaintenanceOptions").add("AutoRecovery", autoRecoveryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoRecovery":
            return Optional.ofNullable(clazz.cast(autoRecoveryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceMaintenanceOptions, T> g) {
        return obj -> g.apply((InstanceMaintenanceOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceMaintenanceOptions> {
        /**
         * <p>
         * Provides information on the current automatic recovery behavior of your instance.
         * </p>
         * 
         * @param autoRecovery
         *        Provides information on the current automatic recovery behavior of your instance.
         * @see InstanceAutoRecoveryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAutoRecoveryState
         */
        Builder autoRecovery(String autoRecovery);

        /**
         * <p>
         * Provides information on the current automatic recovery behavior of your instance.
         * </p>
         * 
         * @param autoRecovery
         *        Provides information on the current automatic recovery behavior of your instance.
         * @see InstanceAutoRecoveryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAutoRecoveryState
         */
        Builder autoRecovery(InstanceAutoRecoveryState autoRecovery);
    }

    static final class BuilderImpl implements Builder {
        private String autoRecovery;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMaintenanceOptions model) {
            autoRecovery(model.autoRecovery);
        }

        public final String getAutoRecovery() {
            return autoRecovery;
        }

        public final void setAutoRecovery(String autoRecovery) {
            this.autoRecovery = autoRecovery;
        }

        @Override
        public final Builder autoRecovery(String autoRecovery) {
            this.autoRecovery = autoRecovery;
            return this;
        }

        @Override
        public final Builder autoRecovery(InstanceAutoRecoveryState autoRecovery) {
            this.autoRecovery(autoRecovery == null ? null : autoRecovery.toString());
            return this;
        }

        @Override
        public InstanceMaintenanceOptions build() {
            return new InstanceMaintenanceOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
