/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNetworkInsightsAccessScopeAnalysesRequest extends Ec2Request
        implements
        ToCopyableBuilder<DescribeNetworkInsightsAccessScopeAnalysesRequest.Builder, DescribeNetworkInsightsAccessScopeAnalysesRequest> {
    private static final SdkField<List<String>> NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NetworkInsightsAccessScopeAnalysisIds")
            .getter(getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::networkInsightsAccessScopeAnalysisIds))
            .setter(setter(Builder::networkInsightsAccessScopeAnalysisIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NetworkInsightsAccessScopeAnalysisId")
                    .unmarshallLocationName("NetworkInsightsAccessScopeAnalysisId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsAccessScopeId")
            .getter(getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::networkInsightsAccessScopeId))
            .setter(setter(Builder::networkInsightsAccessScopeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeId")
                    .unmarshallLocationName("NetworkInsightsAccessScopeId").build()).build();

    private static final SdkField<Instant> ANALYSIS_START_TIME_BEGIN_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AnalysisStartTimeBegin")
            .getter(getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::analysisStartTimeBegin))
            .setter(setter(Builder::analysisStartTimeBegin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisStartTimeBegin")
                    .unmarshallLocationName("AnalysisStartTimeBegin").build()).build();

    private static final SdkField<Instant> ANALYSIS_START_TIME_END_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AnalysisStartTimeEnd")
            .getter(getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::analysisStartTimeEnd))
            .setter(setter(Builder::analysisStartTimeEnd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisStartTimeEnd")
                    .unmarshallLocationName("AnalysisStartTimeEnd").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeNetworkInsightsAccessScopeAnalysesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_IDS_FIELD, NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD,
            ANALYSIS_START_TIME_BEGIN_FIELD, ANALYSIS_START_TIME_END_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, DRY_RUN_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> networkInsightsAccessScopeAnalysisIds;

    private final String networkInsightsAccessScopeId;

    private final Instant analysisStartTimeBegin;

    private final Instant analysisStartTimeEnd;

    private final List<Filter> filters;

    private final Integer maxResults;

    private final Boolean dryRun;

    private final String nextToken;

    private DescribeNetworkInsightsAccessScopeAnalysesRequest(BuilderImpl builder) {
        super(builder);
        this.networkInsightsAccessScopeAnalysisIds = builder.networkInsightsAccessScopeAnalysisIds;
        this.networkInsightsAccessScopeId = builder.networkInsightsAccessScopeId;
        this.analysisStartTimeBegin = builder.analysisStartTimeBegin;
        this.analysisStartTimeEnd = builder.analysisStartTimeEnd;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.dryRun = builder.dryRun;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInsightsAccessScopeAnalysisIds
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasNetworkInsightsAccessScopeAnalysisIds() {
        return networkInsightsAccessScopeAnalysisIds != null
                && !(networkInsightsAccessScopeAnalysisIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Network Access Scope analyses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInsightsAccessScopeAnalysisIds}
     * method.
     * </p>
     * 
     * @return The IDs of the Network Access Scope analyses.
     */
    public final List<String> networkInsightsAccessScopeAnalysisIds() {
        return networkInsightsAccessScopeAnalysisIds;
    }

    /**
     * <p>
     * The ID of the Network Access Scope.
     * </p>
     * 
     * @return The ID of the Network Access Scope.
     */
    public final String networkInsightsAccessScopeId() {
        return networkInsightsAccessScopeId;
    }

    /**
     * <p>
     * Filters the results based on the start time. The analysis must have started on or after this time.
     * </p>
     * 
     * @return Filters the results based on the start time. The analysis must have started on or after this time.
     */
    public final Instant analysisStartTimeBegin() {
        return analysisStartTimeBegin;
    }

    /**
     * <p>
     * Filters the results based on the start time. The analysis must have started on or before this time.
     * </p>
     * 
     * @return Filters the results based on the start time. The analysis must have started on or before this time.
     */
    public final Instant analysisStartTimeEnd() {
        return analysisStartTimeEnd;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * There are no supported filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return There are no supported filters.
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasNetworkInsightsAccessScopeAnalysisIds() ? networkInsightsAccessScopeAnalysisIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsAccessScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(analysisStartTimeBegin());
        hashCode = 31 * hashCode + Objects.hashCode(analysisStartTimeEnd());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInsightsAccessScopeAnalysesRequest)) {
            return false;
        }
        DescribeNetworkInsightsAccessScopeAnalysesRequest other = (DescribeNetworkInsightsAccessScopeAnalysesRequest) obj;
        return hasNetworkInsightsAccessScopeAnalysisIds() == other.hasNetworkInsightsAccessScopeAnalysisIds()
                && Objects.equals(networkInsightsAccessScopeAnalysisIds(), other.networkInsightsAccessScopeAnalysisIds())
                && Objects.equals(networkInsightsAccessScopeId(), other.networkInsightsAccessScopeId())
                && Objects.equals(analysisStartTimeBegin(), other.analysisStartTimeBegin())
                && Objects.equals(analysisStartTimeEnd(), other.analysisStartTimeEnd()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(dryRun(), other.dryRun()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeNetworkInsightsAccessScopeAnalysesRequest")
                .add("NetworkInsightsAccessScopeAnalysisIds",
                        hasNetworkInsightsAccessScopeAnalysisIds() ? networkInsightsAccessScopeAnalysisIds() : null)
                .add("NetworkInsightsAccessScopeId", networkInsightsAccessScopeId())
                .add("AnalysisStartTimeBegin", analysisStartTimeBegin()).add("AnalysisStartTimeEnd", analysisStartTimeEnd())
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("DryRun", dryRun())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInsightsAccessScopeAnalysisIds":
            return Optional.ofNullable(clazz.cast(networkInsightsAccessScopeAnalysisIds()));
        case "NetworkInsightsAccessScopeId":
            return Optional.ofNullable(clazz.cast(networkInsightsAccessScopeId()));
        case "AnalysisStartTimeBegin":
            return Optional.ofNullable(clazz.cast(analysisStartTimeBegin()));
        case "AnalysisStartTimeEnd":
            return Optional.ofNullable(clazz.cast(analysisStartTimeEnd()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkInsightsAccessScopeAnalysesRequest, T> g) {
        return obj -> g.apply((DescribeNetworkInsightsAccessScopeAnalysesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNetworkInsightsAccessScopeAnalysesRequest> {
        /**
         * <p>
         * The IDs of the Network Access Scope analyses.
         * </p>
         * 
         * @param networkInsightsAccessScopeAnalysisIds
         *        The IDs of the Network Access Scope analyses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAccessScopeAnalysisIds(Collection<String> networkInsightsAccessScopeAnalysisIds);

        /**
         * <p>
         * The IDs of the Network Access Scope analyses.
         * </p>
         * 
         * @param networkInsightsAccessScopeAnalysisIds
         *        The IDs of the Network Access Scope analyses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAccessScopeAnalysisIds(String... networkInsightsAccessScopeAnalysisIds);

        /**
         * <p>
         * The ID of the Network Access Scope.
         * </p>
         * 
         * @param networkInsightsAccessScopeId
         *        The ID of the Network Access Scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsAccessScopeId(String networkInsightsAccessScopeId);

        /**
         * <p>
         * Filters the results based on the start time. The analysis must have started on or after this time.
         * </p>
         * 
         * @param analysisStartTimeBegin
         *        Filters the results based on the start time. The analysis must have started on or after this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisStartTimeBegin(Instant analysisStartTimeBegin);

        /**
         * <p>
         * Filters the results based on the start time. The analysis must have started on or before this time.
         * </p>
         * 
         * @param analysisStartTimeEnd
         *        Filters the results based on the start time. The analysis must have started on or before this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisStartTimeEnd(Instant analysisStartTimeEnd);

        /**
         * <p>
         * There are no supported filters.
         * </p>
         * 
         * @param filters
         *        There are no supported filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * There are no supported filters.
         * </p>
         * 
         * @param filters
         *        There are no supported filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * There are no supported filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> networkInsightsAccessScopeAnalysisIds = DefaultSdkAutoConstructList.getInstance();

        private String networkInsightsAccessScopeId;

        private Instant analysisStartTimeBegin;

        private Instant analysisStartTimeEnd;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private Boolean dryRun;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInsightsAccessScopeAnalysesRequest model) {
            super(model);
            networkInsightsAccessScopeAnalysisIds(model.networkInsightsAccessScopeAnalysisIds);
            networkInsightsAccessScopeId(model.networkInsightsAccessScopeId);
            analysisStartTimeBegin(model.analysisStartTimeBegin);
            analysisStartTimeEnd(model.analysisStartTimeEnd);
            filters(model.filters);
            maxResults(model.maxResults);
            dryRun(model.dryRun);
            nextToken(model.nextToken);
        }

        public final Collection<String> getNetworkInsightsAccessScopeAnalysisIds() {
            if (networkInsightsAccessScopeAnalysisIds instanceof SdkAutoConstructList) {
                return null;
            }
            return networkInsightsAccessScopeAnalysisIds;
        }

        public final void setNetworkInsightsAccessScopeAnalysisIds(Collection<String> networkInsightsAccessScopeAnalysisIds) {
            this.networkInsightsAccessScopeAnalysisIds = NetworkInsightsAccessScopeAnalysisIdListCopier
                    .copy(networkInsightsAccessScopeAnalysisIds);
        }

        @Override
        public final Builder networkInsightsAccessScopeAnalysisIds(Collection<String> networkInsightsAccessScopeAnalysisIds) {
            this.networkInsightsAccessScopeAnalysisIds = NetworkInsightsAccessScopeAnalysisIdListCopier
                    .copy(networkInsightsAccessScopeAnalysisIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInsightsAccessScopeAnalysisIds(String... networkInsightsAccessScopeAnalysisIds) {
            networkInsightsAccessScopeAnalysisIds(Arrays.asList(networkInsightsAccessScopeAnalysisIds));
            return this;
        }

        public final String getNetworkInsightsAccessScopeId() {
            return networkInsightsAccessScopeId;
        }

        public final void setNetworkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
        }

        @Override
        public final Builder networkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
            return this;
        }

        public final Instant getAnalysisStartTimeBegin() {
            return analysisStartTimeBegin;
        }

        public final void setAnalysisStartTimeBegin(Instant analysisStartTimeBegin) {
            this.analysisStartTimeBegin = analysisStartTimeBegin;
        }

        @Override
        public final Builder analysisStartTimeBegin(Instant analysisStartTimeBegin) {
            this.analysisStartTimeBegin = analysisStartTimeBegin;
            return this;
        }

        public final Instant getAnalysisStartTimeEnd() {
            return analysisStartTimeEnd;
        }

        public final void setAnalysisStartTimeEnd(Instant analysisStartTimeEnd) {
            this.analysisStartTimeEnd = analysisStartTimeEnd;
        }

        @Override
        public final Builder analysisStartTimeEnd(Instant analysisStartTimeEnd) {
            this.analysisStartTimeEnd = analysisStartTimeEnd;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNetworkInsightsAccessScopeAnalysesRequest build() {
            return new DescribeNetworkInsightsAccessScopeAnalysesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
