/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.yellowbrickadapter.impl;

import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickConfiguration;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickConfigurationListener;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickRace;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickRaceTrackingConnectivityParams;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickTrackingAdapter;
import com.sap.sailing.domain.yellowbrickadapter.impl.GetPositionsParser;
import com.sap.sailing.domain.yellowbrickadapter.impl.PositionsDocument;
import com.sap.sailing.domain.yellowbrickadapter.impl.YellowBrickConfigurationImpl;
import com.sap.sailing.domain.yellowbrickadapter.impl.YellowBrickRaceImpl;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.json.simple.parser.ParseException;

public class YellowBrickTrackingAdapterImpl
implements YellowBrickTrackingAdapter {
    private static final Duration TIMEOUT_FOR_RACE_LOADING = Duration.ONE_MINUTE.times(2L);
    static final Duration DEFAULT_POLLING_INTERVAL = Duration.ONE_MINUTE.times(1L);
    private static final String BASE_URL_TEMPLATE = "https://yb.tl/API3/Race/%s/GetPositions";
    private static final String NUMBER_OF_POSITIONS_URL_TEMPLATE = "https://yb.tl/API3/Race/%s/GetPositions?n=%d";
    private static final String POSITIONS_SINCE_DATE_URL_TEMPLATE = "https://yb.tl/API3/Race/%s/GetPositions?t=%d";
    private final DomainFactory baseDomainFactory;
    private final ConcurrentMap<Util.Pair<String, String>, YellowBrickConfiguration> yellowBrickConfigurations;
    private final Set<YellowBrickConfigurationListener> yellowBrickConfigurationListeners;

    public YellowBrickTrackingAdapterImpl(DomainFactory baseDomainFactory) {
        this.baseDomainFactory = baseDomainFactory;
        this.yellowBrickConfigurations = new ConcurrentHashMap<Util.Pair<String, String>, YellowBrickConfiguration>();
        this.yellowBrickConfigurationListeners = Collections.synchronizedSet(new HashSet());
    }

    @Override
    public void addYellowBrickRace(RacingEventService service, RegattaIdentifier regattaToAddTo, String yellowBrickRaceUrl, RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, String creatorUsername, String raceUrl, boolean trackWind, boolean correctWindByDeclination) throws Exception {
        Util.Pair<String, String> configKey = this.getConfigKey(raceUrl, creatorUsername);
        YellowBrickConfiguration configuration = (YellowBrickConfiguration)this.yellowBrickConfigurations.get(configKey);
        service.addRace(regattaToAddTo, (RaceTrackingConnectivityParameters)new YellowBrickRaceTrackingConnectivityParams(yellowBrickRaceUrl, configuration == null ? null : configuration.getUsername(), configuration == null ? null : configuration.getPassword(), trackWind, correctWindByDeclination, raceLogStore, regattaLogStore, this.baseDomainFactory, this), TIMEOUT_FOR_RACE_LOADING.asMillis());
    }

    String getUrlForLatestFix(String raceUrl, Optional<String> username, Optional<String> password) {
        return this.appendUsernameAndPasswordParameters(String.format(NUMBER_OF_POSITIONS_URL_TEMPLATE, raceUrl, 1), username, password);
    }

    private String appendUsernameAndPasswordParameters(String url, Optional<String> username, Optional<String> password) {
        StringBuilder sb = new StringBuilder(url);
        this.appendOptionalParameter(sb, "username", username);
        this.appendOptionalParameter(sb, "password", password);
        return sb.toString();
    }

    private void appendOptionalParameter(StringBuilder urlBuilder, String parameterName, Optional<String> parameterValue) {
        if (parameterValue.isPresent() && Util.hasLength((String)parameterValue.get())) {
            urlBuilder.append("&");
            urlBuilder.append(parameterName);
            urlBuilder.append("=");
            try {
                urlBuilder.append(URLEncoder.encode(parameterValue.get(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    String getUrlForAllData(String raceUrl, Optional<String> username, Optional<String> password) {
        return this.getUrlForDataSinceTimePoint(raceUrl, TimePoint.BeginningOfTime, username, password);
    }

    private String getUrlForDataSinceTimePoint(String raceUrl, TimePoint since, Optional<String> username, Optional<String> password) {
        return this.appendUsernameAndPasswordParameters(String.format(POSITIONS_SINCE_DATE_URL_TEMPLATE, raceUrl, since.asMillis() / 1000L), username, password);
    }

    @Override
    public YellowBrickRace getRaceMetadata(String raceUrl, Optional<String> username, Optional<String> password) throws IOException, ParseException {
        String url = this.getUrlForLatestFix(raceUrl, username, password);
        PositionsDocument doc = this.getPositionsDocumentForUrl(url);
        return new YellowBrickRaceImpl(raceUrl, doc.getTimePointOfLastFix(), doc.getTeams());
    }

    private PositionsDocument getPositionsDocumentForUrl(String url) throws MalformedURLException, IOException, ParseException {
        URLConnection result = HttpUrlConnectionHelper.redirectConnectionWithBearerToken((URL)new URL(url), (Duration)TIMEOUT_FOR_RACE_LOADING, null);
        Charset charset = HttpUrlConnectionHelper.getCharsetFromConnectionOrDefault((URLConnection)result, (String)"UTF-8");
        InputStream inputStream = (InputStream)result.getContent();
        PositionsDocument doc = new GetPositionsParser().parse(new InputStreamReader(inputStream, charset), true);
        return doc;
    }

    @Override
    public PositionsDocument getPositionsSince(String raceUrl, TimePoint since, Optional<String> username, Optional<String> password) throws MalformedURLException, IOException, ParseException {
        return this.getPositionsDocumentForUrl(this.getUrlForDataSinceTimePoint(raceUrl, since, username, password));
    }

    @Override
    public PositionsDocument getStoredData(String raceUrl, Optional<String> username, Optional<String> password) throws MalformedURLException, IOException, ParseException {
        return this.getPositionsDocumentForUrl(this.getUrlForAllData(raceUrl, username, password));
    }

    @Override
    public YellowBrickConfiguration createYellowBrickConfiguration(String name, String raceUrl, String username, String password, String creatorName) {
        YellowBrickConfigurationImpl config = new YellowBrickConfigurationImpl(name, raceUrl, username, password, creatorName);
        this.addYellowBrickConfiguration(config);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addYellowBrickConfiguration(YellowBrickConfiguration yellowBrickConfig) {
        this.yellowBrickConfigurations.put(this.getConfigKey(yellowBrickConfig), yellowBrickConfig);
        Set<YellowBrickConfigurationListener> set = this.yellowBrickConfigurationListeners;
        synchronized (set) {
            for (YellowBrickConfigurationListener listener : this.yellowBrickConfigurationListeners) {
                listener.yellowBrickConfigurationAdded(yellowBrickConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeYellowBrickConfiguration(String raceUrl, String creatorName) {
        YellowBrickConfiguration removedConfig = (YellowBrickConfiguration)this.yellowBrickConfigurations.remove(this.getConfigKey(raceUrl, creatorName));
        if (removedConfig != null) {
            Set<YellowBrickConfigurationListener> set = this.yellowBrickConfigurationListeners;
            synchronized (set) {
                for (YellowBrickConfigurationListener listener : this.yellowBrickConfigurationListeners) {
                    listener.yellowBrickConfigurationRemoved(removedConfig);
                }
            }
        }
    }

    private Util.Pair<String, String> getConfigKey(YellowBrickConfiguration config) {
        return new Util.Pair((Object)config.getCreatorName(), (Object)config.getRaceUrl());
    }

    private Util.Pair<String, String> getConfigKey(String raceUrl, String creatorName) {
        return new Util.Pair((Object)creatorName, (Object)raceUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateYellowBrickConfiguration(String name, String raceUrl, String username, String password, String creatorName) {
        Util.Pair<String, String> configKey = this.getConfigKey(raceUrl, creatorName);
        YellowBrickConfiguration oldConfig = (YellowBrickConfiguration)this.yellowBrickConfigurations.get(configKey);
        YellowBrickConfigurationImpl updatedConfig = new YellowBrickConfigurationImpl(name, raceUrl, username, (String)(password == null ? (oldConfig == null ? null : oldConfig.getPassword()) : password), creatorName);
        this.yellowBrickConfigurations.put(configKey, updatedConfig);
        Set<YellowBrickConfigurationListener> set = this.yellowBrickConfigurationListeners;
        synchronized (set) {
            for (YellowBrickConfigurationListener listener : this.yellowBrickConfigurationListeners) {
                listener.yellowBrickConfigurationUpdated(updatedConfig);
            }
        }
    }

    @Override
    public void addYellowBrickConfigurationListener(YellowBrickConfigurationListener listener) {
        this.yellowBrickConfigurationListeners.add(listener);
    }

    @Override
    public void removeYellowBrickConfigurationListener(YellowBrickConfigurationListener listener) {
        this.yellowBrickConfigurationListeners.remove(listener);
    }

    @Override
    public Iterable<YellowBrickConfiguration> getYellowBrickConfigurations() {
        return this.yellowBrickConfigurations.values();
    }
}

