/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.yellowbrickadapter.impl;

import com.sap.sailing.competitorimport.CompetitorProvider;
import com.sap.sailing.domain.common.CompetitorDescriptor;
import com.sap.sailing.domain.common.dto.PersonDTO;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickTrackingAdapter;
import com.sap.sailing.resultimport.AbstractResultUrlProvider;
import com.sap.sailing.resultimport.ResultUrlRegistry;
import com.sap.sse.common.CountryCodeFactory;
import com.sap.sse.common.Util;
import com.sap.sse.i18n.impl.ResourceBundleStringMessagesImpl;
import com.sap.sse.util.CSVParser;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.JAXBException;

public class YellowBrickCompetitorProvider
extends AbstractResultUrlProvider
implements CompetitorProvider {
    private static final long serialVersionUID = -2577277045205748666L;
    private static final String STRING_MESSAGES_BASE_NAME = "stringmessages/StringMessages";
    private final ResourceBundleStringMessagesImpl stringMessages = new ResourceBundleStringMessagesImpl("stringmessages/StringMessages", ((Object)((Object)this)).getClass().getClassLoader());
    private final String RACE_NAME_HEADER = "Race Name";
    private final String SAIL_NUMBER_HEADER = "Sail Number";
    private final String MODEL_HEADER = "Model";
    private final String ENTRANT_HEADER = "Entrant";
    private final String COUNTRY_HEADER = "Country";
    private final String SKIPPER_HEADER = "Skipper";
    private final String IRC_TOT_HEADER = "IRC";
    private final String YELLOWBRICK_NAME_HEADER = "YellowBrick Name";
    private final String COMPETITOR_ID_HEADER = "Competitor ID";
    private final String CATEGORY_IRC_HEADER = "cat-IRC";
    private final String ORC_HEADER = "ORC only";

    public YellowBrickCompetitorProvider(ResultUrlRegistry resultUrlRegistry) {
        super(resultUrlRegistry);
    }

    public String getName() {
        return "YellowBrick Competitor Provider";
    }

    public Map<String, Set<String>> getHasCompetitorsForRegattasInEvent() throws IOException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (URL url : this.getReadableUrls()) {
            result.put(url.toString(), null);
        }
        return result;
    }

    public Iterable<CompetitorDescriptor> getCompetitorDescriptors(String eventNameWhichIsTheURL, String regattaNameWhichIsIgnored) throws JAXBException, IOException {
        HashSet<CompetitorDescriptor> result = new HashSet<CompetitorDescriptor>();
        URLConnection connection = HttpUrlConnectionHelper.redirectConnection((URL)new URL(eventNameWhichIsTheURL));
        Charset charset = HttpUrlConnectionHelper.getCharsetFromConnectionOrDefault((URLConnection)connection, (String)"UTF-8");
        InputStream inputStream = (InputStream)connection.getContent();
        CSVParser csvParser = new CSVParser();
        Util.Pair content = csvParser.parseWithHeader((Reader)new InputStreamReader(inputStream, charset));
        for (List competitorLine : (Iterable)content.getB()) {
            result.add(this.parseIntoCompetitorDescriptor((List)content.getA(), competitorLine));
        }
        return result;
    }

    private CompetitorDescriptor parseIntoCompetitorDescriptor(List<String> header, List<String> competitorLine) {
        String fleet;
        String race;
        String fullName = this.getStringFromCsv("Skipper", header, competitorLine);
        String shortName = this.getStringFromCsv("Entrant", header, competitorLine);
        String teamName = this.getStringFromCsv("Race Name", header, competitorLine);
        String countryCode = this.getStringFromCsv("Country", header, competitorLine);
        String ircToTString = this.getStringFromCsv("IRC", header, competitorLine);
        Double timeOnTimeFactor = Util.hasLength((String)ircToTString) ? Double.valueOf(ircToTString) : 1.0;
        String ybName = this.getStringFromCsv("YellowBrick Name", header, competitorLine);
        String boatId = YellowBrickTrackingAdapter.getBoatId(ybName);
        String competitorIdString = this.getStringFromCsv("Competitor ID", header, competitorLine);
        String competitorId = competitorIdString == null ? UUID.randomUUID().toString() : competitorIdString;
        String boatName = this.getStringFromCsv("Race Name", header, competitorLine);
        String boatClassName = this.getStringFromCsv("Model", header, competitorLine);
        String sailNumber = this.getStringFromCsv("Sail Number", header, competitorLine);
        Set<PersonDTO> persons = Collections.singleton(new PersonDTO(fullName, null, null, countryCode));
        String ircCategory = this.getStringFromCsv("cat-IRC", header, competitorLine);
        String orcOnly = this.getStringFromCsv("ORC only", header, competitorLine);
        if (Util.hasLength((String)orcOnly)) {
            if (ircCategory.equals("undefined")) {
                race = "ORC";
                fleet = "ORC";
            } else {
                race = "ORC/IRC";
                fleet = ircCategory;
            }
        } else {
            race = "IRC";
            fleet = ircCategory;
        }
        return new CompetitorDescriptor("", "", race, fleet, (Serializable)((Object)competitorId), Util.hasLength((String)fullName) ? fullName : boatName, shortName, teamName, persons, CountryCodeFactory.INSTANCE.getFromThreeLetterIOCName(countryCode), timeOnTimeFactor, null, (Serializable)((Object)boatId), boatName, boatClassName, sailNumber);
    }

    private String getStringFromCsv(String field, List<String> headers, List<String> parsedLine) {
        int index = headers.indexOf(field);
        String result = index >= parsedLine.size() ? null : parsedLine.get(index);
        return result;
    }

    public String getHint(Locale locale) {
        return this.stringMessages.get(locale, "CompetitorImportHint");
    }

    public URL resolveUrl(String url) throws MalformedURLException {
        return new URL(url);
    }

    public String getOptionalSampleURL() {
        return null;
    }
}

