/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.Activator;
import com.sap.sailing.datamining.SailingClusterGroups;
import com.sap.sailing.datamining.data.HasRaceOfCompetitorContext;
import com.sap.sailing.datamining.data.HasTackTypeSegmentContext;
import com.sap.sailing.datamining.data.HasTrackedRaceContext;
import com.sap.sailing.datamining.impl.components.TackTypeSegmentRetrievalProcessor;
import com.sap.sailing.datamining.impl.data.TackTypeRatioCollector;
import com.sap.sailing.datamining.shared.TackTypeSegmentsDataMiningSettings;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.LineDetails;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sailing.domain.tracking.impl.TimedComparator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.datamining.data.Cluster;
import com.sap.sse.datamining.shared.impl.dto.ClusterDTO;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;

public class RaceOfCompetitorWithContext
implements HasRaceOfCompetitorContext {
    private final HasTrackedRaceContext trackedRaceContext;
    private final Competitor competitor;
    private final TackTypeSegmentsDataMiningSettings settings;

    public RaceOfCompetitorWithContext(HasTrackedRaceContext trackedRaceContext, Competitor competitor, TackTypeSegmentsDataMiningSettings settings) {
        this.trackedRaceContext = trackedRaceContext;
        this.competitor = competitor;
        this.settings = settings;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.competitor == null ? 0 : this.competitor.hashCode());
        result = 31 * result + (this.trackedRaceContext == null ? 0 : this.trackedRaceContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RaceOfCompetitorWithContext other = (RaceOfCompetitorWithContext)obj;
        if (this.competitor == null ? other.competitor != null : !this.competitor.equals(other.competitor)) {
            return false;
        }
        return !(this.trackedRaceContext == null ? other.trackedRaceContext != null : !this.trackedRaceContext.equals(other.trackedRaceContext));
    }

    @Override
    public HasTrackedRaceContext getTrackedRaceContext() {
        return this.trackedRaceContext;
    }

    private TrackedRace getTrackedRace() {
        return this.getTrackedRaceContext().getTrackedRace();
    }

    @Override
    public Competitor getCompetitor() {
        return this.competitor;
    }

    @Override
    public Tack getTackAtStart() throws NoWindException {
        TimePoint startOfRace = this.getTrackedRace().getStartOfRace();
        return startOfRace == null ? null : this.getTrackedRace().getTack(this.getCompetitor(), startOfRace);
    }

    @Override
    public Boat getBoat() {
        Boat boatOfCompetitor = this.getTrackedRace().getBoatOfCompetitor(this.getCompetitor());
        return boatOfCompetitor;
    }

    @Override
    public ClusterDTO getPercentageClusterForDistanceToStarboardSideAtStart() {
        Double normalizedDistance = this.getNormalizedDistanceToStarboardSideAtStartOfCompetitor();
        if (normalizedDistance == null) {
            return null;
        }
        SailingClusterGroups clusterGroups = Activator.getClusterGroups();
        Cluster cluster = clusterGroups.getPercentageClusterGroup().getClusterFor((Serializable)normalizedDistance);
        return new ClusterDTO(clusterGroups.getPercentageClusterFormatter().format(cluster));
    }

    @Override
    public Distance getDistanceToStartLineAtStart() {
        return this.getTrackedRace().getDistanceToStartLine(this.getCompetitor(), 0L);
    }

    @Override
    public Double getNormalizedDistanceToStarboardSideAtStartOfCompetitor() {
        TrackedRace trackedRace = this.getTrackedRace();
        TrackedLegOfCompetitor firstTrackedLegOfCompetitor = trackedRace.getTrackedLeg(this.competitor, trackedRace.getRace().getCourse().getFirstLeg());
        TimePoint competitorStartTime = firstTrackedLegOfCompetitor.getStartTime();
        if (competitorStartTime == null) {
            return null;
        }
        Double distance = trackedRace.getDistanceFromStarboardSideOfStartLine(this.getCompetitor(), competitorStartTime).getMeters();
        Double length = trackedRace.getStartLine(competitorStartTime).getLength().getMeters();
        return distance / length;
    }

    @Override
    public Util.Pair<Double, Integer> getNormalizedDistanceToStarboardSideAtStartOfCompetitorVsRankAtFirstMark() {
        return new Util.Pair((Object)this.getNormalizedDistanceToStarboardSideAtStartOfCompetitor(), (Object)this.getRankAtFirstMark());
    }

    @Override
    public Distance getWindwardDistanceToAdvantageousLineEndAtStartofRace() {
        return this.getTrackedRace().getWindwardDistanceToFavoredSideOfStartLine(this.getCompetitor(), 0L);
    }

    @Override
    public Distance getWindwardDistanceToAdvantageousLineEndAtStartofCompetitor() {
        TimePoint competitorStartTime = this.getCompetitorStartTime();
        Distance result = competitorStartTime == null ? null : this.getTrackedRace().getWindwardDistanceToFavoredSideOfStartLine(this.getCompetitor(), competitorStartTime);
        return result;
    }

    private TimePoint getCompetitorStartTime() {
        TrackedLegOfCompetitor firstTrackedLegOfCompetitor = this.getFirstLegOfCompetitor();
        TimePoint competitorStartTime = firstTrackedLegOfCompetitor.getStartTime();
        return competitorStartTime;
    }

    @Override
    public Distance getAbsoluteWindwardDistanceToStarboardSideAtStartOfCompetitor() {
        Distance result;
        TimePoint competitorStartTime = this.getCompetitorStartTime();
        if (competitorStartTime == null) {
            result = null;
        } else {
            TimePoint startOfRace;
            TrackedRace trackedRace = this.getTrackedRace();
            LineDetails startLine = trackedRace.getStartLine(startOfRace = trackedRace.getStartOfRace());
            Mark starboardMark = startLine.getStarboardMarkWhileApproachingLine();
            if (starboardMark == null) {
                return null;
            }
            GPSFixTrack starboardMarkTrack = trackedRace.getOrCreateTrack(starboardMark);
            Position starboardMarkPosition = starboardMarkTrack.getEstimatedPosition(startOfRace, false);
            GPSFixTrack competitorTrack = trackedRace.getTrack(this.getCompetitor());
            Position competitorPosition = competitorTrack.getEstimatedPosition(startOfRace, false);
            TrackedLeg trackedLeg = trackedRace.getTrackedLeg(trackedRace.getRace().getCourse().getFirstLeg());
            result = trackedLeg.getAbsoluteWindwardDistance(competitorPosition, starboardMarkPosition, startOfRace, WindPositionMode.LEG_MIDDLE);
        }
        return result;
    }

    @Override
    public ClusterDTO getPercentageClusterForRelativeScore() {
        Double relativeScore = this.getTrackedRaceContext().getRelativeScoreForCompetitor(this.getCompetitor());
        if (relativeScore == null) {
            return null;
        }
        SailingClusterGroups clusterGroups = Activator.getClusterGroups();
        Cluster cluster = clusterGroups.getPercentageClusterGroup().getClusterFor((Serializable)relativeScore);
        return new ClusterDTO(clusterGroups.getPercentageClusterFormatter().format(cluster));
    }

    @Override
    public MaxPointsReason getMaxPointsReason() {
        return this.getTrackedRaceContext().getLeaderboardContext().getLeaderboard().getMaxPointsReason(this.competitor, this.getTrackedRaceContext().getRaceColumn(), MillisecondsTimePoint.now());
    }

    @Override
    public boolean isDiscarded() {
        return this.getTrackedRaceContext().getLeaderboardContext().getLeaderboard().isDiscarded(this.competitor, this.getTrackedRaceContext().getRaceColumn(), MillisecondsTimePoint.now());
    }

    @Override
    public Speed getSpeedWhenStarting() {
        return this.getTrackedRace().getSpeedWhenCrossingStartLine(this.getCompetitor());
    }

    @Override
    public Duration getStartDelay() {
        NavigableSet competitorMarkPassings = this.getTrackedRace().getMarkPassings(this.competitor);
        this.getTrackedRace().lockForRead((Iterable)competitorMarkPassings);
        try {
            Duration result;
            TimePoint startOfRace;
            if (!competitorMarkPassings.isEmpty() && (startOfRace = this.getTrackedRace().getStartOfRace()) != null) {
                MarkPassing firstMarkPassing = (MarkPassing)competitorMarkPassings.iterator().next();
                TimePoint competitorStartTime = firstMarkPassing.getTimePoint();
                result = startOfRace.until(competitorStartTime);
            } else {
                result = null;
            }
            Duration duration = result;
            return duration;
        }
        finally {
            this.getTrackedRace().unlockAfterRead((Iterable)competitorMarkPassings);
        }
    }

    @Override
    public Speed getSpeedTenSecondsBeforeStart() {
        return this.getTrackedRace().getSpeed(this.getCompetitor(), TimeUnit.SECONDS.toMillis(10L));
    }

    @Override
    public Speed getSpeedTenSecondsAfterStartOfRace() {
        TimePoint startOfRace = this.getTrackedRace().getStartOfRace();
        if (startOfRace == null) {
            return null;
        }
        return this.getTrackOfCompetitor().getEstimatedSpeed(startOfRace.plus(TimeUnit.SECONDS.toMillis(10L)));
    }

    @Override
    public Double getRankAfterHalfOfTheFirstLeg() {
        Course course = this.getTrackedRace().getRace().getCourse();
        TrackedLegOfCompetitor trackedLeg = this.getTrackedRace().getTrackedLeg(this.getCompetitor(), course.getFirstLeg());
        TimePoint startTime = trackedLeg.getStartTime();
        TimePoint finishTime = trackedLeg.getFinishTime();
        if (startTime == null || finishTime == null) {
            return null;
        }
        long halfOffset = (finishTime.asMillis() - startTime.asMillis()) / 2L;
        int rank = this.getTrackedRace().getRank(this.getCompetitor(), startTime.plus(halfOffset));
        return rank == 0 ? null : Double.valueOf(rank);
    }

    @Override
    public Integer getRankAtFirstMark() {
        Course course = this.getTrackedRace().getRace().getCourse();
        Waypoint firstMark = course.getFirstLeg().getTo();
        Competitor competitor = this.getCompetitor();
        MarkPassing markPassing = this.getTrackedRace().getMarkPassing(competitor, firstMark);
        int rank = markPassing == null ? 0 : this.getTrackedRace().getRank(competitor, markPassing.getTimePoint());
        return rank == 0 ? null : Integer.valueOf(rank);
    }

    @Override
    public Integer getRankGainsOrLossesBetweenFirstMarkAndFinish() {
        Integer rankAtFirstMark = this.getRankAtFirstMark();
        Integer rankAtFinish = this.getTrackedRaceContext().getRankAtFinishForCompetitor(this.getCompetitor());
        return rankAtFirstMark != null && rankAtFinish != null ? Integer.valueOf(rankAtFirstMark - rankAtFinish) : null;
    }

    @Override
    public int getNumberOfManeuvers() {
        HashSet<ManeuverType> maneuverTypes = new HashSet<ManeuverType>();
        maneuverTypes.add(ManeuverType.TACK);
        maneuverTypes.add(ManeuverType.JIBE);
        return this.getNumberOf(maneuverTypes);
    }

    @Override
    public int getNumberOfTacks() {
        return this.getNumberOf(Collections.singleton(ManeuverType.TACK));
    }

    @Override
    public int getNumberOfJibes() {
        return this.getNumberOf(Collections.singleton(ManeuverType.JIBE));
    }

    @Override
    public int getNumberOfPenaltyCircles() {
        return this.getNumberOf(Collections.singleton(ManeuverType.PENALTY_CIRCLE));
    }

    private int getNumberOf(Set<ManeuverType> maneuverTypes) {
        int number = 0;
        TrackedRace trackedRace = this.getTrackedRace();
        if (trackedRace != null) {
            TimePoint from = null;
            TimePoint to = null;
            Competitor competitor = this.getCompetitor();
            Course course = trackedRace.getRace().getCourse();
            List waypoints = Util.asList((Iterable)course.getWaypoints());
            int fromIndex = 0;
            while (fromIndex < waypoints.size()) {
                TimePoint passingTime;
                MarkPassing markPassing = trackedRace.getMarkPassing(competitor, (Waypoint)waypoints.get(fromIndex));
                TimePoint timePoint = passingTime = markPassing != null ? markPassing.getTimePoint() : null;
                if (passingTime != null) {
                    if (from == null) {
                        from = passingTime;
                    } else {
                        to = passingTime;
                    }
                }
                ++fromIndex;
            }
            if (from != null && to != null) {
                for (Maneuver maneuver : trackedRace.getManeuvers(this.getCompetitor(), from, to, false)) {
                    if (!maneuverTypes.contains(maneuver.getType())) continue;
                    ++number;
                }
            }
        }
        return number;
    }

    @Override
    public Distance getDistanceTraveled() {
        return this.getTrackedRace().getDistanceTraveledIncludingGateStart(this.getCompetitor(), MillisecondsTimePoint.now());
    }

    @Override
    public Distance getLineLengthAtStart() {
        TrackedLegOfCompetitor firstTrackedLegOfCompetitor = this.getFirstLegOfCompetitor();
        TimePoint competitorStartTime = firstTrackedLegOfCompetitor.getStartTime();
        if (competitorStartTime == null) {
            return null;
        }
        return this.getTrackedRace().getStartLine(competitorStartTime).getLength();
    }

    @Override
    public Util.Pair<Double, Integer> getRelativeDistanceToStarboardSideAtStartOfCompetitorVsFinalRank() {
        return new Util.Pair((Object)this.getNormalizedDistanceToStarboardSideAtStartOfCompetitor(), (Object)this.getTrackedRaceContext().getRankAtFinishForCompetitor(this.getCompetitor()));
    }

    @Override
    public Util.Pair<Double, Double> getWindwardDistanceToAdvantageousEndOfLineAtStartOfRaceVsRelativeDistanceToAdvantageousEndOfLineAtStartOfRace() {
        return new Util.Pair((Object)this.getWindwardDistanceToAdvantageousLineEndAtStartofRace().getMeters(), (Object)this.getRelativeDistanceToAdvantageousEndOfLineAtStartOfRace());
    }

    @Override
    public Double getRelativeDistanceToAdvantageousEndOfLineAtStartOfRace() {
        TimePoint startOfRace = this.getTrackedRace().getStartOfRace();
        return this.getRelativeDistanceToAdvantageousEndOfLine(startOfRace);
    }

    @Override
    public Double getRelativeDistanceToAdvantageousEndOfLineAtStartOfCompetitor() {
        TimePoint competitorStartTimePoint = this.getTrackedRace().getTrackedLeg(this.getCompetitor(), this.getTrackedRace().getRace().getCourse().getFirstLeg()).getStartTime();
        return this.getRelativeDistanceToAdvantageousEndOfLine(competitorStartTimePoint);
    }

    private Double getRelativeDistanceToAdvantageousEndOfLine(TimePoint timePoint) {
        LineDetails startLine = this.getTrackedRace().getStartLine(timePoint);
        Mark advantageousMark = null;
        switch (startLine.getAdvantageousSideWhileApproachingLine()) {
            case PORT: {
                advantageousMark = startLine.getPortMarkWhileApproachingLine();
                break;
            }
            case STARBOARD: {
                advantageousMark = startLine.getStarboardMarkWhileApproachingLine();
            }
        }
        if (advantageousMark == null) {
            return null;
        }
        GPSFixTrack advantageousMarkTrack = this.getTrackedRace().getOrCreateTrack(advantageousMark);
        Position advantageousMarkPosition = advantageousMarkTrack.getEstimatedPosition(timePoint, false);
        GPSFixTrack competitorTrack = this.getTrackedRace().getTrack(this.getCompetitor());
        Position competitorPosition = competitorTrack.getEstimatedPosition(timePoint, false);
        Double distance = competitorPosition.getDistance(advantageousMarkPosition).getMeters();
        TrackedLegOfCompetitor firstTrackedLegOfCompetitor = this.getTrackedRace().getTrackedLeg(this.competitor, this.getTrackedRace().getRace().getCourse().getFirstLeg());
        TimePoint competitorStartTime = firstTrackedLegOfCompetitor.getStartTime();
        Double length = this.getTrackedRace().getStartLine(competitorStartTime).getLength().getMeters();
        return distance / length;
    }

    @Override
    public Duration getDuration() {
        MillisecondsDurationImpl duration = null;
        TrackedRace race = this.getTrackedRace();
        Course course = race.getRace().getCourse();
        MarkPassing startPassing = race.getMarkPassing(this.competitor, course.getFirstWaypoint());
        MarkPassing finishPassing = race.getMarkPassing(this.competitor, course.getLastWaypoint());
        if (startPassing != null && finishPassing != null) {
            long durationMillis = finishPassing.getTimePoint().asMillis() - startPassing.getTimePoint().asMillis();
            duration = new MillisecondsDurationImpl(durationMillis);
        }
        return duration;
    }

    @Override
    public Duration getDurationFromStartToFirstTack() {
        Duration result;
        TrackedRace race = this.getTrackedRace();
        if (race.getStartOfRace() == null) {
            result = null;
        } else {
            Iterable maneuvers = race.getManeuvers(this.competitor, false);
            List tacks = Util.asList((Iterable)Util.filter((Iterable)maneuvers, m -> m.getType() == ManeuverType.TACK && !m.getTimePoint().before(race.getStartOfRace())));
            if (tacks.isEmpty()) {
                result = null;
            } else {
                tacks.sort(TimedComparator.INSTANCE);
                result = race.getStartOfRace().until(((Maneuver)tacks.get(0)).getTimePoint());
            }
        }
        return result;
    }

    @Override
    public Double getRelativeDistanceToStarboardSideAtStartOfRace() {
        TrackedRace trackedRace = this.getTrackedRace();
        TrackedLegOfCompetitor firstTrackedLegOfCompetitor = trackedRace.getTrackedLeg(this.competitor, trackedRace.getRace().getCourse().getFirstLeg());
        TimePoint competitorStartTime = firstTrackedLegOfCompetitor.getStartTime();
        if (competitorStartTime == null) {
            return null;
        }
        return this.getNormalizeDistanceToStarboardSideAtTimePoint(this.getStartOfRace());
    }

    @Override
    public Speed getVMG5SecondsBeforeStartOfRace() {
        return this.getTrackedRace().getVelocityMadeGood(this.getCompetitor(), this.getStartOfRace().minus(TimeUnit.SECONDS.toMillis(5L)));
    }

    @Override
    public Speed getVMGAtStartOfRace() {
        return this.getTrackedRace().getVelocityMadeGood(this.getCompetitor(), this.getStartOfRace());
    }

    @Override
    public Speed getVMG5SecondsAfterStartOfRace() {
        return this.getTrackedRace().getVelocityMadeGood(this.getCompetitor(), this.getStartOfRace().plus(TimeUnit.SECONDS.toMillis(5L)));
    }

    @Override
    public Util.Pair<Double, Integer> getRelativeDistanceToAdvantageousSideAtStartOfRaceVsRankAtFirstMark() {
        return new Util.Pair((Object)this.getRelativeDistanceToAdvantageousEndOfLineAtStartOfRace(), (Object)this.getRankAtFirstMark());
    }

    @Override
    public Util.Pair<Integer, Integer> getRankAtFirstMarkVsFinalRank() {
        return new Util.Pair((Object)this.getRankAtFirstMark(), (Object)this.getFinalRank());
    }

    @Override
    public Integer getRankThirtySecondsAfterStartOfRace() {
        return this.getRankAt(this.getStartOfRace().plus(TimeUnit.SECONDS.toMillis(30L)));
    }

    @Override
    public Integer getRankSixtySecondsAfterStartOfRace() {
        return this.getRankAt(this.getStartOfRace().plus(TimeUnit.SECONDS.toMillis(60L)));
    }

    @Override
    public Integer getRankNinetySecondsAfterStartOfRace() {
        return this.getRankAt(this.getStartOfRace().plus(TimeUnit.SECONDS.toMillis(90L)));
    }

    @Override
    public Integer getFinalRank() {
        if (this.getEndOfRace() == null) {
            return null;
        }
        return this.getRankAt(this.getEndOfRace());
    }

    @Override
    public Util.Pair<Double, Integer> getRelativeDistanceToAdvantageousSideAtStartOfRaceVsFinalRank() {
        return new Util.Pair((Object)this.getRelativeDistanceToAdvantageousEndOfLineAtStartOfRace(), (Object)this.getFinalRank());
    }

    @Override
    public Speed getAverageRaceWindSpeed() {
        return (Speed)this.getTrackedRace().getAverageWindSpeedWithConfidence(5000L).getObject();
    }

    private GPSFixTrack<Competitor, GPSFixMoving> getTrackOfCompetitor() {
        return this.getTrackedRace().getTrack(this.getCompetitor());
    }

    private TrackedLegOfCompetitor getFirstLegOfCompetitor() {
        return this.getTrackedRace().getTrackedLeg(this.competitor, this.getTrackedRace().getRace().getCourse().getFirstLeg());
    }

    private TimePoint getStartOfRace() {
        return this.getTrackedRace().getStartOfRace();
    }

    private TimePoint getEndOfRace() {
        return this.getTrackedRace().getEndOfRace();
    }

    private Double getNormalizeDistanceToStarboardSideAtTimePoint(TimePoint timepoint) {
        Double distance = this.getTrackedRace().getDistanceFromStarboardSideOfStartLine(this.getCompetitor(), timepoint).getMeters();
        Double length = this.getTrackedRace().getStartLine(timepoint).getLength().getMeters();
        return distance / length;
    }

    @Override
    public Distance getDistanceFromStarboardSideOfStartLineProjectedOntoLineAtStartOfRace() {
        return this.getTrackedRace().getDistanceFromStarboardSideOfStartLineProjectedOntoLine(this.getCompetitor(), this.getStartOfRace());
    }

    @Override
    public Distance getDistanceToNextBoatToStarboardProjectedToStartLineAtStartOfRace() {
        Distance result;
        SortedMap competitorsSortedByDistanceFromStarboardSideOfStartLineProjectedOntoLine = this.getTrackedRace().getDistancesFromStarboardSideOfStartLineProjectedOntoLine(this.getStartOfRace(), this.getMaxPointsReasonSupplier());
        Competitor competitorImmediatelyToStarboard = this.getTrackedRace().getNextCompetitorToStarboardOnStartLine(this.getCompetitor(), this.getStartOfRace(), this.getMaxPointsReasonSupplier());
        if (competitorImmediatelyToStarboard == null) {
            result = (Distance)competitorsSortedByDistanceFromStarboardSideOfStartLineProjectedOntoLine.get(this.getCompetitor());
        } else {
            Distance competitorDistance = (Distance)competitorsSortedByDistanceFromStarboardSideOfStartLineProjectedOntoLine.get(this.getCompetitor());
            if (competitorDistance == null) {
                result = null;
            } else {
                Distance distanceToStarboardEndOfLineProjectedOntoLineOfCompetitorImmediatelyToStarboard = (Distance)competitorsSortedByDistanceFromStarboardSideOfStartLineProjectedOntoLine.get(competitorImmediatelyToStarboard);
                result = competitorDistance.add(distanceToStarboardEndOfLineProjectedOntoLineOfCompetitorImmediatelyToStarboard.scale(-1.0));
            }
        }
        return result;
    }

    @Override
    public Distance getTotalDistanceToNeighboursProjectedToStartLineAtStartOfRace() {
        Distance toPort = this.getDistanceToNextBoatToPortProjectedToStartLineAtStartOfRace();
        Distance toStarboard = this.getDistanceToNextBoatToStarboardProjectedToStartLineAtStartOfRace();
        return toPort == null || toStarboard == null ? null : toPort.add(toStarboard);
    }

    @Override
    public Distance getTotalWindwardDistanceToNeighboursAtStartOfRace() {
        Distance toPort = this.getWindwardDistanceToNextBoatToPortAtStartOfRace();
        Distance toStarboard = this.getWindwardDistanceToNextBoatToStarboardAtStartOfRace();
        return toPort == null || toStarboard == null ? null : toPort.abs().add(toStarboard.abs());
    }

    @Override
    public Distance getTotalDistanceToNeighboursPerpendicularToStarLineAtStartOfRace() {
        Distance toPort = this.getDistanceToNextBoatToPortPerpendicularToStartLineAtStartOfRace();
        Distance toStarboard = this.getDistanceToNextBoatToStarboardPerpendicularToStartLineAtStartOfRace();
        return toPort == null || toStarboard == null ? null : toPort.abs().add(toStarboard.abs());
    }

    @Override
    public Distance getDistanceToNextBoatToPortProjectedToStartLineAtStartOfRace() {
        Distance result;
        SortedMap competitorsSortedByDistanceFromStarboardSideOfStartLineProjectedOntoLine = this.getTrackedRace().getDistancesFromStarboardSideOfStartLineProjectedOntoLine(this.getStartOfRace(), this.getMaxPointsReasonSupplier());
        Distance competitorDistance = (Distance)competitorsSortedByDistanceFromStarboardSideOfStartLineProjectedOntoLine.get(this.getCompetitor());
        Competitor competitorImmediatelyToPort = this.getTrackedRace().getNextCompetitorToPortOnStartLine(this.getCompetitor(), this.getStartOfRace(), this.getMaxPointsReasonSupplier());
        if (competitorImmediatelyToPort == null) {
            LineDetails startLine = this.getTrackedRace().getStartLine(this.getStartOfRace());
            result = competitorDistance == null || startLine == null ? null : startLine.getLength().add(competitorDistance.scale(-1.0));
        } else if (competitorDistance == null) {
            result = null;
        } else {
            Distance distanceToStarboardEndOfLineProjectedOntoLineOfCompetitorImmediatelyToPort = (Distance)competitorsSortedByDistanceFromStarboardSideOfStartLineProjectedOntoLine.get(competitorImmediatelyToPort);
            result = distanceToStarboardEndOfLineProjectedOntoLineOfCompetitorImmediatelyToPort.add(competitorDistance.scale(-1.0));
        }
        return result;
    }

    private Distance getWindwardDistanceToOtherCompetitorAtRaceStart(Competitor other) {
        Distance result;
        Position competitorPosition = this.getTrackedRace().getTrack(this.getCompetitor()).getEstimatedPosition(this.getStartOfRace(), true);
        Position neighborPosition = this.getTrackedRace().getTrack(other).getEstimatedPosition(this.getStartOfRace(), true);
        if (competitorPosition == null || neighborPosition == null) {
            result = null;
        } else {
            Iterable trackedLegs = this.getTrackedRace().getTrackedLegs();
            if (Util.isEmpty((Iterable)trackedLegs)) {
                result = null;
            } else {
                TrackedLeg firstLeg = (TrackedLeg)trackedLegs.iterator().next();
                result = firstLeg.getWindwardDistance(neighborPosition, competitorPosition, this.getStartOfRace(), WindPositionMode.LEG_MIDDLE);
            }
        }
        return result;
    }

    @Override
    public Distance getWindwardDistanceToNextBoatToPortAtStartOfRace() {
        Competitor competitorImmediatelyToPort = this.getTrackedRace().getNextCompetitorToPortOnStartLine(this.getCompetitor(), this.getStartOfRace(), this.getMaxPointsReasonSupplier());
        Distance result = competitorImmediatelyToPort == null ? null : this.getWindwardDistanceToOtherCompetitorAtRaceStart(competitorImmediatelyToPort);
        return result;
    }

    @Override
    public Distance getWindwardDistanceToNextBoatToStarboardAtStartOfRace() {
        Competitor competitorImmediatelyToStarboard = this.getTrackedRace().getNextCompetitorToStarboardOnStartLine(this.getCompetitor(), this.getStartOfRace(), this.getMaxPointsReasonSupplier());
        Distance result = competitorImmediatelyToStarboard == null ? null : this.getWindwardDistanceToOtherCompetitorAtRaceStart(competitorImmediatelyToStarboard);
        return result;
    }

    private Distance getDistanceToOtherCompetitorAtRaceStartPerpendicularToStartLine(Competitor other) {
        Util.Pair startLineBearingAndStarboardMarkPosition;
        Position competitorPosition = this.getTrackedRace().getTrack(this.getCompetitor()).getEstimatedPosition(this.getStartOfRace(), true);
        Position neighborPosition = this.getTrackedRace().getTrack(other).getEstimatedPosition(this.getStartOfRace(), true);
        Distance result = competitorPosition == null || neighborPosition == null ? null : ((startLineBearingAndStarboardMarkPosition = this.getTrackedRace().getStartLineBearingAndStarboardMarkPosition(this.getStartOfRace())).getA() == null ? null : competitorPosition.crossTrackError(neighborPosition, (Bearing)startLineBearingAndStarboardMarkPosition.getA()));
        return result;
    }

    private BiFunction<Competitor, TimePoint, MaxPointsReason> getMaxPointsReasonSupplier() {
        Leaderboard leaderboard = this.getTrackedRaceContext().getLeaderboardContext().getLeaderboard();
        return (competitor, timePoint) -> leaderboard.getMaxPointsReason(competitor, this.getTrackedRaceContext().getRaceColumn(), timePoint);
    }

    @Override
    public Distance getDistanceToNextBoatToPortPerpendicularToStartLineAtStartOfRace() {
        Competitor competitorImmediatelyToPort = this.getTrackedRace().getNextCompetitorToPortOnStartLine(this.getCompetitor(), this.getStartOfRace(), this.getMaxPointsReasonSupplier());
        Distance result = competitorImmediatelyToPort == null ? null : this.getDistanceToOtherCompetitorAtRaceStartPerpendicularToStartLine(competitorImmediatelyToPort);
        return result;
    }

    @Override
    public Distance getDistanceToNextBoatToStarboardPerpendicularToStartLineAtStartOfRace() {
        Competitor competitorImmediatelyToStarboard = this.getTrackedRace().getNextCompetitorToStarboardOnStartLine(this.getCompetitor(), this.getStartOfRace(), this.getMaxPointsReasonSupplier());
        Distance result = competitorImmediatelyToStarboard == null ? null : this.getDistanceToOtherCompetitorAtRaceStartPerpendicularToStartLine(competitorImmediatelyToStarboard);
        return result;
    }

    @Override
    public Double getNormalizedDistanceFromStarboardSideOfStartLineProjectedOntoLineAtStartOfRace() {
        LineDetails startLine = this.getTrackedRace().getStartLine(this.getStartOfRace());
        Double result = startLine == null ? null : Double.valueOf(this.getTrackedRace().getDistanceFromStarboardSideOfStartLineProjectedOntoLine(this.getCompetitor(), this.getStartOfRace()).divide(startLine.getLength()));
        return result;
    }

    private Integer getRankAt(TimePoint timePoint) {
        TimePoint startOfRace = this.getStartOfRace();
        if (startOfRace == null) {
            return null;
        }
        Integer rank = this.getTrackedRace().getRank(this.getCompetitor(), timePoint);
        return rank == 0 ? null : rank;
    }

    @Override
    public double getRatioDurationLongVsShortTack() {
        TackTypeRatioCollector<Duration> resultProcessor = new TackTypeRatioCollector<Duration>(Duration.NULL){

            @Override
            protected Duration add(Duration a, Duration b) {
                return a.plus(b);
            }

            @Override
            protected double divide(Duration a, Duration b) {
                return a.divide(b);
            }

            @Override
            protected Duration getAddable(HasTackTypeSegmentContext element) {
                return element.getDuration();
            }
        };
        TackTypeSegmentRetrievalProcessor tackTypeSegmentRetriever = new TackTypeSegmentRetrievalProcessor(null, Collections.emptySet(), this.settings, 0, "TackTypeSegments");
        return Util.stream(tackTypeSegmentRetriever.retrieveData(this)).collect(resultProcessor);
    }

    @Override
    public double getRatioDistanceLongVsShortTack() {
        TackTypeRatioCollector<Distance> resultProcessor = new TackTypeRatioCollector<Distance>((Distance)Distance.NULL){

            @Override
            protected Distance add(Distance a, Distance b) {
                return a.add(b);
            }

            @Override
            protected double divide(Distance a, Distance b) {
                return a.divide(b);
            }

            @Override
            protected Distance getAddable(HasTackTypeSegmentContext element) {
                return element.getDistance();
            }
        };
        TackTypeSegmentRetrievalProcessor tackTypeSegmentRetriever = new TackTypeSegmentRetrievalProcessor(null, Collections.emptySet(), this.settings, 0, "TackTypeSegments");
        return Util.stream(tackTypeSegmentRetriever.retrieveData(this)).collect(resultProcessor);
    }
}

