/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.data;

import com.sap.sailing.datamining.data.HasGPSFixContext;
import com.sap.sailing.datamining.data.HasTrackedLegOfCompetitorContext;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.TackType;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import java.util.function.BiFunction;

public class GPSFixWithContext
implements HasGPSFixContext {
    private static final long serialVersionUID = -2808861038064003352L;
    private final HasTrackedLegOfCompetitorContext trackedLegOfCompetitorContext;
    private final GPSFixMoving gpsFix;
    private Wind wind;

    public GPSFixWithContext(HasTrackedLegOfCompetitorContext trackedLegOfCompetitorContext, GPSFixMoving gpsFix) {
        this.trackedLegOfCompetitorContext = trackedLegOfCompetitorContext;
        this.gpsFix = gpsFix;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.gpsFix == null ? 0 : this.gpsFix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GPSFixWithContext other = (GPSFixWithContext)obj;
        return !(this.gpsFix == null ? other.gpsFix != null : !this.gpsFix.equals(other.gpsFix));
    }

    public TimePoint getTimePoint() {
        return this.getGPSFix().getTimePoint();
    }

    @Override
    public Wind getWindInternal() {
        return this.wind;
    }

    @Override
    public void setWindInternal(Wind wind) {
        this.wind = wind;
    }

    public Position getPosition() {
        return this.getGPSFix().getPosition();
    }

    @Override
    public TrackedRace getTrackedRace() {
        return this.getTrackedLegOfCompetitorContext().getTrackedRace();
    }

    @Override
    public HasTrackedLegOfCompetitorContext getTrackedLegOfCompetitorContext() {
        return this.trackedLegOfCompetitorContext;
    }

    @Override
    public GPSFixMoving getGPSFix() {
        return this.gpsFix;
    }

    @Override
    public Bearing getTrueWindAngle() throws NoWindException {
        return this.getTrackedRace().getTWA(this.getTrackedLegOfCompetitorContext().getCompetitor(), this.getTimePoint());
    }

    @Override
    public Bearing getAbsoluteTrueWindAngle() throws NoWindException {
        return this.getTrackedRace().getTWA(this.getTrackedLegOfCompetitorContext().getCompetitor(), this.getTimePoint()).abs();
    }

    @Override
    public SpeedWithBearing getVelocityMadeGood() {
        return this.getTrackedRace().getVelocityMadeGood(this.getTrackedLegOfCompetitorContext().getCompetitor(), this.getTimePoint());
    }

    @Override
    public Distance getXTE() {
        return this.getTrackedLegOfCompetitorContext().getTrackedLegOfCompetitor().getSignedCrossTrackError(this.getTimePoint());
    }

    @Override
    public Distance getAbsoluteXTE() {
        return this.getTrackedLegOfCompetitorContext().getTrackedLegOfCompetitor().getAbsoluteCrossTrackError(this.getTimePoint());
    }

    @Override
    public Double getRelativeXTESigned() {
        return this.getRelativeXTE(TrackedLegOfCompetitor::getSignedCrossTrackError);
    }

    private Double getRelativeXTE(BiFunction<TrackedLegOfCompetitor, TimePoint, Distance> xteFunction) {
        Distance legLength;
        Distance xte = xteFunction.apply(this.getTrackedLegOfCompetitorContext().getTrackedLegOfCompetitor(), this.getTimePoint());
        Double result = xte == null ? null : ((legLength = this.getTrackedLegOfCompetitorContext().getTrackedLegContext().getTrackedLeg().getGreatCircleDistance(this.getTimePoint())) == null ? null : Double.valueOf(xte.divide(legLength) * 2.0));
        return result;
    }

    @Override
    public Double getRelativeXTEUnsigned() {
        return this.getRelativeXTE(TrackedLegOfCompetitor::getAbsoluteCrossTrackError);
    }

    @Override
    public TackType getTackType() throws NoWindException {
        return this.getTrackedLegOfCompetitorContext().getTrackedLegOfCompetitor().getTackType(this.getTimePoint());
    }

    @Override
    public Speed getSmoothedSpeed() {
        SpeedWithBearing result = this.getGPSFix().isEstimatedSpeedCached() ? this.getGPSFix().getCachedEstimatedSpeed() : this.getTrackedLegOfCompetitorContext().getTrackedRace().getTrack(this.getTrackedLegOfCompetitorContext().getCompetitor()).getEstimatedSpeed(this.getTimePoint());
        return result;
    }

    @Override
    public Integer getTenthOfLeg() {
        Distance windwardDistanceToGo = this.getTrackedLegOfCompetitorContext().getTrackedLegOfCompetitor().getWindwardDistanceToGo(this.getGPSFix().getTimePoint(), WindPositionMode.LEG_MIDDLE);
        Distance legWindwardDistance = this.getTrackedLegOfCompetitorContext().getTrackedLegOfCompetitor().getTrackedLeg().getWindwardDistance();
        double fractionSailed = Math.max(0.0, legWindwardDistance.add(windwardDistanceToGo.scale(-1.0)).divide(legWindwardDistance));
        return (int)Math.min(10.0, 1.0 + 10.0 * fractionSailed);
    }

    @Override
    public Distance getXTEToWindAxisUnsigned() {
        return this.getTrackedLegOfCompetitorContext().getTrackedLegOfCompetitor().getUnsignedCrossTrackErrorToWindAxis(this.getTimePoint());
    }

    @Override
    public Distance getXTEToWindAxisSigned() {
        return this.getTrackedLegOfCompetitorContext().getTrackedLegOfCompetitor().getSignedCrossTrackErrorToWindAxis(this.getTimePoint());
    }

    @Override
    public Double getXTEToWindAxisRelativeUnsigned() {
        return this.getRelativeXTE(TrackedLegOfCompetitor::getUnsignedCrossTrackErrorToWindAxis);
    }

    @Override
    public Double getXTEToWindAxisRelativeSigned() {
        return this.getRelativeXTE(TrackedLegOfCompetitor::getSignedCrossTrackErrorToWindAxis);
    }
}

