/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.client.widgets.windbot.charts;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.dashboards.gwt.client.util.HighchartsUtil;
import com.sap.sailing.dashboards.gwt.client.widgets.windbot.charts.VerticalWindChart;
import com.sap.sailing.dashboards.gwt.client.widgets.windbot.charts.VerticalWindChartClickListener;
import com.sap.sailing.dashboards.gwt.client.widgets.windbot.charts.VerticalWindChartResources;
import com.sap.sailing.dashboards.gwt.shared.WindType;
import com.sap.sailing.gwt.ui.client.shared.charts.ChartPointRecalculator;
import com.sap.sailing.gwt.ui.shared.WindDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.moxieapps.gwt.highcharts.client.Axis;
import org.moxieapps.gwt.highcharts.client.Chart;
import org.moxieapps.gwt.highcharts.client.Credits;
import org.moxieapps.gwt.highcharts.client.DateTimeLabelFormats;
import org.moxieapps.gwt.highcharts.client.Global;
import org.moxieapps.gwt.highcharts.client.Highcharts;
import org.moxieapps.gwt.highcharts.client.Legend;
import org.moxieapps.gwt.highcharts.client.PlotLine;
import org.moxieapps.gwt.highcharts.client.Point;
import org.moxieapps.gwt.highcharts.client.Series;
import org.moxieapps.gwt.highcharts.client.Style;
import org.moxieapps.gwt.highcharts.client.ToolTip;
import org.moxieapps.gwt.highcharts.client.XAxis;
import org.moxieapps.gwt.highcharts.client.YAxis;
import org.moxieapps.gwt.highcharts.client.labels.AxisLabelsFormatter;
import org.moxieapps.gwt.highcharts.client.labels.DataLabels;
import org.moxieapps.gwt.highcharts.client.labels.XAxisLabels;
import org.moxieapps.gwt.highcharts.client.labels.YAxisLabels;
import org.moxieapps.gwt.highcharts.client.plotOptions.AreaPlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.BarPlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.Marker;
import org.moxieapps.gwt.highcharts.client.plotOptions.PlotOptions;

public class VerticalWindChart
extends Composite
implements HasWidgets {
    private Series verticalWindChartSeries;
    private Point lastPoint;
    private List<VerticalWindChartClickListener> verticalWindChartClickListeners;
    private int chartIntervallinMinutes = 15;
    private static final int LARGE_DISPLAY_INTERVALL_IN_MINUTES = 60;
    private static final int SMALL_DISPLAY_INTERVALL_IN_MINUTES = 15;
    private static final int MAX_SERIES_POINTS = 100000000;
    private static VerticalWindChartUiBinder uiBinder = (VerticalWindChartUiBinder)GWT.create(VerticalWindChartUiBinder.class);
    private static final Logger logger = Logger.getLogger(VerticalWindChart.class.getName());
    @UiField
    FocusPanel verticalWindChartClickArea;
    @UiField(provided=true)
    Chart verticalWindChart;

    public VerticalWindChart() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    @UiConstructor
    public VerticalWindChart(String positiveFillColorAsHex, String negativeFillColorAsHex) {
        VerticalWindChartResources.INSTANCE.gss().ensureInjected();
        this.initVerticalWindChartWithColors(positiveFillColorAsHex, negativeFillColorAsHex);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    private void initVerticalWindChartWithColors(String positiveFillColor, String negativeFillColor) {
        Highcharts.setOptions((Highcharts.Options)new Highcharts.Options().setGlobal(new Global().setUseUTC(false)));
        this.verticalWindChart = new Chart();
        this.setChartOptions();
        this.setXAxisOptions();
        this.setYAxisOptions();
        this.initVerticalWindChartSeries(positiveFillColor, negativeFillColor);
        this.verticalWindChartClickListeners = new ArrayList();
        HighchartsUtil.setSizeToMatchContainerDelayed((Chart)this.verticalWindChart);
    }

    private void setChartOptions() {
        ((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)this.verticalWindChart.setType(Series.Type.AREA_SPLINE)).setInverted(true)).setChartTitleText(" ")).setMarginTop((Number)10)).setMarginBottom((Number)25)).setMarginRight((Number)20)).setBackgroundColor("#FFFFFF")).setBorderColor("#FFFFFF")).setPlotShadow(false)).setPlotBorderColor("#FFFFFF")).setOption("/exporting/enabled", (Object)false)).setShadow(false)).setBarPlotOptions((BarPlotOptions)new BarPlotOptions().setDataLabels((DataLabels)new DataLabels().setEnabled(true)))).setLegend(new Legend().setEnabled(false))).setCredits(new Credits().setEnabled(false))).setToolTip(new ToolTip().setEnabled(false));
    }

    private void setXAxisOptions() {
        ((XAxis)((XAxis)((XAxis)((XAxis)((XAxis)((XAxis)((XAxis)((XAxis)((XAxis)((XAxis)((XAxis)this.verticalWindChart.getXAxis().setType(Axis.Type.DATE_TIME)).setReversed(false)).setLabels((XAxisLabels)new XAxisLabels().setStyle(new Style().setFontFamily("'Open Sans', Arial, Verdana, sans-serif").setFontSize("13px").setColor("#848484"))).setLineColor("#848484")).setTickWidth((Number)0.5)).setLineWidth((Number)1)).setTickWidth((Number)1)).setTickColor("#848484")).setOffset((Number)0)).setMinPadding((Number)20)).setGridLineColor("#F3F2F4")).setGridLineWidth((Number)0)).setDateTimeLabelFormats(new DateTimeLabelFormats().setMonth("%e. %b").setYear("%b"));
    }

    private void setYAxisOptions() {
        ((YAxis)((YAxis)((YAxis)((YAxis)((YAxis)((YAxis)((YAxis)((YAxis)((YAxis)((YAxis)((YAxis)((YAxis)((YAxis)this.verticalWindChart.getYAxis().setLineColor("#848484")).setTickWidth((Number)1)).setTickColor("#848484")).setAxisTitleText(null)).setGridLineWidth((Number)0)).setAlternateGridColor("#F3F2F4")).setLineWidth((Number)1)).setEndOnTick(true)).setStartOnTick(true)).setGridLineColor("transparent")).setGridLineWidth((Number)0)).setOffset((Number)0)).setMaxPadding((Number)0)).setLabels(((YAxisLabels)new YAxisLabels().setStyle(new Style().setFontFamily("'Open Sans', Arial, Verdana, sans-serif").setFontSize("13px").setColor("#848484"))).setFormatter((AxisLabelsFormatter)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void initVerticalWindChartSeries(String positivSeriesColorAsHex, String negativeSeriesColorAsHex) {
        this.verticalWindChartSeries = this.verticalWindChart.createSeries();
        AreaPlotOptions areaPlotOptions = new AreaPlotOptions();
        this.verticalWindChart.addSeries((Series)this.verticalWindChartSeries.setName(null).setPlotOptions((PlotOptions)((AreaPlotOptions)((AreaPlotOptions)((AreaPlotOptions)((AreaPlotOptions)((AreaPlotOptions)((AreaPlotOptions)((AreaPlotOptions)areaPlotOptions.setDashStyle(PlotLine.DashStyle.SOLID)).setLineWidth((Number)0.1)).setMarker(new Marker().setEnabled(false))).setShadow(false)).setHoverStateEnabled(false)).setLineColor("#FFFFFF")).setFillColor(positivSeriesColorAsHex)).setOption("negativeFillColor", (Object)negativeSeriesColorAsHex)).setOption("turboThreshold", (Object)100000000));
    }

    public void addPointsToSeriesWithAverageAndWindType(List<WindDTO> windFixes, double average, WindType windType) {
        if (windType.equals((Object)WindType.SPEED)) {
            this.addPointsToSeriesOfTypeSpeed(windFixes);
        } else {
            this.addPointsToSeriesOfTypeDirection(windFixes);
        }
        this.verticalWindChartSeries.updateThreshold("" + average);
        this.adaptVerticalWindChartExtemes(Long.valueOf(this.lastPoint.getX().longValue()));
    }

    private Point createSpeedPoint(WindDTO windDTO) {
        Point result = new Point((Number)windDTO.measureTimepoint, (Number)windDTO.trueWindSpeedInKnots);
        if (this.lastPoint != null) {
            this.adaptWindDirectionPointToStayCloseToLastPoint(this.lastPoint, result);
        }
        this.lastPoint = result;
        return result;
    }

    private Point createDirectionPoint(WindDTO windDTO) {
        Point result = new Point((Number)windDTO.measureTimepoint, (Number)windDTO.trueWindFromDeg);
        if (this.lastPoint != null) {
            this.adaptWindDirectionPointToStayCloseToLastPoint(this.lastPoint, result);
        }
        this.lastPoint = result;
        return result;
    }

    private void addPointsToSeriesOfTypeSpeed(List<WindDTO> windFixes) {
        for (WindDTO windDTO : windFixes) {
            this.verticalWindChartSeries.addPoint(this.createSpeedPoint(windDTO), false, false, false);
        }
    }

    private void addPointsToSeriesOfTypeDirection(List<WindDTO> windFixes) {
        for (WindDTO windDTO : windFixes) {
            this.verticalWindChartSeries.addPoint(this.createDirectionPoint(windDTO), false, false, false);
        }
    }

    private void adaptVerticalWindChartExtemes(Long lastTimePoint) {
        this.setXAxisExtremesForSeriesPointRangeIsBiggerThanChartDisplayIntervall(lastTimePoint.longValue());
    }

    private void setXAxisExtremesForSeriesPointRangeIsBiggerThanChartDisplayIntervall(long lastTimePoint) {
        long maximumExtremeValueInMillis = lastTimePoint;
        long minimumExtremeValueInMillis = maximumExtremeValueInMillis - (long)(this.chartIntervallinMinutes * 60 * 1000);
        this.verticalWindChart.getXAxis().setExtremes((Number)minimumExtremeValueInMillis, (Number)maximumExtremeValueInMillis, true, false);
    }

    public void addVerticalWindChartClickListener(VerticalWindChartClickListener verticalWindChartClickListener) {
        this.verticalWindChartClickListeners.add(verticalWindChartClickListener);
    }

    public void removeVerticalWindChartClickListener(VerticalWindChartClickListener verticalWindChartClickListener) {
        this.verticalWindChartClickListeners.remove(verticalWindChartClickListener);
    }

    public void notifyVerticalWindChartClickListeners(int intervalInMillis) {
        for (VerticalWindChartClickListener verticalWindChartClickListener : this.verticalWindChartClickListeners) {
            verticalWindChartClickListener.clickedWindChartWithNewIntervalChangeInMillis(intervalInMillis);
        }
    }

    private Point adaptWindDirectionPointToStayCloseToLastPoint(Point previousPoint, Point point) {
        return ChartPointRecalculator.stayClosestToPreviousPoint((Point)previousPoint, (Point)point);
    }

    @UiHandler(value={"verticalWindChartClickArea"})
    public void verticalWindChartClickAreaClicked(ClickEvent e) {
        if (this.lastPoint != null) {
            this.chartIntervallinMinutes = this.chartIntervallinMinutes == 15 ? 60 : 15;
            this.adaptVerticalWindChartExtemes(Long.valueOf(this.lastPoint.getX().longValue()));
            this.notifyVerticalWindChartClickListeners(this.chartIntervallinMinutes);
        }
    }

    public void add(Widget w) {
        throw new UnsupportedOperationException("The method add(Widget w) is not supported.");
    }

    public void clear() {
        throw new UnsupportedOperationException("The method clear() is not supported.");
    }

    public Iterator<Widget> iterator() {
        return null;
    }

    public boolean remove(Widget w) {
        return false;
    }
}

