/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.client.actions;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.dashboards.gwt.shared.dispatch.DashboardAction;
import com.sap.sailing.dashboards.gwt.shared.dispatch.DashboardDispatchContext;
import com.sap.sailing.dashboards.gwt.shared.dto.RaceIdDTO;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;

public class GetIDFromRaceThatTakesWindFixesNowAction
implements DashboardAction<RaceIdDTO> {
    private String leaderboardName;

    private GetIDFromRaceThatTakesWindFixesNowAction() {
    }

    public GetIDFromRaceThatTakesWindFixesNowAction(String leaderboardName) {
        this.leaderboardName = leaderboardName;
    }

    @GwtIncompatible
    public RaceIdDTO execute(DashboardDispatchContext dashboardDispatchContext) throws DispatchException {
        RaceIdDTO result = new RaceIdDTO();
        Leaderboard leaderboard = dashboardDispatchContext.getRacingEventService().getLeaderboardByName(this.leaderboardName);
        if (leaderboard != null) {
            for (RaceColumn column : leaderboard.getRaceColumns()) {
                for (Fleet fleet : column.getFleets()) {
                    TrackedRace race = column.getTrackedRace(fleet);
                    if (race == null || !race.takesWindFixWithTimePoint(MillisecondsTimePoint.now())) continue;
                    result.setRaceId(race.getRaceIdentifier());
                }
            }
        }
        return result;
    }
}

