/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.gateway.impl.websocket;

import com.sap.sailing.domain.igtimiadapter.gateway.impl.Activator;
import com.sap.sailing.domain.igtimiadapter.gateway.impl.websocket.UpgradeRequestAsHttpServletRequestWrapper;
import com.sap.sailing.domain.igtimiadapter.server.RiotWebsocketHandler;
import com.sap.sse.security.BearerTokenOrBasicOrFormAuthenticationFilter;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@WebSocket
public class RiotWebsocketHandlerImpl
implements RiotWebsocketHandler {
    private static final Logger logger = Logger.getLogger(RiotWebsocketHandlerImpl.class.getName());
    private User authenticatedUser;
    private Session session;
    private final Set<String> deviceSerialNumbers = new HashSet<String>();
    private ScheduledFuture<?> heartbeatSendingTask;

    @OnWebSocketConnect
    public void onConnect(Session session) {
        logger.info("Connect with session from " + session.getRemote());
        this.session = session;
        UpgradeRequest upgradeRequest = session.getUpgradeRequest();
        UpgradeRequestAsHttpServletRequestWrapper requestWrapper = new UpgradeRequestAsHttpServletRequestWrapper(upgradeRequest);
        AuthenticationToken token = new BearerTokenOrBasicOrFormAuthenticationFilter(){

            public AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
                return super.createToken(request, response);
            }
        }.createToken((ServletRequest)requestWrapper, null);
        if (token != null) {
            try {
                SecurityUtils.getSubject().login(token);
            }
            catch (AuthenticationException e) {
                logger.info("No authentication provided for session " + session);
            }
        }
        Subject subject = SecurityUtils.getSubject();
        logger.info("Subject: " + subject + " with principal " + subject.getPrincipal());
        Activator activator = Activator.getInstance();
        this.authenticatedUser = activator.getSecurityService().getCurrentUser() == null ? activator.getSecurityService().getAllUser() : activator.getSecurityService().getCurrentUser();
        activator.getRiotServer().addWebSocketClient((RiotWebsocketHandler)this);
        this.heartbeatSendingTask = this.scheduleHeartbeat();
    }

    private ScheduledFuture<?> scheduleHeartbeat() {
        return ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor().scheduleAtFixedRate(this::sendHeartbeat, 15L, 15L, TimeUnit.SECONDS);
    }

    @OnWebSocketMessage
    public void onText(Session session, String text) throws ParseException {
        if (text.equals("1")) {
            this.handleHeartbeat();
        } else {
            session.getRemote().sendStringByFuture("" + System.currentTimeMillis());
            JSONObject jsonObject = (JSONObject)new JSONParser().parse(text);
            JSONArray devices = (JSONArray)jsonObject.get((Object)"devices");
            this.deviceSerialNumbers.clear();
            devices.forEach(d -> {
                boolean bl = this.deviceSerialNumbers.add((String)d);
            });
            logger.info("Igtimi web socket client " + session + " registers for devices " + this.getDeviceSerialNumbers());
        }
    }

    private void handleHeartbeat() {
        logger.fine(() -> "Received heartbeat for " + this.session);
    }

    private void sendHeartbeat() {
        try {
            this.sendString("1");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception trying to send heartbeat to client " + this.session.getRemote(), e);
        }
    }

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
        logger.info("Session " + session + " closed with statusCode " + statusCode + " for reason " + reason);
        Activator.getInstance().getRiotServer().removeWebSocketClient((RiotWebsocketHandler)this);
        this.heartbeatSendingTask.cancel(true);
    }

    public Set<String> getDeviceSerialNumbers() {
        return Collections.unmodifiableSet(this.deviceSerialNumbers);
    }

    public User getAuthenticatedUser() {
        return this.authenticatedUser;
    }

    public void sendBytes(ByteBuffer data) throws IOException {
        this.session.getRemote().sendBytes(data);
    }

    public Future<Void> sendBytesByFuture(ByteBuffer data) {
        return this.session.getRemote().sendBytesByFuture(data);
    }

    public void sendString(String text) throws IOException {
        this.session.getRemote().sendString(text);
    }

    public Future<Void> sendStringByFuture(String text) {
        return this.session.getRemote().sendStringByFuture(text);
    }

    public void flush() throws IOException {
        this.session.getRemote().flush();
    }

    public void close(int statusCode, String reason) {
        this.session.close(statusCode, reason);
    }

    public String toString() {
        return "Riot web socket for session from " + (this.session == null ? "unknown target " : this.session.getRemote()) + ", subcribed to devices " + this.getDeviceSerialNumbers() + " and with authenticated user " + this.getAuthenticatedUser();
    }
}

