/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.userstore.mongodb;

import com.sap.sse.common.Util;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.security.interfaces.PreferenceConverter;
import com.sap.sse.security.interfaces.PreferenceObjectListener;
import com.sap.sse.security.interfaces.SocialSettingsKeys;
import com.sap.sse.security.interfaces.UserImpl;
import com.sap.sse.security.interfaces.UserStore;
import com.sap.sse.security.shared.Account;
import com.sap.sse.security.shared.AdminRole;
import com.sap.sse.security.shared.PredefinedRoles;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.RoleDefinitionImpl;
import com.sap.sse.security.shared.RolePrototype;
import com.sap.sse.security.shared.UserGroupManagementException;
import com.sap.sse.security.shared.UserGroupProvider;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.UserRole;
import com.sap.sse.security.shared.UserStoreManagementException;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.impl.LockingAndBanning;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.shared.impl.UserGroupImpl;
import com.sap.sse.security.userstore.mongodb.DomainObjectFactory;
import com.sap.sse.security.userstore.mongodb.MongoObjectFactory;
import com.sap.sse.security.userstore.mongodb.PersistenceFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserStoreImpl
implements UserStore {
    private static final long serialVersionUID = -3860868283827473187L;
    private static final Logger logger = Logger.getLogger(UserStoreImpl.class.getName());
    private static final String ACCESS_TOKEN_KEY = "___access_token___";
    private static final String NAME = "MongoDB user store";
    private final ConcurrentHashMap<UUID, RoleDefinition> roleDefinitions;
    private UserGroup serverGroup;
    private final Map<UUID, UserGroup> userGroups;
    private final Map<String, UserGroup> userGroupsByName;
    private final Map<User, Set<UserGroup>> userGroupsContainingUser;
    private final Map<UserGroup, Set<User>> usersInUserGroups;
    private final Map<RoleDefinition, Set<UserGroup>> roleDefinitionsToUserGroups;
    private transient NamedReentrantReadWriteLock userGroupsLock;
    private transient NamedReentrantReadWriteLock usersLock;
    private final Map<String, User> users;
    private final Map<String, Set<User>> usersByEmail;
    private final Map<String, String> emailForUsername;
    private final Map<String, User> usersByAccessToken;
    private final Map<RoleDefinition, Set<User>> roleDefinitionsToUsers;
    private final ConcurrentHashMap<String, Object> settings;
    private final ConcurrentHashMap<String, Class<?>> settingTypes;
    private transient NamedReentrantReadWriteLock preferenceLock;
    private final Map<String, Map<String, String>> preferences;
    private transient Map<String, PreferenceConverter<?>> preferenceConverters;
    private transient Map<String, Map<String, Object>> preferenceObjects;
    private transient Map<String, Set<PreferenceObjectListener<?>>> preferenceListeners;
    private final transient MongoObjectFactory mongoObjectFactory;
    private final transient DomainObjectFactory domainObjectFactory;
    private final String serverGroupName;

    public UserStoreImpl(String defaultServerGroupName) throws UserGroupManagementException, UserManagementException {
        this(PersistenceFactory.INSTANCE.getDefaultDomainObjectFactory(), PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory(), defaultServerGroupName);
    }

    public UserStoreImpl(DomainObjectFactory domainObjectFactory, MongoObjectFactory mongoObjectFactory, String defaultServerGroupName) throws UserGroupManagementException, UserManagementException {
        this.serverGroupName = defaultServerGroupName;
        this.domainObjectFactory = domainObjectFactory;
        this.roleDefinitions = new ConcurrentHashMap();
        this.userGroups = new HashMap<UUID, UserGroup>();
        this.userGroupsByName = new HashMap<String, UserGroup>();
        this.userGroupsContainingUser = new HashMap<User, Set<UserGroup>>();
        this.usersInUserGroups = new HashMap<UserGroup, Set<User>>();
        this.roleDefinitionsToUsers = new HashMap<RoleDefinition, Set<User>>();
        this.roleDefinitionsToUserGroups = new HashMap<RoleDefinition, Set<UserGroup>>();
        this.users = new HashMap<String, User>();
        this.usersByEmail = new HashMap<String, Set<User>>();
        this.emailForUsername = new HashMap<String, String>();
        this.settings = new ConcurrentHashMap();
        this.settingTypes = new ConcurrentHashMap();
        this.usersByAccessToken = new HashMap<String, User>();
        this.preferences = new HashMap<String, Map<String, String>>();
        this.preferenceConverters = new HashMap();
        this.preferenceObjects = new HashMap<String, Map<String, Object>>();
        this.preferenceListeners = new HashMap();
        this.usersLock = new NamedReentrantReadWriteLock("Users", false);
        this.userGroupsLock = new NamedReentrantReadWriteLock("User Groups", false);
        this.preferenceLock = new NamedReentrantReadWriteLock("Preferences", false);
        this.mongoObjectFactory = mongoObjectFactory;
        if (domainObjectFactory != null) {
            boolean bl;
            for (Map.Entry<String, Class<?>> entry : domainObjectFactory.loadSettingTypes().entrySet()) {
                this.settingTypes.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : domainObjectFactory.loadSettings().entrySet()) {
                this.settings.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : domainObjectFactory.loadPreferences().entrySet()) {
                this.preferences.put(entry.getKey(), (Map)entry.getValue());
            }
            boolean bl2 = false;
            boolean bl3 = bl = bl2 || this.initSocialSettingsIfEmpty();
            if (bl) {
                mongoObjectFactory.storeSettingTypes(this.settingTypes);
                mongoObjectFactory.storeSettings(this.settings);
            }
            for (RoleDefinition roleDefinition : domainObjectFactory.loadAllRoleDefinitions()) {
                this.roleDefinitions.put(roleDefinition.getId(), roleDefinition);
            }
            if (this.roleDefinitions.isEmpty()) {
                logger.info("Empty set of role definitions suggests we are under migration. Creating default roles.");
            }
        }
    }

    public UserGroup ensureServerGroupExists() throws UserGroupManagementException {
        return (UserGroup)LockUtil.executeWithWriteLockAndResultExpectException((NamedReentrantReadWriteLock)this.userGroupsLock, () -> {
            this.serverGroup = this.getOrCreateServerGroup(this.serverGroupName);
            return this.serverGroup;
        });
    }

    public void loadAndMigrateUsers() throws UserStoreManagementException {
        LockUtil.executeWithWriteLockExpectException((NamedReentrantReadWriteLock)this.usersLock, () -> {
            LockUtil.executeWithWriteLockExpectException((NamedReentrantReadWriteLock)this.userGroupsLock, () -> {
                Iterable<UserGroup> userGroups = this.domainObjectFactory.loadAllUserGroupsAndTenantsWithProxyUsers(this.roleDefinitions);
                for (UserGroup group : userGroups) {
                    this.userGroups.put(group.getId(), group);
                    this.userGroupsByName.put(group.getName(), group);
                }
                this.ensureServerGroupExists();
                for (User u : this.domainObjectFactory.loadAllUsers(this.roleDefinitions, this::convertToNewRoleModel, this.userGroups, (UserGroupProvider)this)) {
                    this.users.put(u.getName(), u);
                    this.addToUsersByEmail(u);
                    for (Role roleOfUser : u.getRoles()) {
                        Util.addToValueSet(this.roleDefinitionsToUsers, (Object)roleOfUser.getRoleDefinition(), (Object)u);
                    }
                }
                for (UserGroup group : this.userGroups.values()) {
                    this.migrateProxyUsersInGroupToRealUsersByUsername(group);
                    for (User userInGroup : group.getUsers()) {
                        Util.addToValueSet(this.usersInUserGroups, (Object)group, (Object)userInGroup);
                        Util.addToValueSet(this.userGroupsContainingUser, (Object)userInGroup, (Object)group);
                    }
                    for (RoleDefinition roleInUserGroup : group.getRoleDefinitionMap().keySet()) {
                        Util.addToValueSet(this.roleDefinitionsToUserGroups, (Object)roleInUserGroup, (Object)group);
                    }
                }
            });
            LockUtil.executeWithReadLock((NamedReentrantReadWriteLock)this.preferenceLock, () -> {
                for (Map.Entry<String, Map<String, String>> e : this.preferences.entrySet()) {
                    String accessToken;
                    if (e.getValue() == null || (accessToken = e.getValue().get(ACCESS_TOKEN_KEY)) == null) continue;
                    User user = this.users.get(e.getKey());
                    if (user != null) {
                        this.usersByAccessToken.put(accessToken, user);
                        continue;
                    }
                    logger.warning("Couldn't find user \"" + e.getKey() + "\" for which an access token was found in the preferences");
                }
            });
        });
    }

    private Role convertToNewRoleModel(String oldRoleName, String username) {
        Role result = null;
        for (RoleDefinition roleDefinition : this.roleDefinitions.values()) {
            UserGroup groupQualifierForMigratedRole;
            if (!roleDefinition.getName().equals(oldRoleName)) continue;
            if (AdminRole.getInstance().getId().equals(roleDefinition.getId()) && "admin".equals(username)) {
                groupQualifierForMigratedRole = null;
            } else {
                if (this.serverGroup == null) {
                    throw new IllegalStateException("For role migration a valid server group name is required. Set system property security.defaultServerGroupName or provide a server name");
                }
                groupQualifierForMigratedRole = this.serverGroup;
            }
            result = new Role(roleDefinition, groupQualifierForMigratedRole, null, Boolean.valueOf(true));
            break;
        }
        return result;
    }

    public void ensureDefaultRolesExist() {
        this.getOrCreateRoleDefinitionByPrototype((RolePrototype)AdminRole.getInstance());
        this.getOrCreateRoleDefinitionByPrototype((RolePrototype)UserRole.getInstance());
        PredefinedRoles[] predefinedRolesArray = PredefinedRoles.values();
        int n = predefinedRolesArray.length;
        int n2 = 0;
        while (n2 < n) {
            PredefinedRoles otherPredefinedRole = predefinedRolesArray[n2];
            UUID id = otherPredefinedRole.getId();
            RoleDefinition potentiallyExistingRoleDefinition = this.getRoleDefinition(id);
            HashSet<WildcardPermission> targetPermissions = new HashSet<WildcardPermission>();
            for (String stringPermission : otherPredefinedRole.getPermissions()) {
                targetPermissions.add(new WildcardPermission(stringPermission));
            }
            if (potentiallyExistingRoleDefinition == null) {
                logger.info("Predefined role definition " + otherPredefinedRole + " not found; creating");
                this.createRoleDefinition(id, otherPredefinedRole.name(), targetPermissions);
            } else if (!targetPermissions.equals(potentiallyExistingRoleDefinition.getPermissions())) {
                this.setRoleDefinitionPermissions(id, targetPermissions);
            }
            ++n2;
        }
    }

    private RoleDefinition getOrCreateRoleDefinitionByPrototype(RolePrototype rolePrototype) {
        UUID id = rolePrototype.getId();
        RoleDefinition roleDefinition = this.getRoleDefinition(id);
        if (roleDefinition == null) {
            logger.info("No " + rolePrototype.getName() + " role found. Creating default role \"" + rolePrototype.getName() + "\" with permission \"" + rolePrototype.getPermissions() + "\"");
            roleDefinition = this.createRoleDefinition(id, rolePrototype.getName(), rolePrototype.getPermissions());
        } else if (roleDefinition.getPermissions() != null && !roleDefinition.getPermissions().equals(rolePrototype.getPermissions())) {
            this.setRoleDefinitionPermissions(id, rolePrototype.getPermissions());
            roleDefinition = this.getRoleDefinition(id);
        }
        return roleDefinition;
    }

    public RoleDefinition getRoleDefinitionByPrototype(RolePrototype rolePrototype) {
        RoleDefinition roleDefinition = this.getRoleDefinition(rolePrototype.getId());
        if (roleDefinition == null) {
            String errorMsg = "No " + rolePrototype.getName() + " role definition found by ID " + rolePrototype.getId() + "." + "RoleDefinitions for prototypes are required to exist on usage.";
            logger.severe(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        return roleDefinition;
    }

    public String getServerGroupName() {
        return this.serverGroupName;
    }

    public UserGroup getServerGroup() {
        return this.serverGroup;
    }

    public void setServerGroup(UserGroup newServerGroup) {
        this.serverGroup = newServerGroup;
    }

    private UserGroup getOrCreateServerGroup(String defaultServerGroupName) throws UserGroupManagementException {
        UserGroup result;
        assert (this.userGroupsLock.isWriteLockedByCurrentThread());
        if (defaultServerGroupName != null) {
            UserGroup existingTenant = this.getUserGroupByName(defaultServerGroupName);
            if (existingTenant == null) {
                logger.info("Couldn't find default tenant " + defaultServerGroupName + "; creating it");
                result = this.createUserGroup(UUID.randomUUID(), defaultServerGroupName);
            } else {
                result = existingTenant;
            }
        } else {
            result = null;
        }
        return result;
    }

    private void migrateProxyUsersInGroupToRealUsersByUsername(UserGroup group) {
        assert (this.usersLock.isWriteLockedByCurrentThread());
        assert (this.userGroupsLock.isWriteLockedByCurrentThread());
        HashSet oldUsers = new HashSet();
        Util.addAll((Iterable)group.getUsers(), oldUsers);
        for (User proxyUser : oldUsers) {
            group.remove(proxyUser);
            User realUser = this.users.get(proxyUser.getName());
            if (realUser == null) {
                logger.warning("Couldn't find user " + proxyUser.getName() + " which was part of user group " + group.getName());
                continue;
            }
            group.add(realUser);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.preferenceConverters = new HashMap();
        this.preferenceObjects = new HashMap<String, Map<String, Object>>();
        this.preferenceListeners = new HashMap();
        this.usersLock = new NamedReentrantReadWriteLock("Users", false);
        this.userGroupsLock = new NamedReentrantReadWriteLock("User Groups", false);
        this.preferenceLock = new NamedReentrantReadWriteLock("Preferences", false);
    }

    protected Object readResolve() {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.usersLock, () -> {
            for (User user : this.getUsers()) {
                if (!(user instanceof UserImpl)) continue;
                ((UserImpl)user).setUserGroupProvider((UserGroupProvider)this);
            }
        });
        return this;
    }

    public void clear() {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.usersLock, () -> LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.userGroupsLock, () -> LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.preferenceLock, () -> {
            if (this.mongoObjectFactory != null) {
                this.users.values().forEach(this.mongoObjectFactory::deleteUser);
                this.userGroups.values().forEach(this.mongoObjectFactory::deleteUserGroup);
                this.roleDefinitions.values().forEach(this.mongoObjectFactory::deleteRoleDefinition);
                this.mongoObjectFactory.deleteAllPreferences();
                this.mongoObjectFactory.deleteAllSettings();
            }
            this.removeAll();
        })));
    }

    private void removeAll() {
        assert (this.usersLock.isWriteLockedByCurrentThread());
        assert (this.userGroupsLock.isWriteLockedByCurrentThread());
        this.userGroups.clear();
        this.userGroupsByName.clear();
        this.userGroupsContainingUser.clear();
        this.usersInUserGroups.clear();
        this.roleDefinitionsToUserGroups.clear();
        this.clearAllPreferenceObjects();
        this.emailForUsername.clear();
        this.settings.clear();
        this.settingTypes.clear();
        this.users.clear();
        this.roleDefinitionsToUsers.clear();
        this.roleDefinitions.clear();
        this.usersByEmail.clear();
        this.usersByAccessToken.clear();
    }

    private void clearAllPreferenceObjects() {
        assert (this.preferenceLock.isWriteLockedByCurrentThread());
        HashSet<String> usersToProcess = new HashSet<String>(this.preferences.keySet());
        for (String username : usersToProcess) {
            this.removeAllPreferencesForUser(username);
        }
    }

    public void replaceContentsFrom(UserStore newUserStore) {
        this.clear();
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.usersLock, () -> LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.userGroupsLock, () -> {
            for (UserGroup userGroup : newUserStore.getUserGroups()) {
                this.userGroups.put(userGroup.getId(), userGroup);
                this.userGroupsByName.put(userGroup.getName(), userGroup);
                HashSet usersInGroup = new HashSet();
                Util.addAll((Iterable)userGroup.getUsers(), usersInGroup);
                this.usersInUserGroups.put(userGroup, usersInGroup);
                for (User userInGroup : userGroup.getUsers()) {
                    Util.addToValueSet(this.userGroupsContainingUser, (Object)userInGroup, (Object)userGroup);
                }
            }
            for (RoleDefinition roleDefinition : newUserStore.getRoleDefinitions()) {
                this.roleDefinitions.put(roleDefinition.getId(), roleDefinition);
            }
            LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.preferenceLock, () -> {
                for (User user : newUserStore.getUsers()) {
                    user.setUserGroupProvider((UserGroupProvider)this);
                    this.users.put(user.getName(), user);
                    this.addToUsersByEmail(user);
                    for (Map.Entry userPref : newUserStore.getAllPreferences(user.getName()).entrySet()) {
                        this.setPreferenceInternalAndUpdatePreferenceObjectIfConverterIsAvailable(user.getName(), (String)userPref.getKey(), (String)userPref.getValue(), false);
                        if (!((String)userPref.getKey()).equals(ACCESS_TOKEN_KEY)) continue;
                        this.usersByAccessToken.put((String)userPref.getValue(), user);
                    }
                }
            });
            for (Map.Entry entry : newUserStore.getAllSettings().entrySet()) {
                this.settings.put((String)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : newUserStore.getAllSettingTypes().entrySet()) {
                this.settingTypes.put((String)entry.getKey(), (Class)entry.getValue());
            }
        }));
    }

    public Iterable<RoleDefinition> getRoleDefinitions() {
        return new ArrayList<RoleDefinition>(this.roleDefinitions.values());
    }

    public RoleDefinition getRoleDefinition(UUID roleId) {
        return this.roleDefinitions.get(roleId);
    }

    public RoleDefinition createRoleDefinition(UUID roleDefinitionId, String displayName, Iterable<WildcardPermission> permissions) {
        RoleDefinition roleDefinition = RoleDefinitionImpl.create((UUID)roleDefinitionId, (String)displayName, permissions);
        for (RoleDefinition value : this.roleDefinitions.values()) {
            if (!value.getName().equals(roleDefinition.getName())) continue;
            throw new IllegalArgumentException("Role Definition with same name already exists");
        }
        this.roleDefinitions.put(roleDefinitionId, roleDefinition);
        this.mongoObjectFactory.storeRoleDefinition(roleDefinition);
        return roleDefinition;
    }

    public void setRoleDefinitionPermissions(UUID roleDefinitionId, Set<WildcardPermission> permissions) {
        RoleDefinition roleDefinition = this.roleDefinitions.get(roleDefinitionId);
        RoleDefinitionImpl newRoleDefinition = new RoleDefinitionImpl(roleDefinitionId, roleDefinition.getName(), permissions);
        this.mongoObjectFactory.storeRoleDefinition((RoleDefinition)newRoleDefinition);
        roleDefinition.setPermissions(permissions);
    }

    public void addRoleDefinitionPermission(UUID roleId, WildcardPermission permission) {
        RoleDefinition roleDefinition = this.roleDefinitions.get(roleId);
        Set permissions = roleDefinition.getPermissions();
        permissions.add(permission);
        roleDefinition = new RoleDefinitionImpl(roleId, roleDefinition.getName(), (Iterable)permissions);
        this.mongoObjectFactory.storeRoleDefinition(roleDefinition);
    }

    public void removeRoleDefinitionPermission(UUID roleId, WildcardPermission permission) {
        RoleDefinition roleDefinition = this.roleDefinitions.get(roleId);
        Set permissions = roleDefinition.getPermissions();
        permissions.remove(permission);
        roleDefinition = new RoleDefinitionImpl(roleId, roleDefinition.getName(), (Iterable)permissions);
        this.mongoObjectFactory.storeRoleDefinition(roleDefinition);
    }

    public void setRoleDefinitionDisplayName(UUID roleId, String displayName) {
        RoleDefinition roleDefinition = this.roleDefinitions.get(roleId);
        roleDefinition = new RoleDefinitionImpl(roleId, displayName, (Iterable)roleDefinition.getPermissions());
        this.mongoObjectFactory.storeRoleDefinition(roleDefinition);
    }

    public void removeRoleDefinition(RoleDefinition roleDefinition) {
        if (roleDefinition == null) {
            return;
        }
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.usersLock, () -> LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.userGroupsLock, () -> {
            Set<UserGroup> userGroupsHavingRoleWithRoleDefinition;
            Set<User> usersHavingRoleWithRoleDefiniton = this.roleDefinitionsToUsers.get(roleDefinition);
            if (usersHavingRoleWithRoleDefiniton != null) {
                for (User user : usersHavingRoleWithRoleDefiniton) {
                    for (Role role : user.getRoles()) {
                        if (!role.getRoleDefinition().equals(roleDefinition)) continue;
                        user.removeRole(role);
                        this.mongoObjectFactory.storeUser(user);
                    }
                }
                this.roleDefinitionsToUsers.remove(roleDefinition);
            }
            if ((userGroupsHavingRoleWithRoleDefinition = this.roleDefinitionsToUserGroups.get(roleDefinition)) != null) {
                for (UserGroup userGroup : userGroupsHavingRoleWithRoleDefinition) {
                    if (!userGroup.getRoleAssociation(roleDefinition).booleanValue()) continue;
                    userGroup.remove(roleDefinition);
                    this.mongoObjectFactory.storeUserGroup(userGroup);
                }
                this.roleDefinitionsToUserGroups.remove(roleDefinition);
            }
            this.roleDefinitions.remove(roleDefinition.getId());
            this.mongoObjectFactory.deleteRoleDefinition(roleDefinition);
        }));
    }

    public boolean setAccessToken(String username, String accessToken) {
        return (Boolean)LockUtil.executeWithWriteLockAndResult((NamedReentrantReadWriteLock)this.usersLock, () -> {
            boolean result;
            User user = this.getUserByName(username);
            if (user == null) {
                result = false;
            } else {
                result = true;
                String oldAccessToken = this.getPreference(username, ACCESS_TOKEN_KEY);
                if (oldAccessToken != null) {
                    this.usersByAccessToken.remove(oldAccessToken);
                }
                this.usersByAccessToken.put(accessToken, user);
                this.setPreference(username, ACCESS_TOKEN_KEY, accessToken);
            }
            return result;
        });
    }

    public String getAccessToken(String username) {
        return this.getPreference(username, ACCESS_TOKEN_KEY);
    }

    public void removeAccessToken(String username) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.usersLock, () -> {
            User user = this.users.get(username);
            if (user != null) {
                String accessToken = this.getPreference(username, ACCESS_TOKEN_KEY);
                if (accessToken != null) {
                    this.usersByAccessToken.remove(accessToken);
                }
                this.unsetPreference(username, ACCESS_TOKEN_KEY);
            }
        });
    }

    private void addToUsersByEmail(User u) {
        assert (this.usersLock.isWriteLockedByCurrentThread());
        if (u.getEmail() != null && !u.getEmail().isEmpty()) {
            Set<User> set = this.usersByEmail.get(u.getEmail());
            if (set == null) {
                set = new HashSet<User>();
                this.usersByEmail.put(u.getEmail(), set);
            }
            set.add(u);
            this.emailForUsername.put(u.getName(), u.getEmail());
        }
    }

    private void removeFromUsersByEmail(User u) {
        Set<User> set;
        String email;
        assert (this.usersLock.isWriteLockedByCurrentThread());
        if (u != null && (email = this.emailForUsername.remove(u.getName())) != null && (set = this.usersByEmail.get(email)) != null) {
            set.remove(u);
        }
    }

    private boolean initSocialSettingsIfEmpty() {
        boolean changed = false;
        SocialSettingsKeys[] socialSettingsKeysArray = SocialSettingsKeys.values();
        int n = socialSettingsKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            SocialSettingsKeys ssk = socialSettingsKeysArray[n2];
            if (this.settingTypes.get(ssk.name()) == null || this.settings.get(ssk.name()) == null) {
                this.addSetting(ssk.name(), String.class);
                this.setSetting(ssk.name(), ssk.getValue());
                changed = true;
            }
            ++n2;
        }
        return changed;
    }

    public String getName() {
        return NAME;
    }

    public Iterable<UserGroup> getUserGroups() {
        return (Iterable)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.userGroupsLock, () -> new ArrayList<UserGroup>(this.userGroups.values()));
    }

    public UserGroup getUserGroupByName(String name) {
        return (UserGroup)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.userGroupsLock, () -> name == null ? null : this.userGroupsByName.get(name));
    }

    public Iterable<UserGroup> getUserGroupsWithRoleDefinition(RoleDefinition roleDefinition) {
        return (Iterable)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.userGroupsLock, () -> roleDefinition == null ? null : new HashSet(this.roleDefinitionsToUserGroups.get(roleDefinition)));
    }

    public UserGroup getUserGroup(UUID id) {
        return (UserGroup)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.userGroupsLock, () -> id == null ? null : this.userGroups.get(id));
    }

    public UserGroupImpl createUserGroup(UUID groupId, String name) throws UserGroupManagementException {
        return (UserGroupImpl)LockUtil.executeWithWriteLockAndResultExpectException((NamedReentrantReadWriteLock)this.userGroupsLock, () -> {
            this.checkGroupNameAndIdUniqueness(groupId, name);
            logger.info("Creating user group: " + groupId + " with name " + name);
            UserGroupImpl group = new UserGroupImpl(groupId, name);
            if (this.mongoObjectFactory != null) {
                this.mongoObjectFactory.storeUserGroup((UserGroup)group);
            }
            this.addGroupToInternalMaps((UserGroup)group);
            return group;
        });
    }

    private void addGroupToInternalMaps(UserGroup group) {
        assert (this.userGroupsLock.isWriteLockedByCurrentThread());
        this.userGroups.put(group.getId(), group);
        this.userGroupsByName.put(group.getName(), group);
    }

    private void checkGroupNameAndIdUniqueness(UUID groupId, String name) throws UserGroupManagementException {
        assert (this.userGroupsLock.isWriteLockedByCurrentThread() || this.userGroupsLock.getReadHoldCount() > 0);
        if (this.userGroupsByName.containsKey(name)) {
            throw new UserGroupManagementException("User group already exists: " + name);
        }
        if (this.userGroups.containsKey(groupId)) {
            throw new UserGroupManagementException("User group already exists: " + groupId);
        }
    }

    public void addUserGroup(UserGroup group) throws UserGroupManagementException {
        LockUtil.executeWithWriteLockExpectException((NamedReentrantReadWriteLock)this.userGroupsLock, () -> {
            this.checkGroupNameAndIdUniqueness(group.getId(), group.getName());
            this.addGroupToInternalMaps(group);
            this.updateUserGroup(group);
        });
    }

    public void updateUserGroup(UserGroup group) {
        logger.info("Updating user group " + group.getName() + " in DB");
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.userGroupsLock, () -> {
            HashSet usersInGroupBefore = new HashSet();
            Util.addAll((Iterable)this.usersInUserGroups.get(group), usersInGroupBefore);
            for (User userNowInUpdatedGroup : group.getUsers()) {
                if (usersInGroupBefore != null && Util.contains(usersInGroupBefore, (Object)userNowInUpdatedGroup)) continue;
                Util.addToValueSet(this.usersInUserGroups, (Object)group, (Object)userNowInUpdatedGroup);
                Util.addToValueSet(this.userGroupsContainingUser, (Object)userNowInUpdatedGroup, (Object)group);
            }
            for (User userInGroupBefore : usersInGroupBefore) {
                if (Util.contains((Iterable)group.getUsers(), (Object)userInGroupBefore)) continue;
                Util.removeFromValueSet(this.usersInUserGroups, (Object)group, (Object)userInGroupBefore);
                Util.removeFromValueSet(this.userGroupsContainingUser, (Object)userInGroupBefore, (Object)group);
            }
            Util.removeFromAllValueSets(this.roleDefinitionsToUserGroups, (Object)group);
            for (RoleDefinition roleInUserGroup : group.getRoleDefinitionMap().keySet()) {
                Util.addToValueSet(this.roleDefinitionsToUserGroups, (Object)roleInUserGroup, (Object)group);
            }
        });
        if (this.mongoObjectFactory != null) {
            this.mongoObjectFactory.storeUserGroup(group);
        }
    }

    private void removeUserFromUserGroup(User user, UserGroup group) {
        assert (this.userGroupsLock.isWriteLockedByCurrentThread());
        group.remove(user);
        Util.removeFromValueSet(this.usersInUserGroups, (Object)group, (Object)user);
        Util.removeFromValueSet(this.userGroupsContainingUser, (Object)user, (Object)group);
    }

    public Iterable<UserGroup> getUserGroupsOfUser(User user) {
        return (Iterable)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.userGroupsLock, () -> {
            Set<UserGroup> userGroups = this.userGroupsContainingUser.get(user);
            return userGroups == null ? Collections.emptySet() : new HashSet<UserGroup>(userGroups);
        });
    }

    private void deleteUserGroupAndRemoveRelations(UserGroup userGroup) throws UserGroupManagementException {
        assert (this.userGroupsLock.isWriteLockedByCurrentThread());
        if (!this.userGroups.containsKey(userGroup.getId())) {
            throw new UserGroupManagementException("User group does not exist");
        }
        logger.info("Deleting user group: " + userGroup);
        this.userGroupsByName.remove(userGroup.getName());
        this.userGroups.remove(userGroup.getId());
        for (User userInDeletedGroup : userGroup.getUsers()) {
            Util.removeFromValueSet(this.userGroupsContainingUser, (Object)userInDeletedGroup, (Object)userGroup);
        }
        this.usersInUserGroups.remove(userGroup);
        userGroup.getRoleDefinitionMap().keySet().forEach(role -> {
            boolean bl = Util.removeFromValueSet(this.roleDefinitionsToUserGroups, (Object)role, (Object)userGroup);
        });
        this.deleteUserGroupFromDB(userGroup);
    }

    private void deleteUserGroupFromDB(UserGroup userGroup) {
        assert (this.userGroupsLock.isWriteLockedByCurrentThread());
        if (this.mongoObjectFactory != null) {
            this.mongoObjectFactory.deleteUserGroup(userGroup);
        }
    }

    public User createUser(String name, String email, LockingAndBanning lockingAndBanning, Account ... accounts) throws UserManagementException {
        return (User)LockUtil.executeWithWriteLockAndResultExpectException((NamedReentrantReadWriteLock)this.usersLock, () -> {
            this.checkUsernameUniqueness(name);
            ConcurrentHashMap tenantsForServer = new ConcurrentHashMap();
            UserImpl user = new UserImpl(name, email, tenantsForServer, (UserGroupProvider)this, lockingAndBanning, accounts);
            logger.info("Creating user: " + user + " with e-mail " + email);
            this.addAndStoreUserInternal((User)user);
            return user;
        });
    }

    private void addAndStoreUserInternal(User user) {
        assert (this.usersLock.isWriteLockedByCurrentThread());
        if (this.mongoObjectFactory != null) {
            this.mongoObjectFactory.storeUser(user);
        }
        this.users.put(user.getName(), user);
        this.addToUsersByEmail(user);
    }

    private void checkUsernameUniqueness(String name) throws UserManagementException {
        assert (this.usersLock.isWriteLockedByCurrentThread());
        if (this.getUserByName(name) != null) {
            throw new UserManagementException("User already exists");
        }
    }

    public void addUser(User user) throws UserManagementException {
        LockUtil.executeWithWriteLockExpectException((NamedReentrantReadWriteLock)this.usersLock, () -> {
            this.checkUsernameUniqueness(user.getName());
            logger.info("Adding user: " + user);
            this.addAndStoreUserInternal(user);
        });
    }

    public void updateUser(User user) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.usersLock, () -> {
            logger.info("Updating user " + user + " in DB");
            this.users.put(user.getName(), user);
            this.removeFromUsersByEmail(user);
            this.addToUsersByEmail(user);
            if (this.mongoObjectFactory != null) {
                this.mongoObjectFactory.storeUser(user);
            }
        });
    }

    public Iterable<User> getUsers() {
        return (Iterable)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.usersLock, () -> new ArrayList<User>(this.users.values()));
    }

    public boolean hasUsers() {
        return (Boolean)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.usersLock, () -> !this.users.isEmpty());
    }

    public User getUserByName(String name) {
        User result = name == null ? null : (User)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.usersLock, () -> this.users.get(name));
        return result;
    }

    public User getUserByAccessToken(String accessToken) {
        return (User)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.usersLock, () -> {
            User result = accessToken == null ? null : this.usersByAccessToken.get(accessToken);
            return result;
        });
    }

    public User getUserByEmail(String email) {
        return (User)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.usersLock, () -> {
            Set<User> set;
            User result = email == null ? null : ((set = this.usersByEmail.get(email)) == null || set.isEmpty() ? null : set.iterator().next());
            return result;
        });
    }

    public Util.Pair<Boolean, Set<Ownership>> getExistingQualificationsForRoleDefinition(RoleDefinition roleToCheck) {
        return (Util.Pair)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.usersLock, () -> (Util.Pair)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.userGroupsLock, () -> {
            Set<UserGroup> userGroupsHavingRole;
            HashSet<Ownership> ownerships = new HashSet<Ownership>();
            Set<User> usersHavingRole = this.roleDefinitionsToUsers.get(roleToCheck);
            if (usersHavingRole != null) {
                for (User user : usersHavingRole) {
                    for (Role role : user.getRoles()) {
                        if (!role.getRoleDefinition().equals(roleToCheck)) continue;
                        if (role.getQualifiedForTenant() == null && role.getQualifiedForUser() == null) {
                            return new Util.Pair((Object)true, null);
                        }
                        ownerships.add(new Ownership((User)role.getQualifiedForUser(), (UserGroup)role.getQualifiedForTenant()));
                    }
                }
            }
            if ((userGroupsHavingRole = this.roleDefinitionsToUserGroups.get(roleToCheck)) != null) {
                for (UserGroup userGroup : userGroupsHavingRole) {
                    if (!userGroup.getRoleDefinitionMap().containsKey(roleToCheck)) continue;
                    ownerships.add(new Ownership(null, userGroup));
                }
            }
            return new Util.Pair((Object)false, ownerships);
        }));
    }

    public Set<Util.Pair<User, Role>> getRolesQualifiedByUserGroup(UserGroup groupQualification) {
        return (Set)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.usersLock, () -> {
            HashSet<Util.Pair> result = new HashSet<Util.Pair>();
            for (User user : this.getUsers()) {
                try {
                    for (Role role : this.getRolesFromUser(user.getName())) {
                        if (!groupQualification.equals(role.getQualifiedForTenant())) continue;
                        result.add(new Util.Pair((Object)user, (Object)role));
                    }
                }
                catch (UserManagementException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            return result;
        });
    }

    public Iterable<Role> getRolesFromUser(String username) throws UserManagementException {
        return (Iterable)LockUtil.executeWithReadLockAndResultExpectException((NamedReentrantReadWriteLock)this.usersLock, () -> {
            if (this.users.get(username) == null) {
                throw new UserManagementException("User does not exist");
            }
            Iterable roles = this.users.get(username).getRoles();
            return Util.addAll((Iterable)roles, new HashSet());
        });
    }

    public void addRoleForUser(String name, Role role) throws UserManagementException {
        LockUtil.executeWithWriteLockExpectException((NamedReentrantReadWriteLock)this.usersLock, () -> {
            User user = this.users.get(name);
            if (user == null) {
                throw new UserManagementException("User does not exist");
            }
            user.addRole(role);
            Util.addToValueSet(this.roleDefinitionsToUsers, (Object)role.getRoleDefinition(), (Object)user);
            if (this.mongoObjectFactory != null) {
                this.mongoObjectFactory.storeUser(user);
            }
        });
    }

    public void removeRoleFromUser(String name, Role role) throws UserManagementException {
        LockUtil.executeWithWriteLockExpectException((NamedReentrantReadWriteLock)this.usersLock, () -> {
            User user = this.users.get(name);
            if (user == null) {
                throw new UserManagementException("User does not exist");
            }
            user.removeRole(role);
            RoleDefinition roleDefinition = role.getRoleDefinition();
            boolean roleDefinitionStillGrantedToUser = false;
            for (Role roleOfUser : user.getRoles()) {
                if (!roleDefinition.equals(roleOfUser.getRoleDefinition())) continue;
                roleDefinitionStillGrantedToUser = true;
                break;
            }
            if (!roleDefinitionStillGrantedToUser) {
                Util.removeFromValueSet(this.roleDefinitionsToUsers, (Object)roleDefinition, (Object)user);
            }
            if (this.mongoObjectFactory != null) {
                this.mongoObjectFactory.storeUser(this.users.get(name));
            }
        });
    }

    public void addPermissionForUser(String username, WildcardPermission permission) throws UserManagementException {
        LockUtil.executeWithWriteLockExpectException((NamedReentrantReadWriteLock)this.usersLock, () -> {
            User user = this.users.get(username);
            if (user == null) {
                throw new UserManagementException("User does not exist");
            }
            user.addPermission(permission);
            if (this.mongoObjectFactory != null) {
                this.mongoObjectFactory.storeUser(user);
            }
        });
    }

    public void removePermissionFromUser(String name, WildcardPermission permission) throws UserManagementException {
        LockUtil.executeWithWriteLockExpectException((NamedReentrantReadWriteLock)this.usersLock, () -> {
            if (this.users.get(name) == null) {
                throw new UserManagementException("User does not exist");
            }
            this.users.get(name).removePermission(permission);
            if (this.mongoObjectFactory != null) {
                this.mongoObjectFactory.storeUser(this.users.get(name));
            }
        });
    }

    public void deleteUser(String name) throws UserManagementException {
        LockUtil.executeWithWriteLockExpectException((NamedReentrantReadWriteLock)this.usersLock, () -> {
            User user = this.users.get(name);
            if (user == null) {
                throw new UserManagementException("User does not exist");
            }
            logger.info("Deleting user: " + this.users.get(name).toString());
            if (this.mongoObjectFactory != null) {
                this.mongoObjectFactory.deleteUser(user);
            }
            this.users.remove(name);
            this.removeFromUsersByAccessToken(user);
            this.removeFromUsersByEmail(user);
            this.removeAllQualifiedRolesForUser(user);
            user.getRoles().forEach(role -> {
                boolean bl = Util.removeFromValueSet(this.roleDefinitionsToUsers, (Object)role.getRoleDefinition(), (Object)user);
            });
            LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.userGroupsLock, () -> {
                for (UserGroup userGroup : user.getUserGroups()) {
                    this.removeUserFromUserGroup(user, userGroup);
                }
            });
        });
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.preferenceLock, () -> this.removeAllPreferencesForUser(name));
    }

    private void removeFromUsersByAccessToken(User user) {
        assert (this.usersLock.isWriteLockedByCurrentThread());
        HashSet<String> entriesToRemove = new HashSet<String>();
        for (Map.Entry<String, User> entry2 : this.usersByAccessToken.entrySet()) {
            if (!entry2.getValue().equals(user)) continue;
            entriesToRemove.add(entry2.getKey());
        }
        entriesToRemove.forEach(entry -> {
            User user = this.usersByAccessToken.remove(entry);
        });
    }

    public <T> T getSetting(String key, Class<T> clazz) {
        Class<?> settingClazz = this.settingTypes.get(key);
        if (settingClazz == null) {
            return null;
        }
        if (!settingClazz.equals(clazz)) {
            throw new IllegalArgumentException("Value for \"" + key + "\" is not of type \"" + clazz.getName() + "\"!");
        }
        return clazz.cast(this.settings.get(key));
    }

    public void addSetting(String key, Class<?> type) {
        this.settingTypes.put(key, type);
        if (this.mongoObjectFactory != null) {
            this.mongoObjectFactory.storeSettingTypes(this.settingTypes);
        }
    }

    public boolean setSetting(String key, Object setting) {
        boolean result;
        Class<?> clazz = this.settingTypes.get(key);
        if (clazz == null || !clazz.isInstance(setting)) {
            result = false;
        } else {
            this.settings.put(key, setting);
            if (this.mongoObjectFactory != null) {
                this.mongoObjectFactory.storeSettings(this.settings);
            }
            result = true;
        }
        return result;
    }

    public void setPreference(String username, String key, String value) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.preferenceLock, () -> this.setPreferenceInternalAndUpdatePreferenceObjectIfConverterIsAvailable(username, key, value, true));
    }

    private void setPreferenceInternalAndUpdatePreferenceObjectIfConverterIsAvailable(String username, String key, String value, boolean store) {
        assert (this.preferenceLock.isWriteLockedByCurrentThread());
        this.setPreferenceInternal(username, key, value, store);
        this.updatePreferenceObjectIfConverterIsAvailable(username, key);
    }

    private void setPreferenceInternal(String username, String key, String value, boolean store) {
        assert (this.preferenceLock.isWriteLockedByCurrentThread());
        Map<String, String> userMap = this.preferences.get(username);
        if (value == null && userMap != null) {
            userMap.remove(key);
            if (userMap.isEmpty()) {
                this.preferences.remove(username);
            }
        } else if (value != null) {
            if (userMap == null) {
                userMap = new HashMap<String, String>();
                this.preferences.put(username, userMap);
            }
            userMap.put(key, value);
        }
        if (store && this.mongoObjectFactory != null) {
            this.mongoObjectFactory.storePreferences(username, userMap);
        }
    }

    public void unsetPreference(String username, String key) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.preferenceLock, () -> {
            Map<String, String> userMap = this.preferences.get(username);
            if (userMap != null) {
                userMap.remove(key);
                if (this.mongoObjectFactory != null) {
                    this.mongoObjectFactory.storePreferences(username, userMap);
                }
            }
            this.unsetPreferenceObject(username, key);
        });
    }

    public String getPreference(String username, String key) {
        return (String)LockUtil.executeWithWriteLockAndResult((NamedReentrantReadWriteLock)this.preferenceLock, () -> {
            Map<String, String> userMap = this.preferences.get(username);
            String result = userMap != null ? userMap.get(key) : null;
            return result;
        });
    }

    public Map<String, String> getAllPreferences(String username) {
        return (Map)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.preferenceLock, () -> {
            Map<String, String> userPrefs = this.preferences.get(username);
            Map<Object, Object> result = userPrefs == null ? Collections.emptyMap() : Collections.unmodifiableMap(userPrefs);
            return result;
        });
    }

    private void removeAllPreferencesForUser(String username) {
        assert (this.preferenceLock.isWriteLockedByCurrentThread());
        this.preferences.remove(username);
        if (this.mongoObjectFactory != null) {
            this.mongoObjectFactory.storePreferences(username, Collections.emptyMap());
        }
        this.removeAllPreferenceObjectsForUser(username);
    }

    private void removeAllPreferenceObjectsForUser(String username) {
        assert (this.preferenceLock.isWriteLockedByCurrentThread());
        Map<String, Object> preferenceObjectsToRemove = this.preferenceObjects.remove(username);
        if (preferenceObjectsToRemove != null) {
            for (Map.Entry<String, Object> entry : preferenceObjectsToRemove.entrySet()) {
                this.notifyListenersOnPreferenceObjectChange(username, entry.getKey(), entry.getValue(), null);
            }
        }
    }

    public Map<String, Object> getAllSettings() {
        return new HashMap<String, Object>(this.settings);
    }

    public Map<String, Class<?>> getAllSettingTypes() {
        return new HashMap(this.settingTypes);
    }

    public void registerPreferenceConverter(String preferenceKey, PreferenceConverter<?> converter) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.preferenceLock, () -> {
            PreferenceConverter alreadyAssociatedConverter = this.preferenceConverters.putIfAbsent(preferenceKey, converter);
            if (alreadyAssociatedConverter == null) {
                HashSet<String> usersToProcess = new HashSet<String>(this.preferences.keySet());
                for (String user : usersToProcess) {
                    this.updatePreferenceObjectWithConverter(user, preferenceKey, converter);
                }
            } else {
                logger.log(Level.SEVERE, "PreferenceConverter " + alreadyAssociatedConverter + " for key " + preferenceKey + " is already registered. Converter " + converter + " will not be registered");
            }
        });
    }

    public void removePreferenceConverter(String preferenceKey) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.preferenceLock, () -> {
            PreferenceConverter<?> preferenceConverterToRemove = this.preferenceConverters.remove(preferenceKey);
            if (preferenceConverterToRemove != null) {
                HashSet<String> usersToProcess = new HashSet<String>(this.preferences.keySet());
                for (String username : usersToProcess) {
                    this.unsetPreferenceObject(username, preferenceKey);
                }
            } else {
                logger.log(Level.WARNING, "PreferenceConverter for key " + preferenceKey + " should be removed but wasn't registered");
            }
        });
    }

    private void updatePreferenceObjectIfConverterIsAvailable(String username, String key) {
        assert (this.preferenceLock.isWriteLockedByCurrentThread());
        PreferenceConverter<?> preferenceConverter = this.preferenceConverters.get(key);
        if (preferenceConverter != null) {
            this.updatePreferenceObjectWithConverter(username, key, preferenceConverter);
        }
    }

    private void updatePreferenceObjectWithConverter(String username, String key, PreferenceConverter<?> preferenceConverter) {
        String preferenceString = this.getPreference(username, key);
        if (preferenceString != null) {
            try {
                Object convertedObject = preferenceConverter.toPreferenceObject(preferenceString);
                this.setPreferenceObjectInternal(username, key, convertedObject);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Error while converting preference for key " + key + " from String \"" + preferenceString + "\"", t);
            }
        }
    }

    private void setPreferenceObjectInternal(String username, String key, Object convertedObject) {
        Object oldPreference;
        assert (this.preferenceLock.isWriteLockedByCurrentThread());
        Map<String, Object> userMap = this.preferenceObjects.get(username);
        if (userMap == null) {
            userMap = new HashMap<String, Object>();
            this.preferenceObjects.put(username, userMap);
        }
        Object object = oldPreference = convertedObject == null ? userMap.remove(key) : userMap.put(key, convertedObject);
        if (oldPreference != null || convertedObject != null) {
            this.notifyListenersOnPreferenceObjectChange(username, key, oldPreference, convertedObject);
        }
    }

    private void unsetPreferenceObject(String username, String key) {
        assert (this.preferenceLock.isWriteLockedByCurrentThread());
        Map<String, Object> userObjectMap = this.preferenceObjects.get(username);
        if (userObjectMap != null) {
            Object oldPreference = userObjectMap.remove(key);
            if (oldPreference != null) {
                this.notifyListenersOnPreferenceObjectChange(username, key, oldPreference, null);
            }
            if (userObjectMap.isEmpty()) {
                this.preferenceObjects.remove(username);
            }
        }
    }

    public <T> T getPreferenceObject(String username, String key) {
        return (T)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.preferenceLock, () -> {
            Map<String, Object> userMap = this.preferenceObjects.get(username);
            Object result = userMap != null ? userMap.get(key) : null;
            Object resultT = result;
            return resultT;
        });
    }

    public <T> Map<String, T> getPreferenceObjectsByKey(String key) {
        return (Map)LockUtil.executeWithReadLockAndResult((NamedReentrantReadWriteLock)this.preferenceLock, () -> {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry<String, Map<String, Object>> userWithPreferences : this.preferenceObjects.entrySet()) {
                Map<String, Object> userPreferences = userWithPreferences.getValue();
                Object userPreference = userPreferences.get(key);
                if (userPreference == null) continue;
                result.put(userWithPreferences.getKey(), userPreference);
            }
            return Collections.unmodifiableMap(result);
        });
    }

    public String setPreferenceObject(String username, String key, Object preferenceObject) throws IllegalArgumentException {
        return (String)LockUtil.executeWithWriteLockAndResultExpectException((NamedReentrantReadWriteLock)this.preferenceLock, () -> {
            PreferenceConverter<?> preferenceConverter = this.preferenceConverters.get(key);
            if (preferenceConverter == null) {
                throw new IllegalArgumentException("Tried to set preference for key " + key + " but there is no converter associated!");
            }
            String stringPreference = null;
            if (preferenceObject == null) {
                this.unsetPreference(username, key);
            } else {
                try {
                    stringPreference = preferenceConverter.toPreferenceString(preferenceObject);
                    this.setPreferenceInternal(username, key, stringPreference, true);
                    this.setPreferenceObjectInternal(username, key, preferenceObject);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Error while converting preference for key " + key + " from Object \"" + preferenceObject + "\"", t);
                }
            }
            return stringPreference;
        });
    }

    private void notifyListenersOnPreferenceObjectChange(String username, String key, Object oldPreference, Object newPreference) {
        assert (this.preferenceLock.isWriteLockedByCurrentThread() || this.preferenceLock.getReadHoldCount() > 0);
        Iterator iterator = ((Set)Util.get(this.preferenceListeners, (Object)key, Collections.emptySet())).iterator();
        while (iterator.hasNext()) {
            PreferenceObjectListener listener;
            PreferenceObjectListener listenerToFire = listener = (PreferenceObjectListener)iterator.next();
            listenerToFire.preferenceObjectChanged(username, key, oldPreference, newPreference);
        }
    }

    public void addPreferenceObjectListener(String key, PreferenceObjectListener<? extends Object> listener, boolean fireForAlreadyExistingPreferences) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.preferenceLock, () -> {
            Util.addToValueSet(this.preferenceListeners, (Object)key, (Object)listener);
            if (fireForAlreadyExistingPreferences) {
                HashSet<String> usersToProcess = new HashSet<String>(this.preferences.keySet());
                for (String username : usersToProcess) {
                    Object preferenceObject;
                    Map<String, Object> userMap = this.preferenceObjects.get(username);
                    if (userMap == null || (preferenceObject = userMap.get(key)) == null) continue;
                    PreferenceObjectListener listenerToFire = listener;
                    listenerToFire.preferenceObjectChanged(username, key, null, preferenceObject);
                }
            }
        });
    }

    public void removePreferenceObjectListener(PreferenceObjectListener<?> listener) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.preferenceLock, () -> Util.removeFromAllValueSets(this.preferenceListeners, (Object)listener));
    }

    private void removeAllQualifiedRolesForUser(User user) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.usersLock, () -> {
            for (User checkUser : this.users.values()) {
                HashSet<Role> rolesToRemove = new HashSet<Role>();
                for (Role role : checkUser.getRoles()) {
                    if (!Util.equalsWithNull((Object)role.getQualifiedForUser(), (Object)user)) continue;
                    rolesToRemove.add(role);
                }
                for (Role roleToRremove : rolesToRemove) {
                    try {
                        this.removeRoleFromUser(checkUser.getName(), roleToRremove);
                    }
                    catch (UserManagementException e) {
                        logger.log(Level.WARNING, "Could not properly update qualified roles on user delete " + roleToRremove);
                    }
                }
            }
        });
    }

    private void removeAllQualifiedRolesForUserGroup(UserGroup userGroup) {
        assert (this.usersLock.isWriteLockedByCurrentThread());
        for (User checkUser : this.users.values()) {
            HashSet<Role> rolesToRemove = new HashSet<Role>();
            for (Role role : checkUser.getRoles()) {
                if (!Util.equalsWithNull((Object)role.getQualifiedForTenant(), (Object)userGroup)) continue;
                rolesToRemove.add(role);
            }
            for (Role roleToRemove : rolesToRemove) {
                try {
                    this.removeRoleFromUser(checkUser.getName(), roleToRemove);
                }
                catch (UserManagementException e) {
                    logger.log(Level.WARNING, "Could not properly update qualified roles on userGroup delete " + roleToRemove);
                }
            }
        }
    }

    public void deleteUserGroup(UserGroup userGroup) throws UserGroupManagementException {
        LockUtil.executeWithWriteLockExpectException((NamedReentrantReadWriteLock)this.usersLock, () -> LockUtil.executeWithWriteLockExpectException((NamedReentrantReadWriteLock)this.userGroupsLock, () -> {
            this.removeAllQualifiedRolesForUserGroup(userGroup);
            this.deleteUserGroupAndRemoveRelations(userGroup);
        }));
    }

    public void setDefaultTennantForUserAndUpdate(User user, UserGroup newDefaultTenant, String serverName) {
        LockUtil.executeWithWriteLock((NamedReentrantReadWriteLock)this.usersLock, () -> {
            user.setDefaultTenant(newDefaultTenant, serverName);
            this.updateUser(user);
        });
    }
}

