/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.data;

import com.sap.sse.common.Util;
import com.sap.sse.datamining.data.Cluster;
import com.sap.sse.datamining.data.ClusterBoundary;
import com.sap.sse.datamining.data.ClusterFormatter;
import com.sap.sse.datamining.impl.data.ClusterWithLowerAndUpperBoundaries;
import com.sap.sse.datamining.impl.data.ClusterWithSingleBoundary;
import com.sap.sse.datamining.impl.data.ComparisonStrategy;
import com.sap.sse.datamining.impl.data.LocalizedCluster;
import java.io.Serializable;

public abstract class AbstractClusterFormatter<T extends Serializable>
implements ClusterFormatter<T> {
    private static final char INFINITE = '\u221e';

    @Override
    public String format(Cluster<T> cluster) {
        if (cluster instanceof LocalizedCluster) {
            this.format(((LocalizedCluster)cluster).getInnerCluster());
        }
        if (cluster instanceof ClusterWithSingleBoundary) {
            return this.formatClusterWithSingleBoundary((ClusterWithSingleBoundary)cluster);
        }
        if (cluster instanceof ClusterWithLowerAndUpperBoundaries) {
            return this.formatClusterWithLowerAndUpperBoundaries((ClusterWithLowerAndUpperBoundaries)cluster);
        }
        throw new IllegalArgumentException("Can't format clusters of type " + cluster.getClass().getName());
    }

    protected String formatClusterWithSingleBoundary(ClusterWithSingleBoundary<T> cluster) {
        Iterable boundaries = cluster.getClusterBoundaries();
        if (boundaries == null) {
            return "<Unformattable>";
        }
        ClusterBoundary boundary = (ClusterBoundary)Util.first(boundaries);
        StringBuilder builder = new StringBuilder();
        if (boundary.getStrategy() == ComparisonStrategy.LOWER_EQUALS_THAN || boundary.getStrategy() == ComparisonStrategy.LOWER_THAN) {
            builder.append("-\u221e - ");
        }
        builder.append(this.formatBoundary(boundary));
        if (boundary.getStrategy() == ComparisonStrategy.GREATER_EQUALS_THAN || boundary.getStrategy() == ComparisonStrategy.GREATER_THAN) {
            builder.append(" - \u221e");
        }
        return builder.toString();
    }

    protected String formatClusterWithLowerAndUpperBoundaries(ClusterWithLowerAndUpperBoundaries<T> cluster) {
        Iterable boundaries = cluster.getClusterBoundaries();
        if (boundaries == null) {
            return "<Unformattable>";
        }
        return String.format("%s - %s", this.formatBoundary((ClusterBoundary)Util.get(boundaries, (int)0)), this.formatBoundary((ClusterBoundary)Util.get(boundaries, (int)1)));
    }

    protected String formatBoundary(ClusterBoundary<T> boundary) {
        String value = this.formatValue(boundary.getBoundaryValue());
        if (value == null) {
            return "<Unformattable>";
        }
        StringBuilder builder = new StringBuilder();
        ComparisonStrategy strategy = boundary.getStrategy();
        if (strategy == ComparisonStrategy.GREATER_EQUALS_THAN || strategy == ComparisonStrategy.GREATER_THAN) {
            builder.append(strategy.getSignifier());
        }
        builder.append(value);
        if (strategy == ComparisonStrategy.LOWER_EQUALS_THAN || strategy == ComparisonStrategy.LOWER_THAN) {
            builder.append(strategy.getSignifier());
        }
        return builder.toString();
    }

    protected abstract String formatValue(T var1);
}

