/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.aggregators;

import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataStoringAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class ParallelGroupedDataCollectingAsSetProcessor<DataType>
extends AbstractParallelGroupedDataStoringAggregationProcessor<DataType, HashSet<DataType>> {
    private final Map<GroupKey, HashSet<DataType>> collectedDataMappedByGroupKey = new HashMap<GroupKey, HashSet<DataType>>();

    public ParallelGroupedDataCollectingAsSetProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, HashSet<DataType>>, ?>> resultReceivers) {
        super(executor, resultReceivers, "Collecting");
    }

    @Override
    protected void storeElement(GroupedDataEntry<DataType> element) {
        if (!this.collectedDataMappedByGroupKey.containsKey(element.getKey())) {
            this.collectedDataMappedByGroupKey.put(element.getKey(), new HashSet());
        }
        this.collectedDataMappedByGroupKey.get(element.getKey()).add(element.getDataEntry());
    }

    @Override
    protected Map<GroupKey, HashSet<DataType>> aggregateResult() {
        return this.collectedDataMappedByGroupKey;
    }
}

