/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.aggregators;

import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public abstract class AbstractParallelSingleGroupedValueAggregationProcessor<ValueType>
extends AbstractParallelGroupedDataAggregationProcessor<ValueType, ValueType> {
    private Map<GroupKey, ValueType> valueMap = new HashMap<GroupKey, ValueType>();

    public AbstractParallelSingleGroupedValueAggregationProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, ValueType>, ?>> resultReceivers, String aggregationNameMessageKey) {
        super(executor, resultReceivers, aggregationNameMessageKey);
    }

    @Override
    public void handleElement(GroupedDataEntry<ValueType> element) {
        GroupKey key = element.getKey();
        ValueType value = element.getDataEntry();
        if (value != null) {
            if (!this.valueMap.containsKey(key)) {
                this.valueMap.put(key, value);
            } else {
                this.valueMap.put(key, this.compareValuesAndReturnNewResult(this.valueMap.get(key), value));
            }
        }
    }

    protected abstract ValueType compareValuesAndReturnNewResult(ValueType var1, ValueType var2);

    @Override
    public Map<GroupKey, ValueType> getResult() {
        return this.valueMap;
    }
}

