/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components;

import com.sap.sse.datamining.components.ProcessorInstruction;
import com.sap.sse.datamining.components.ProcessorInstructionHandler;
import com.sap.sse.datamining.impl.components.ProcessorInstructionPriority;

public abstract class AbstractProcessorInstruction<ResultType>
implements ProcessorInstruction<ResultType> {
    private final ProcessorInstructionHandler<ResultType> handler;
    private final int priority;

    public AbstractProcessorInstruction(ProcessorInstructionHandler<ResultType> handler) {
        this(handler, 0);
    }

    public AbstractProcessorInstruction(ProcessorInstructionHandler<ResultType> handler, ProcessorInstructionPriority priority) {
        this(handler, priority.asIntValue());
    }

    public AbstractProcessorInstruction(ProcessorInstructionHandler<ResultType> processor, int priority) {
        this.handler = processor;
        this.priority = priority;
    }

    @Override
    public void run() {
        try {
            try {
                if (!this.isAborted()) {
                    ResultType result = this.computeResult();
                    this.handler.instructionSucceeded(result);
                }
            }
            catch (Exception e) {
                this.handler.instructionFailed(e);
                this.handler.afterInstructionFinished(this);
            }
        }
        finally {
            this.handler.afterInstructionFinished(this);
        }
    }

    protected boolean isAborted() {
        return this.handler.isAborted();
    }

    protected abstract ResultType computeResult() throws Exception;

    public ProcessorInstructionHandler<ResultType> getHandler() {
        return this.handler;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(ProcessorInstruction<?> instruction) {
        return Integer.compare(this.priority, instruction.getPriority());
    }
}

