/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.datamining.components;

import com.sap.sailing.datamining.data.HasLeaderboardGroupContext;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.polars.datamining.data.HasLeaderboardPolarContext;
import com.sap.sailing.polars.datamining.data.impl.LeaderboardWithPolarContext;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import com.sap.sse.security.shared.HasPermissions;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class PolarLeaderboardRetrievalProcessor
extends AbstractRetrievalProcessor<HasLeaderboardGroupContext, HasLeaderboardPolarContext> {
    public PolarLeaderboardRetrievalProcessor(ExecutorService executor, Collection<Processor<HasLeaderboardPolarContext, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasLeaderboardGroupContext.class, HasLeaderboardPolarContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HasLeaderboardPolarContext> retrieveData(HasLeaderboardGroupContext element) {
        HashSet<HasLeaderboardPolarContext> leaderboardsWithContext = new HashSet<HasLeaderboardPolarContext>();
        for (Leaderboard leaderboard : element.getLeaderboardGroup().getLeaderboards()) {
            if (this.isAborted()) break;
            Subject subject = SecurityUtils.getSubject();
            if (!subject.isPermitted(leaderboard.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ))) continue;
            leaderboardsWithContext.add(new LeaderboardWithPolarContext(leaderboard, element));
        }
        return leaderboardsWithContext;
    }
}

