/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.datamining;

import com.sap.sailing.datamining.data.HasLeaderboardGroupContext;
import com.sap.sailing.datamining.provider.RacingEventServiceProvider;
import com.sap.sailing.polars.datamining.PolarsDataRetrievalChainDefinitions;
import com.sap.sailing.polars.datamining.components.aggregators.PolarBackendDataAggregationProcessor;
import com.sap.sailing.polars.datamining.components.aggregators.PolarDataAggregationProcessor;
import com.sap.sailing.polars.datamining.data.HasBackendPolarBoatClassContext;
import com.sap.sailing.polars.datamining.data.HasCompetitorPolarContext;
import com.sap.sailing.polars.datamining.data.HasFleetPolarContext;
import com.sap.sailing.polars.datamining.data.HasGPSFixPolarContext;
import com.sap.sailing.polars.datamining.data.HasLeaderboardPolarContext;
import com.sap.sailing.polars.datamining.data.HasLegPolarContext;
import com.sap.sailing.polars.datamining.data.HasRaceColumnPolarContext;
import com.sap.sse.datamining.DataSourceProvider;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.DataRetrieverChainDefinition;
import com.sap.sse.datamining.impl.AbstractDataMiningActivator;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import com.sap.sse.i18n.impl.ResourceBundleStringMessagesImpl;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractDataMiningActivator {
    private static final String STRING_MESSAGES_BASE_NAME = "stringmessages/Polars_StringMessages";
    private static Activator INSTANCE;
    private BundleContext context = null;
    private final ResourceBundleStringMessages sailingServerStringMessages;
    private final PolarsDataRetrievalChainDefinitions dataRetrieverChainDefinitions = new PolarsDataRetrievalChainDefinitions();
    private Collection<DataSourceProvider<?>> dataSourceProviders;
    private boolean dataSourceProvidersHaveBeenInitialized;

    public Activator() {
        this.sailingServerStringMessages = new ResourceBundleStringMessagesImpl(STRING_MESSAGES_BASE_NAME, this.getClassLoader(), StandardCharsets.UTF_8.name());
    }

    public void start(BundleContext context) throws Exception {
        INSTANCE = this;
        this.context = context;
        this.dataSourceProvidersHaveBeenInitialized = false;
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.context = null;
        INSTANCE = null;
        super.stop(context);
    }

    public ResourceBundleStringMessages getStringMessages() {
        return this.sailingServerStringMessages;
    }

    public Iterable<Class<?>> getClassesWithMarkedMethods() {
        HashSet internalClasses = new HashSet();
        internalClasses.add(HasLeaderboardGroupContext.class);
        internalClasses.add(HasLeaderboardPolarContext.class);
        internalClasses.add(HasRaceColumnPolarContext.class);
        internalClasses.add(HasFleetPolarContext.class);
        internalClasses.add(HasCompetitorPolarContext.class);
        internalClasses.add(HasLegPolarContext.class);
        internalClasses.add(HasGPSFixPolarContext.class);
        internalClasses.add(HasBackendPolarBoatClassContext.class);
        return internalClasses;
    }

    public Iterable<DataRetrieverChainDefinition<?, ?>> getDataRetrieverChainDefinitions() {
        return this.dataRetrieverChainDefinitions.getDataRetrieverChainDefinitions();
    }

    public Iterable<DataSourceProvider<?>> getDataSourceProviders() {
        if (!this.dataSourceProvidersHaveBeenInitialized) {
            this.initializeDataSourceProviders();
            this.dataSourceProvidersHaveBeenInitialized = true;
        }
        return this.dataSourceProviders;
    }

    public Iterable<AggregationProcessorDefinition<?, ?>> getAggregationProcessorDefinitions() {
        HashSet aggregators = new HashSet();
        aggregators.add(PolarDataAggregationProcessor.getDefinition());
        aggregators.add(PolarBackendDataAggregationProcessor.getDefinition());
        return aggregators;
    }

    private void initializeDataSourceProviders() {
        this.dataSourceProviders = new HashSet();
        this.dataSourceProviders.add((DataSourceProvider<?>)new RacingEventServiceProvider(this.context));
    }

    public static Activator getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new Activator();
        }
        return INSTANCE;
    }
}

