/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.persistence.impl;

import com.igtimi.IgtimiData;
import com.igtimi.IgtimiDevice;
import com.igtimi.IgtimiStream;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.sap.sailing.domain.igtimiadapter.DataAccessWindow;
import com.sap.sailing.domain.igtimiadapter.DataPointTimePointExtractor;
import com.sap.sailing.domain.igtimiadapter.DataPointVisitor;
import com.sap.sailing.domain.igtimiadapter.Device;
import com.sap.sailing.domain.igtimiadapter.persistence.MongoObjectFactory;
import com.sap.sailing.domain.igtimiadapter.persistence.impl.CollectionNames;
import com.sap.sailing.domain.igtimiadapter.persistence.impl.FieldNames;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.Iterator;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;

public class MongoObjectFactoryImpl
implements MongoObjectFactory {
    private final MongoDatabase db;
    private final MongoCollection<Document> messagesCollection;

    public MongoObjectFactoryImpl(MongoDatabase db) {
        this.db = db;
        this.messagesCollection = MongoObjectFactoryImpl.getOrCreateMessagesCollection(db);
    }

    static MongoCollection<Document> getOrCreateMessagesCollection(MongoDatabase database) {
        MongoCollection messagesCollection = database.getCollection(CollectionNames.IGTIMI_MESSAGES.name());
        Document index = new Document().append(FieldNames.IGTIMI_MESSAGES_DEVICE_SERIAL_NUMBER.name(), (Object)1).append(FieldNames.IGTIMI_MESSAGES_TIMESTAMP.name(), (Object)1);
        IndexOptions indexOptions = new IndexOptions().name("fixbydevandtime").background(false);
        messagesCollection.createIndex((Bson)index, indexOptions);
        return messagesCollection;
    }

    @Override
    public void clear(ClientSession clientSessionOrNull) {
        MongoCollection devicesCollection = this.db.getCollection(CollectionNames.IGTIMI_DEVICES.name()).withWriteConcern(WriteConcern.ACKNOWLEDGED);
        MongoCollection dataAccessWindowsCollections = this.db.getCollection(CollectionNames.IGTIMI_DATA_ACCESS_WINDOWS.name()).withWriteConcern(WriteConcern.ACKNOWLEDGED);
        if (clientSessionOrNull == null) {
            devicesCollection.drop();
            dataAccessWindowsCollections.drop();
            this.messagesCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).drop();
        } else {
            devicesCollection.drop(clientSessionOrNull);
            dataAccessWindowsCollections.drop(clientSessionOrNull);
            this.messagesCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).drop(clientSessionOrNull);
        }
    }

    @Override
    public void storeDevice(Device device, ClientSession clientSessionOrNull) {
        Document filter = new Document(FieldNames.IGTIMI_DEVICES_ID.name(), (Object)device.getId());
        Document update = new Document();
        update.put(FieldNames.IGTIMI_DEVICES_ID.name(), (Object)device.getId());
        update.put(FieldNames.IGTIMI_DEVICES_NAME.name(), (Object)device.getName());
        update.put(FieldNames.IGTIMI_DEVICES_SERIAL_NUMBER.name(), (Object)device.getSerialNumber());
        update.put(FieldNames.IGTIMI_DEVICES_LAST_HEARTBEAT_MILLIS.name(), device.getLastHeartbeat() == null ? null : (device.getLastHeartbeat().getA() == null ? null : Long.valueOf(((TimePoint)device.getLastHeartbeat().getA()).asMillis())));
        update.put(FieldNames.IGTIMI_DEVICES_REMOTE_ADDRESS.name(), device.getLastHeartbeat() == null ? null : device.getLastHeartbeat().getB());
        MongoCollection deviceCollection = this.db.getCollection(CollectionNames.IGTIMI_DEVICES.name()).withWriteConcern(WriteConcern.ACKNOWLEDGED);
        if (clientSessionOrNull == null) {
            deviceCollection.replaceOne((Bson)filter, (Object)update, new ReplaceOptions().upsert(true));
        } else {
            deviceCollection.replaceOne(clientSessionOrNull, (Bson)filter, (Object)update, new ReplaceOptions().upsert(true));
        }
    }

    @Override
    public void removeDevice(long deviceId, ClientSession clientSessionOrNull) {
        Document filter = new Document(FieldNames.IGTIMI_DEVICES_ID.name(), (Object)deviceId);
        MongoCollection deviceCollection = this.db.getCollection(CollectionNames.IGTIMI_DEVICES.name()).withWriteConcern(WriteConcern.ACKNOWLEDGED);
        if (clientSessionOrNull == null) {
            deviceCollection.deleteOne((Bson)filter);
        } else {
            deviceCollection.deleteOne(clientSessionOrNull, (Bson)filter);
        }
    }

    @Override
    public void storeDataAccessWindow(DataAccessWindow daw, ClientSession clientSessionOrNull) {
        Document filter = new Document(FieldNames.IGTIMI_DATA_ACCESS_WINDOWS_ID.name(), (Object)daw.getId());
        Document update = new Document();
        update.put(FieldNames.IGTIMI_DATA_ACCESS_WINDOWS_ID.name(), (Object)daw.getId());
        update.put(FieldNames.IGTIMI_DATA_ACCESS_WINDOWS_DEVICE_SERIAL_NUMBER.name(), (Object)daw.getDeviceSerialNumber());
        update.put(FieldNames.IGTIMI_DATA_ACCESS_WINDOWS_START_TIME_MILLIS.name(), daw.getStartTime() == null ? null : Long.valueOf(daw.getStartTime().asMillis()));
        update.put(FieldNames.IGTIMI_DATA_ACCESS_WINDOWS_END_TIME_MILLIS.name(), daw.getEndTime() == null ? null : Long.valueOf(daw.getEndTime().asMillis()));
        MongoCollection dataAccessWindowsCollection = this.db.getCollection(CollectionNames.IGTIMI_DATA_ACCESS_WINDOWS.name()).withWriteConcern(WriteConcern.ACKNOWLEDGED);
        if (clientSessionOrNull == null) {
            dataAccessWindowsCollection.replaceOne((Bson)filter, (Object)update, new ReplaceOptions().upsert(true));
        } else {
            dataAccessWindowsCollection.replaceOne(clientSessionOrNull, (Bson)filter, (Object)update, new ReplaceOptions().upsert(true));
        }
    }

    @Override
    public void removeDataAccessWindow(long dawId, ClientSession clientSessionOrNull) {
        Document filter = new Document(FieldNames.IGTIMI_DEVICES_ID.name(), (Object)dawId);
        MongoCollection dataAccessWindowsCollection = this.db.getCollection(CollectionNames.IGTIMI_DATA_ACCESS_WINDOWS.name()).withWriteConcern(WriteConcern.ACKNOWLEDGED);
        if (clientSessionOrNull == null) {
            dataAccessWindowsCollection.deleteOne((Bson)filter);
        } else {
            dataAccessWindowsCollection.deleteOne(clientSessionOrNull, (Bson)filter);
        }
    }

    @Override
    public void storeMessage(String serialNumber, IgtimiStream.Msg message, ClientSession clientSessionOrNull) {
        if (Util.hasLength((String)serialNumber)) {
            TimePoint timePointFromMessage = this.extractTimePointFromMessage(message);
            TimePoint effectiveTimePoint = timePointFromMessage == null ? TimePoint.now() : timePointFromMessage;
            Document doc = new Document(FieldNames.IGTIMI_MESSAGES_TIMESTAMP.name(), (Object)effectiveTimePoint.asDate());
            doc.put(FieldNames.IGTIMI_MESSAGES_DEVICE_SERIAL_NUMBER.name(), (Object)serialNumber);
            doc.put(FieldNames.IGTIMI_MESSAGES_PROTOBUF_MESSAGE.name(), (Object)new Binary(message.toByteArray()));
            if (clientSessionOrNull == null) {
                this.messagesCollection.insertOne((Object)doc);
            } else {
                this.messagesCollection.insertOne(clientSessionOrNull, (Object)doc);
            }
        }
    }

    private TimePoint extractTimePointFromMessage(IgtimiStream.Msg message) {
        IgtimiDevice.DeviceManagement deviceManagement;
        if (message.hasData()) {
            for (IgtimiData.DataMsg data : message.getData().getDataList()) {
                Iterator iterator = data.getDataList().iterator();
                if (!iterator.hasNext()) continue;
                IgtimiData.DataPoint dataPoint = (IgtimiData.DataPoint)iterator.next();
                return (TimePoint)DataPointVisitor.accept((IgtimiData.DataPoint)dataPoint, (DataPointVisitor)new DataPointTimePointExtractor());
            }
        } else if (message.hasDeviceManagement() && (deviceManagement = message.getDeviceManagement()).hasResponse()) {
            IgtimiDevice.DeviceManagementResponse response = deviceManagement.getResponse();
            return TimePoint.of((long)response.getTimestamp());
        }
        return null;
    }
}

