/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.windestimation;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoat;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.CompetitorAndBoatImpl;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.confidence.impl.ScalableDouble;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalableBearing;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.polars.windestimation.AbstractManeuverBasedWindEstimationTrackImpl;
import com.sap.sailing.polars.windestimation.ManeuverClassification;
import com.sap.sailing.polars.windestimation.ManeuverClassificationImpl;
import com.sap.sailing.polars.windestimation.ScalableBearingAndScalableDouble;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.scalablevalue.ScalableValue;
import com.sap.sse.util.kmeans.Cluster;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class ManeuverBasedWindEstimationTrackImpl
extends AbstractManeuverBasedWindEstimationTrackImpl {
    private static final long serialVersionUID = -7608973407450278215L;
    private final TrackedRace trackedRace;
    private boolean waitForLatest;
    private final PolarDataService polarService;

    public ManeuverBasedWindEstimationTrackImpl(PolarDataService polarService, TrackedRace trackedRace, long millisecondsOverWhichToAverage, boolean waitForLatest) throws NotEnoughDataHasBeenAddedException {
        super(trackedRace.getRace().getName(), trackedRace.getRace().getBoatClass(), millisecondsOverWhichToAverage);
        this.polarService = polarService;
        this.trackedRace = trackedRace;
        this.waitForLatest = waitForLatest;
    }

    @Override
    protected double getLikelihoodOfBeingTackCluster(Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble> cluster, Set<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> clusters) {
        double result;
        if (cluster.isEmpty()) {
            result = 0.0;
        } else {
            double averageTackLikelihood = this.getAverageLikelihoodOfBeingManeuver(ManeuverType.TACK, cluster.stream());
            Bearing approximateMiddleCOG = (Bearing)this.getWeightedAverageMiddleManeuverCOGDegAndManeuverAngleDeg(cluster, ManeuverType.TACK).getA();
            Cluster oppositeTackCluster = clusters.stream().filter(c -> c != cluster).min((a, b) -> a.isEmpty() ? (b.isEmpty() ? 0 : -1) : (b.isEmpty() ? 1 : (int)Math.signum(this.getClusterDistanceBasedOnAverageManeuverLikelihoodAndWeightedAverageMiddleCOG((Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>)a, -((Double)((Util.Pair)cluster.getCentroid()).getB()).doubleValue(), approximateMiddleCOG) - this.getClusterDistanceBasedOnAverageManeuverLikelihoodAndWeightedAverageMiddleCOG((Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>)b, -((Double)((Util.Pair)cluster.getCentroid()).getB()).doubleValue(), approximateMiddleCOG)))).orElse(null);
            double likelihoodOfOppositeCluster = oppositeTackCluster.isEmpty() ? 0.1 : this.getLikelihoodOfClusterBasedOnDistanceFromExpected(-((Double)((Util.Pair)cluster.getCentroid()).getB()).doubleValue(), approximateMiddleCOG, (Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>)oppositeTackCluster);
            double averageTackingAngleDeg = (Math.abs((Double)this.getWeightedAverageMiddleManeuverCOGDegAndManeuverAngleDeg(cluster, ManeuverType.TACK).getB()) + likelihoodOfOppositeCluster * Math.abs((Double)this.getWeightedAverageMiddleManeuverCOGDegAndManeuverAngleDeg((Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>)oppositeTackCluster, ManeuverType.TACK).getB())) / (1.0 + likelihoodOfOppositeCluster);
            Bearing averageUpwindCOG = new ScalableBearing((Bearing)this.getWeightedAverageMiddleManeuverCOGDegAndManeuverAngleDeg(cluster, ManeuverType.TACK).getA()).add((ScalableValue)new ScalableBearing((Bearing)this.getWeightedAverageMiddleManeuverCOGDegAndManeuverAngleDeg((Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>)oppositeTackCluster, ManeuverType.TACK).getA()).multiply(likelihoodOfOppositeCluster)).divide(1.0 + likelihoodOfOppositeCluster);
            Bearing expectedUpwindStarboardTackCOG = averageUpwindCOG.add((Bearing)new DegreeBearingImpl(-averageTackingAngleDeg / 2.0));
            double starboardHeadUpBearAwayClusterLikelihood = this.getLikelihoodOfBestFittingHeadUpBearAwayCluster(clusters.stream().filter(c -> c != cluster), expectedUpwindStarboardTackCOG);
            Bearing expectedUpwindPortTackCOG = averageUpwindCOG.add((Bearing)new DegreeBearingImpl(averageTackingAngleDeg / 2.0));
            double portHeadUpBearAwayClusterLikelihood = this.getLikelihoodOfBestFittingHeadUpBearAwayCluster(clusters.stream().filter(c -> c != cluster), expectedUpwindPortTackCOG);
            Bearing approximateMiddleCOGForJibes = averageUpwindCOG.reverse();
            Stream<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> jibeClusters = this.getJibeClusters(approximateMiddleCOGForJibes, clusters);
            Speed tackClusterWeightedAverageSpeed = this.getWeightedAverageSpeed(cluster.stream(), ManeuverType.TACK);
            if (tackClusterWeightedAverageSpeed != null) {
                double jibeClusterLikelihood = this.getLikelihoodOfBeingJibeCluster(tackClusterWeightedAverageSpeed, jibeClusters.map(jc -> jc.stream()).reduce(Stream::concat).orElse(Stream.empty()), this.getBoatClass(), clusters);
                result = Math.min(1.0, averageTackLikelihood * likelihoodOfOppositeCluster * (1.0 + 0.2 * jibeClusterLikelihood + 0.1 * starboardHeadUpBearAwayClusterLikelihood + 0.1 * portHeadUpBearAwayClusterLikelihood));
            } else {
                result = 0.1;
            }
        }
        return result;
    }

    protected double getLikelihoodOfBestFittingHeadUpBearAwayCluster(Stream<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> clusters, Bearing expectedAverageMiddleCOG) {
        Cluster starboardTackHeadUpAndBearAwayCluster = clusters.max((a, b) -> (int)Math.signum(this.getLikelihoodOfClusterBasedOnDistanceFromExpected(10.0, expectedAverageMiddleCOG, (Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>)a) - this.getLikelihoodOfClusterBasedOnDistanceFromExpected(10.0, expectedAverageMiddleCOG, (Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>)b))).orElse(null);
        double starboardHeadUpBearAwayClusterLikelihood = starboardTackHeadUpAndBearAwayCluster == null ? 0.0 : this.getLikelihoodOfClusterBasedOnDistanceFromExpected(10.0, expectedAverageMiddleCOG, (Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>)starboardTackHeadUpAndBearAwayCluster);
        return starboardHeadUpBearAwayClusterLikelihood;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected double getLikelihoodOfBeingJibeCluster(Speed tackClusterWeightedAverageSpeed, Stream<ManeuverClassification> jibeClustersContent, BoatClass boatClass, Set<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> clusters) {
        int[] count = new int[1];
        double[] likelihoodSum = new double[1];
        ScalableBearing[] scaledAverageDownwindCOG = new ScalableBearing[1];
        double[] scaledAbsJibingAngleSum = new double[1];
        Stream<ManeuverClassification> jibeClustersContentPeeker = jibeClustersContent.peek(mc -> {
            nArray[0] = count[0] + 1;
            double likelihood = mc.getLikelihoodForManeuverType(ManeuverType.JIBE);
            dArray[0] = likelihoodSum[0] + likelihood;
            ScalableBearing scaledCOG = new ScalableBearing(mc.getMiddleManeuverCourse()).multiply(likelihood);
            scalableBearingArray[0] = scaledAverageDownwindCOG[0] == null ? scaledCOG : scaledAverageDownwindCOG[0].add((ScalableValue)scaledCOG);
            dArray2[0] = scaledAbsJibingAngleSum[0] + likelihood * Math.abs(mc.getManeuverAngleDeg());
        });
        Speed jibeClusterWeightedAverageSpeed = this.getWeightedAverageSpeed(jibeClustersContentPeeker, ManeuverType.JIBE);
        Bearing averageDownwindCOG = scaledAverageDownwindCOG[0] == null ? null : scaledAverageDownwindCOG[0].divide(likelihoodSum[0]);
        double absWeightedAverageJibingAbgle = scaledAbsJibingAngleSum[0] / likelihoodSum[0];
        if (jibeClusterWeightedAverageSpeed == null) return 0.1;
        double tackJibeSpeedRatioLikelihood = this.polarService.getConfidenceForTackJibeSpeedRatio(tackClusterWeightedAverageSpeed, jibeClusterWeightedAverageSpeed, boatClass);
        if (count[0] <= 0) throw new RuntimeException("Internal error: no maneuvers in jibe cluster candidate but still a valid weighted average speed " + jibeClusterWeightedAverageSpeed);
        double averageJibeLikelihood = likelihoodSum[0] / (double)count[0];
        Bearing expectedDownwindStarboardTackCOG = averageDownwindCOG.add((Bearing)new DegreeBearingImpl(absWeightedAverageJibingAbgle / 2.0));
        double starboardHeadUpBearAwayClusterLikelihood = this.getLikelihoodOfBestFittingHeadUpBearAwayCluster(clusters.stream(), expectedDownwindStarboardTackCOG);
        Bearing expectedDownwindPortTackCOG = averageDownwindCOG.add((Bearing)new DegreeBearingImpl(-absWeightedAverageJibingAbgle / 2.0));
        double portHeadUpBearAwayClusterLikelihood = this.getLikelihoodOfBestFittingHeadUpBearAwayCluster(clusters.stream(), expectedDownwindPortTackCOG);
        return Math.min(1.0, averageJibeLikelihood * (1.0 + 0.0 * tackJibeSpeedRatioLikelihood + 0.1 * starboardHeadUpBearAwayClusterLikelihood + 0.1 * portHeadUpBearAwayClusterLikelihood));
    }

    @Override
    protected Stream<ManeuverClassification> getManeuverClassifications() {
        Map<Maneuver, CompetitorAndBoat> maneuvers = this.getAllManeuvers(this.waitForLatest);
        return maneuvers.entrySet().stream().map(maneuverAndCompetitor -> new ManeuverClassificationImpl((CompetitorAndBoat)maneuverAndCompetitor.getValue(), (Maneuver)maneuverAndCompetitor.getKey(), this.polarService));
    }

    Map<Maneuver, CompetitorAndBoat> getAllManeuvers(boolean waitForLatest) {
        HashMap<Maneuver, CompetitorAndBoatImpl> maneuvers = new HashMap<Maneuver, CompetitorAndBoatImpl>();
        Waypoint firstWaypoint = this.trackedRace.getRace().getCourse().getFirstWaypoint();
        Waypoint lastWaypoint = this.trackedRace.getRace().getCourse().getLastWaypoint();
        for (Map.Entry competitorAndBoat : this.trackedRace.getRace().getCompetitorsAndTheirBoats().entrySet()) {
            Competitor competitor = (Competitor)competitorAndBoat.getKey();
            Boat boat = (Boat)competitorAndBoat.getValue();
            TimePoint from = (TimePoint)Util.getFirstNonNull((Object[])new TimePoint[]{firstWaypoint == null ? null : (this.trackedRace.getMarkPassing(competitor, firstWaypoint) == null ? null : this.trackedRace.getMarkPassing(competitor, firstWaypoint).getTimePoint()), this.trackedRace.getStartOfRace(), this.trackedRace.getStartOfTracking()});
            TimePoint to = (TimePoint)Util.getFirstNonNull((Object[])new TimePoint[]{lastWaypoint == null ? null : (this.trackedRace.getMarkPassing(competitor, lastWaypoint) == null ? null : this.trackedRace.getMarkPassing(competitor, lastWaypoint).getTimePoint()), this.trackedRace.getEndOfRace(), this.trackedRace.getEndOfTracking(), MillisecondsTimePoint.now()});
            for (Maneuver maneuver : this.trackedRace.getManeuvers(competitor, from, to, waitForLatest)) {
                maneuvers.put(maneuver, new CompetitorAndBoatImpl(competitor, boat));
            }
        }
        return Collections.unmodifiableMap(maneuvers);
    }

    protected double getLikelihoodOfClusterBasedOnDistanceFromExpected(double expectedManeuverAngleDeg, Bearing expectedApproximateMiddleCOG, Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble> oppositeTackCluster) {
        double clusterDistanceFromExpected = this.getClusterDistanceBasedOnAverageManeuverLikelihoodAndWeightedAverageMiddleCOG(oppositeTackCluster, expectedManeuverAngleDeg, expectedApproximateMiddleCOG);
        return this.getLikelihoodOfClusterBasedOnDistanceFromExpected(clusterDistanceFromExpected);
    }

    protected double getLikelihoodOfClusterBasedOnDistanceFromExpected(double clusterDistanceFromExpected) {
        return Math.exp(Math.log(0.5) * (clusterDistanceFromExpected / 20.0));
    }

    private double getClusterDistanceBasedOnAverageManeuverLikelihoodAndWeightedAverageMiddleCOG(Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble> cluster, double expectedManeuverAngleDeg, Bearing expectedApproximateMiddleCOG) {
        Util.Pair<Bearing, Double> weightedAverageMiddleManeuverCOGDegAndManeuverAngleDeg = this.getWeightedAverageMiddleManeuverCOGDegAndManeuverAngleDeg(cluster, ManeuverType.TACK);
        Bearing weightedAverageMiddleCOG = (Bearing)weightedAverageMiddleManeuverCOGDegAndManeuverAngleDeg.getA();
        Double weightedAverageManeuverAngle = (Double)weightedAverageMiddleManeuverCOGDegAndManeuverAngleDeg.getB();
        return this.getClusterDistance(expectedManeuverAngleDeg, expectedApproximateMiddleCOG, weightedAverageManeuverAngle, weightedAverageMiddleCOG);
    }

    private double getClusterDistance(double expectedManeuverAngleDeg, Bearing expectedApproximateMiddleCOG, double weightedAverageManeuverAngle, Bearing weightedAverageMiddleCOG) {
        double middleCOGDiff = weightedAverageMiddleCOG.getDifferenceTo(expectedApproximateMiddleCOG).getDegrees();
        double maneuverAngleDiff = weightedAverageManeuverAngle - expectedManeuverAngleDeg;
        return Math.sqrt(middleCOGDiff * middleCOGDiff + maneuverAngleDiff * maneuverAngleDiff);
    }
}

