/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.Person;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONObject;

public class PersonJsonSerializer
implements JsonSerializer<Person> {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_NATIONALITY = "nationality";
    public static final String FIELD_DATE_OF_BIRTH = "dateOfBirth";
    private final JsonSerializer<Nationality> nationalityJsonSerializer;

    public PersonJsonSerializer(JsonSerializer<Nationality> nationalityJsonSerializer) {
        this.nationalityJsonSerializer = nationalityJsonSerializer;
    }

    public JSONObject serialize(Person person) {
        if (person == null) {
            return null;
        }
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_NAME, (Object)person.getName());
        if (person.getDateOfBirth() != null) {
            result.put((Object)FIELD_DATE_OF_BIRTH, (Object)person.getDateOfBirth().getTime());
        }
        result.put((Object)FIELD_DESCRIPTION, (Object)person.getDescription());
        result.put((Object)FIELD_NATIONALITY, (Object)this.nationalityJsonSerializer.serialize((Object)person.getNationality()));
        return result;
    }
}

