/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.coursedata.impl;

import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.domain.tracking.LineDetails;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.CourseBaseJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.WaypointJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.PositionJsonSerializer;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Util;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.Map;
import org.json.simple.JSONObject;

public class CourseBaseWithGeometryJsonSerializer
implements JsonSerializer<Util.Triple<CourseBase, CourseGeometry, LineDetails>> {
    public static final String FIELD_TOTAL_DISTANCE_IN_METERS = "totalDistanceInMeters";
    public static final String FIELD_LEG_DISTANCE_IN_METERS = "legDistanceInMeters";
    public static final String FIELD_LEG_BEARING_TRUE_DEGREES = "legBearingTrueDegrees";
    public static final String FIELD_START_LINE = "startLine";
    public static final String FIELD_MARK_ID = "markId";
    public static final String FIELD_MARK_POSITION = "position";
    private static final PositionJsonSerializer positionSerializer = new PositionJsonSerializer();
    private JsonSerializer<Waypoint> waypointSerializer;

    public CourseBaseWithGeometryJsonSerializer(WaypointJsonSerializer waypointSerializer) {
        this.waypointSerializer = waypointSerializer;
    }

    public JSONObject serialize(final Util.Triple<CourseBase, CourseGeometry, LineDetails> courseAndOptionalGeometry) {
        final CourseBase course = (CourseBase)courseAndOptionalGeometry.getA();
        final CourseGeometry geometry = (CourseGeometry)courseAndOptionalGeometry.getB();
        JSONObject result = new CourseBaseJsonSerializer(this.waypointSerializer){

            @Override
            protected JSONObject serializeWaypoint(Waypoint waypoint) {
                JSONObject result = super.serializeWaypoint(waypoint);
                if (geometry != null) {
                    int waypointIndex = course.getIndexOfWaypoint(waypoint);
                    if (waypointIndex >= 0 && course.getLegs().size() > waypointIndex) {
                        Leg leg = (Leg)course.getLegs().get(waypointIndex);
                        Distance distance = geometry.getLegDistances().get(leg);
                        result.put((Object)CourseBaseWithGeometryJsonSerializer.FIELD_LEG_DISTANCE_IN_METERS, distance == null ? null : Double.valueOf(distance.getMeters()));
                        Bearing bearing = geometry.getLegBearings().get(leg);
                        result.put((Object)CourseBaseWithGeometryJsonSerializer.FIELD_LEG_BEARING_TRUE_DEGREES, bearing == null ? null : Double.valueOf(bearing.getDegrees()));
                    }
                    LineDetails startLineProperties = (LineDetails)courseAndOptionalGeometry.getC();
                    if (waypointIndex == 0 && startLineProperties != null) {
                        JSONObject startLine = new JSONObject();
                        JSONObject portSide = new JSONObject();
                        JSONObject starboardSide = new JSONObject();
                        portSide.put((Object)CourseBaseWithGeometryJsonSerializer.FIELD_MARK_ID, (Object)startLineProperties.getPortMarkWhileApproachingLine().getId().toString());
                        portSide.put((Object)CourseBaseWithGeometryJsonSerializer.FIELD_MARK_POSITION, (Object)positionSerializer.serialize(startLineProperties.getPortMarkPosition()));
                        starboardSide.put((Object)CourseBaseWithGeometryJsonSerializer.FIELD_MARK_ID, (Object)startLineProperties.getStarboardMarkWhileApproachingLine().getId().toString());
                        starboardSide.put((Object)CourseBaseWithGeometryJsonSerializer.FIELD_MARK_POSITION, (Object)positionSerializer.serialize(startLineProperties.getStarboardMarkPosition()));
                        startLine.put((Object)NauticalSide.STARBOARD.name(), (Object)startLineProperties.getStarboardMarkWhileApproachingLine().getId().toString());
                        startLine.put((Object)NauticalSide.PORT.name(), (Object)portSide);
                        startLine.put((Object)NauticalSide.STARBOARD.name(), (Object)starboardSide);
                        result.put((Object)CourseBaseWithGeometryJsonSerializer.FIELD_START_LINE, (Object)startLine);
                    }
                }
                return result;
            }
        }.serialize(course);
        if (courseAndOptionalGeometry.getB() != null) {
            Distance totalDistance = ((CourseGeometry)courseAndOptionalGeometry.getB()).getTotalDistance();
            result.put((Object)FIELD_TOTAL_DISTANCE_IN_METERS, totalDistance == null ? null : Double.valueOf(totalDistance.getMeters()));
        }
        return result;
    }

    public static class CourseGeometry {
        private final Distance totalDistance;
        private final Map<Leg, Distance> legDistances;
        private final Map<Leg, Bearing> legBearings;

        public CourseGeometry(Distance totalDistance, Map<Leg, Distance> legDistances, Map<Leg, Bearing> legBearings) {
            this.totalDistance = totalDistance;
            this.legDistances = legDistances;
            this.legBearings = legBearings;
        }

        public Distance getTotalDistance() {
            return this.totalDistance;
        }

        public Map<Leg, Distance> getLegDistances() {
            return this.legDistances;
        }

        public Map<Leg, Bearing> getLegBearings() {
            return this.legBearings;
        }
    }
}

