/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.coursedata.impl;

import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CourseBaseJsonSerializer
implements JsonSerializer<CourseBase> {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_WAYPOINTS = "waypoints";
    public static final String FIELD_ORIGINATING_COURSE_TEMPLATE_ID = "originatingCourseTemplateId";
    private final JsonSerializer<Waypoint> waypointSerializer;

    public CourseBaseJsonSerializer(JsonSerializer<Waypoint> waypointSerializer) {
        this.waypointSerializer = waypointSerializer;
    }

    public JSONObject serialize(CourseBase course) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_NAME, (Object)course.getName());
        if (course.getOriginatingCourseTemplateIdOrNull() != null) {
            result.put((Object)FIELD_ORIGINATING_COURSE_TEMPLATE_ID, (Object)course.getOriginatingCourseTemplateIdOrNull());
        }
        JSONArray waypoints = new JSONArray();
        for (Waypoint waypoint : course.getWaypoints()) {
            waypoints.add((Object)this.serializeWaypoint(waypoint));
        }
        result.put((Object)FIELD_WAYPOINTS, (Object)waypoints);
        return result;
    }

    protected JSONObject serializeWaypoint(Waypoint waypoint) {
        return this.waypointSerializer.serialize((Object)waypoint);
    }
}

