/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.racelog.impl;

import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.domain.common.orc.impl.ORCCertificateImpl;
import com.sap.sailing.server.gateway.serialization.racelog.impl.ORCCertificateJsonSerializer;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.CountryCode;
import com.sap.sse.common.CountryCodeFactory;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.SecondsDurationImpl;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ORCCertificateJsonDeserializer
implements JsonDeserializer<ORCCertificate> {
    public ORCCertificate deserialize(JSONObject json) throws JsonDeserializationException {
        String fileId = (String)json.get((Object)"fileId");
        CountryCode issuingCountry = CountryCodeFactory.INSTANCE.getFromThreeLetterIOCName((String)json.get((Object)"issuingCountryIOC"));
        String sailnumber = (String)json.get((Object)"sailNumber");
        String boatName = (String)json.get((Object)"boatName");
        String boatclass = (String)json.get((Object)"boatClass");
        Number lengthOverAll = (Number)json.get((Object)"length");
        MeterDistance length = lengthOverAll == null ? null : new MeterDistance(lengthOverAll.doubleValue());
        SecondsDurationImpl gph = new SecondsDurationImpl(((Number)json.get((Object)"gph")).doubleValue());
        Number cdlAsNumber = (Number)json.get((Object)"cdl");
        Double cdl = cdlAsNumber == null ? null : Double.valueOf(cdlAsNumber.doubleValue());
        MillisecondsTimePoint issueDate = new MillisecondsTimePoint(((Long)json.get((Object)"issueDate")).longValue());
        HashMap velocityPredictionsPerTrueWindSpeedAndAngle = new HashMap();
        HashMap<Speed, DegreeBearingImpl> beatAngles = new HashMap<Speed, DegreeBearingImpl>();
        HashMap<Speed, Speed> beatVMGPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
        HashMap<Speed, SecondsDurationImpl> beatAllowancePerTrueWindSpeed = new HashMap<Speed, SecondsDurationImpl>();
        HashMap<Speed, DegreeBearingImpl> runAngles = new HashMap<Speed, DegreeBearingImpl>();
        HashMap<Speed, Speed> runVMGPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
        HashMap<Speed, SecondsDurationImpl> runAllowancePerTrueWindSpeed = new HashMap<Speed, SecondsDurationImpl>();
        HashMap<Speed, Speed> windwardLeewardSpeedPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
        HashMap<Speed, Speed> longDistanceSpeedPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
        HashMap<Speed, Speed> circularRandomSpeedPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
        HashMap<Speed, Speed> nonSpinnakerSpeedPredictionPerTrueWindSpeed = new HashMap<Speed, Speed>();
        Speed[] trueWindSpeeds = this.convertJsonArrayOfDoublesToArrayOfObjectsOrReturnDefault(json.get((Object)"trueWindSpeedsInKnots"), ORCCertificate.ALLOWANCES_TRUE_WIND_SPEEDS, speedInKnots -> new KnotSpeedImpl(speedInKnots.doubleValue()), new Speed[0]);
        Bearing[] trueWindAngles = this.convertJsonArrayOfDoublesToArrayOfObjectsOrReturnDefault(json.get((Object)"trueWindAnglesInTrueDegrees"), ORCCertificate.ALLOWANCES_TRUE_WIND_ANGLES, twaInTrueDegrees -> new DegreeBearingImpl(twaInTrueDegrees.doubleValue()), new Bearing[0]);
        Speed[] speedArray = trueWindSpeeds;
        int n = trueWindSpeeds.length;
        int n2 = 0;
        while (n2 < n) {
            Speed tws = speedArray[n2];
            String twsKey = ORCCertificateJsonSerializer.speedToKnotsString(tws);
            beatAngles.put(tws, new DegreeBearingImpl(((Number)((JSONObject)json.get((Object)"beatAngles")).get((Object)twsKey)).doubleValue()));
            this.addKnotSpeedFromPropertyToMap(beatVMGPredictionPerTrueWindSpeed, tws, twsKey, "beatVmgPredictions", json);
            beatAllowancePerTrueWindSpeed.put(tws, new SecondsDurationImpl(((Number)((JSONObject)json.get((Object)"beatAllowances")).get((Object)twsKey)).doubleValue()));
            runAngles.put(tws, new DegreeBearingImpl(((Number)((JSONObject)json.get((Object)"runAngles")).get((Object)twsKey)).doubleValue()));
            this.addKnotSpeedFromPropertyToMap(runVMGPredictionPerTrueWindSpeed, tws, twsKey, "runVmgPredictions", json);
            runAllowancePerTrueWindSpeed.put(tws, new SecondsDurationImpl(((Number)((JSONObject)json.get((Object)"runAllowances")).get((Object)twsKey)).doubleValue()));
            this.addKnotSpeedFromPropertyToMap(windwardLeewardSpeedPredictionPerTrueWindSpeed, tws, twsKey, "windwardLeewardSpeedPredictions", json);
            this.addKnotSpeedFromPropertyToMap(longDistanceSpeedPredictionPerTrueWindSpeed, tws, twsKey, "longDistanceSpeedPredictions", json);
            this.addKnotSpeedFromPropertyToMap(circularRandomSpeedPredictionPerTrueWindSpeed, tws, twsKey, "circularRandomSpeedPredictions", json);
            this.addKnotSpeedFromPropertyToMap(nonSpinnakerSpeedPredictionPerTrueWindSpeed, tws, twsKey, "nonSpinnakerSpeedPredictions", json);
            HashMap<Bearing, KnotSpeedImpl> velocityPredictionAtCurrentTrueWindSpeedPerTrueWindAngle = new HashMap<Bearing, KnotSpeedImpl>();
            Bearing[] bearingArray = trueWindAngles;
            int n3 = trueWindAngles.length;
            int n4 = 0;
            while (n4 < n3) {
                Bearing twa = bearingArray[n4];
                String twaKey = ORCCertificateJsonSerializer.bearingToDegreeString(twa);
                velocityPredictionAtCurrentTrueWindSpeedPerTrueWindAngle.put(twa, new KnotSpeedImpl(((Number)((JSONObject)((JSONObject)json.get((Object)"twaSpeedPredictions")).get((Object)twsKey)).get((Object)twaKey)).doubleValue()));
                ++n4;
            }
            velocityPredictionsPerTrueWindSpeedAndAngle.put(tws, velocityPredictionAtCurrentTrueWindSpeedPerTrueWindAngle);
            ++n2;
        }
        String referenceNumber = json.get((Object)"ID").toString();
        ORCCertificateImpl certificate = new ORCCertificateImpl(trueWindSpeeds, trueWindAngles, referenceNumber, fileId, sailnumber, boatName, boatclass, (Distance)length, (Duration)gph, cdl, (TimePoint)issueDate, issuingCountry, velocityPredictionsPerTrueWindSpeedAndAngle, beatAngles, beatVMGPredictionPerTrueWindSpeed, beatAllowancePerTrueWindSpeed, runAngles, runVMGPredictionPerTrueWindSpeed, runAllowancePerTrueWindSpeed, windwardLeewardSpeedPredictionPerTrueWindSpeed, longDistanceSpeedPredictionPerTrueWindSpeed, circularRandomSpeedPredictionPerTrueWindSpeed, nonSpinnakerSpeedPredictionPerTrueWindSpeed);
        return certificate;
    }

    private void addKnotSpeedFromPropertyToMap(Map<Speed, Speed> speedPredictionMap, Speed tws, String twsKey, String jsonPropertyName, JSONObject jsonObject) {
        JSONObject speedPredictions = (JSONObject)jsonObject.get((Object)jsonPropertyName);
        Object speedPredictionObject = speedPredictions.get((Object)twsKey);
        Number value = speedPredictionObject instanceof Number ? (Number)((Number)speedPredictionObject) : (Number)(speedPredictionObject instanceof JSONObject ? Double.valueOf(Double.POSITIVE_INFINITY) : Double.valueOf(0.0));
        speedPredictionMap.put(tws, (Speed)new KnotSpeedImpl(value == null ? Double.POSITIVE_INFINITY : value.doubleValue()));
    }

    private <T> T[] convertJsonArrayOfDoublesToArrayOfObjectsOrReturnDefault(Object supposedJsonArray, T[] defaults, Function<Double, T> constructor, T[] array) {
        T[] result;
        JSONArray windAnglesJsonArray;
        if (supposedJsonArray == null || !(supposedJsonArray instanceof JSONArray) || (windAnglesJsonArray = (JSONArray)supposedJsonArray).isEmpty()) {
            result = defaults;
        } else {
            ArrayList<T> resultList = new ArrayList<T>();
            for (Object number : windAnglesJsonArray) {
                resultList.add(constructor.apply((Double)number));
            }
            T[] tArray = resultList.toArray(array);
            result = tArray;
        }
        return result;
    }
}

