/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.LeaderboardGroupBase;
import com.sap.sailing.domain.base.Venue;
import com.sap.sailing.domain.base.impl.StrippedEventImpl;
import com.sap.sailing.domain.tracking.TrackingConnectorInfo;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.media.ImageDescriptor;
import com.sap.sse.shared.media.VideoDescriptor;
import com.sap.sse.shared.media.impl.ImageDescriptorImpl;
import com.sap.sse.shared.media.impl.VideoDescriptorImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.UUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class EventBaseJsonDeserializer
implements JsonDeserializer<EventBase> {
    private final JsonDeserializer<Venue> venueDeserializer;
    private final JsonDeserializer<LeaderboardGroupBase> leaderboardGroupDeserializer;
    private final JsonDeserializer<TrackingConnectorInfo> trackingConnectorInfoDeserializer;

    public EventBaseJsonDeserializer(JsonDeserializer<Venue> venueDeserializer, JsonDeserializer<LeaderboardGroupBase> leaderboardGroupDeserializer, JsonDeserializer<TrackingConnectorInfo> trackingConnectorInfoDeserializer) {
        this.venueDeserializer = venueDeserializer;
        this.leaderboardGroupDeserializer = leaderboardGroupDeserializer;
        this.trackingConnectorInfoDeserializer = trackingConnectorInfoDeserializer;
    }

    public EventBase deserialize(JSONObject eventJson) throws JsonDeserializationException {
        JSONArray sailorsInfoWebsiteURLsJson;
        JSONArray videosJson;
        JSONArray imagesJson;
        Venue venue;
        UUID id = UUID.fromString((String)eventJson.get((Object)"id"));
        String name = (String)eventJson.get((Object)"name");
        String description = (String)eventJson.get((Object)"description");
        String officialWebsiteURLAsString = (String)eventJson.get((Object)"officialWebsiteURL");
        String baseURLAsString = (String)eventJson.get((Object)"baseURL");
        Number startDate = (Number)eventJson.get((Object)"startDate");
        Number endDate = (Number)eventJson.get((Object)"endDate");
        if (eventJson.get((Object)"venue") != null) {
            JSONObject venueObject = Helpers.getNestedObjectSafe(eventJson, "venue");
            venue = (Venue)this.venueDeserializer.deserialize(venueObject);
        } else {
            venue = null;
        }
        JSONArray leaderboardGroupsJson = (JSONArray)eventJson.get((Object)"leaderboardGroups");
        ArrayList<LeaderboardGroupBase> leaderboardGroups = new ArrayList<LeaderboardGroupBase>();
        if (leaderboardGroupsJson != null) {
            for (Object lgJson : leaderboardGroupsJson) {
                leaderboardGroups.add((LeaderboardGroupBase)this.leaderboardGroupDeserializer.deserialize((JSONObject)lgJson));
            }
        }
        HashSet<TrackingConnectorInfo> trackingConnectorInfos = new HashSet<TrackingConnectorInfo>();
        JSONArray trackingConnectorInfosJson = (JSONArray)eventJson.get((Object)"trackingConnectorInfos");
        if (trackingConnectorInfosJson != null) {
            for (Object jsonPair : trackingConnectorInfosJson) {
                trackingConnectorInfos.add((TrackingConnectorInfo)this.trackingConnectorInfoDeserializer.deserialize((JSONObject)jsonPair));
            }
        }
        StrippedEventImpl result = new StrippedEventImpl(name, (TimePoint)(startDate == null ? null : new MillisecondsTimePoint(startDate.longValue())), (TimePoint)(endDate == null ? null : new MillisecondsTimePoint(endDate.longValue())), venue, true, id, leaderboardGroups, trackingConnectorInfos);
        result.setDescription(description);
        if (officialWebsiteURLAsString != null) {
            try {
                result.setOfficialWebsiteURL(new URL(officialWebsiteURLAsString));
            }
            catch (MalformedURLException e) {
                throw new JsonDeserializationException("Error deserializing official website URL for event " + name, (Throwable)e);
            }
        }
        if (baseURLAsString != null) {
            try {
                result.setBaseURL(new URL(baseURLAsString));
            }
            catch (MalformedURLException e) {
                throw new JsonDeserializationException("Error deserializing base URL for event " + name, (Throwable)e);
            }
        }
        if ((imagesJson = (JSONArray)eventJson.get((Object)"images")) != null) {
            for (Object imageJson : imagesJson) {
                Iterator imgaeDescriptor = this.loadImage((JSONObject)imageJson);
                if (imgaeDescriptor == null) continue;
                result.addImage((ImageDescriptor)imgaeDescriptor);
            }
        }
        if ((videosJson = (JSONArray)eventJson.get((Object)"videos")) != null) {
            for (Object videoJson : videosJson) {
                VideoDescriptor videoDescriptor = this.loadVideo((JSONObject)videoJson);
                if (videoDescriptor == null) continue;
                result.addVideo(videoDescriptor);
            }
        }
        if ((sailorsInfoWebsiteURLsJson = (JSONArray)eventJson.get((Object)"sailorsInfoWebsiteURLs")) != null) {
            for (Object sailorsInfoWebsiteURLJson : sailorsInfoWebsiteURLsJson) {
                JSONObject sailorsInfoWebsiteURLJsonObject = (JSONObject)sailorsInfoWebsiteURLJson;
                String localeString = (String)sailorsInfoWebsiteURLJsonObject.get((Object)"locale");
                result.setSailorsInfoWebsiteURL(localeString == null ? null : new Locale(localeString), Helpers.getURLField(sailorsInfoWebsiteURLJsonObject, "url"));
            }
        }
        return result;
    }

    private ImageDescriptor loadImage(JSONObject imageJson) {
        ImageDescriptorImpl image = null;
        URL imageURL = Helpers.getURLField(imageJson, "sourceURL");
        if (imageURL != null) {
            String title = (String)imageJson.get((Object)"title");
            String subtitle = (String)imageJson.get((Object)"subtitle");
            String copyright = (String)imageJson.get((Object)"copyright");
            String localeRaw = (String)imageJson.get((Object)"locale");
            Locale locale = localeRaw != null ? new Locale(localeRaw) : null;
            Number imageWidth = (Number)imageJson.get((Object)"widthInPixel");
            Number imageHeight = (Number)imageJson.get((Object)"heightInPixel");
            Number createdAtDateInMs = (Number)imageJson.get((Object)"createdAtDate");
            MillisecondsTimePoint createdAtDate = createdAtDateInMs != null ? new MillisecondsTimePoint(createdAtDateInMs.longValue()) : null;
            JSONArray tags = (JSONArray)imageJson.get((Object)"tags");
            ArrayList<String> imageTags = new ArrayList<String>();
            if (tags != null) {
                for (Object tagObject : tags) {
                    imageTags.add((String)tagObject);
                }
            }
            image = new ImageDescriptorImpl(imageURL, (TimePoint)createdAtDate);
            image.setCopyright(copyright);
            image.setLocale(locale);
            image.setTitle(title);
            image.setSubtitle(subtitle);
            image.setTags(imageTags);
            if (imageWidth != null && imageHeight != null) {
                image.setSize(Integer.valueOf(imageWidth.intValue()), Integer.valueOf(imageHeight.intValue()));
            }
        }
        return image;
    }

    private VideoDescriptor loadVideo(JSONObject videoJson) {
        VideoDescriptorImpl video = null;
        URL videoURL = Helpers.getURLField(videoJson, "sourceURL");
        if (videoURL != null) {
            String title = (String)videoJson.get((Object)"title");
            String subtitle = (String)videoJson.get((Object)"subtitle");
            String copyright = (String)videoJson.get((Object)"copyright");
            String localeRaw = (String)videoJson.get((Object)"locale");
            Locale locale = localeRaw != null ? new Locale(localeRaw) : null;
            Object mimeTypeRaw = videoJson.get((Object)"mimetype");
            MimeType mimeType = mimeTypeRaw == null ? null : MimeType.valueOf((String)((String)mimeTypeRaw));
            Number createdAtDateInMs = (Number)videoJson.get((Object)"createdAtDate");
            MillisecondsTimePoint createdAtDate = createdAtDateInMs != null ? new MillisecondsTimePoint(createdAtDateInMs.longValue()) : null;
            JSONArray tags = (JSONArray)videoJson.get((Object)"tags");
            Integer lengthInSeconds = (Integer)videoJson.get((Object)"lengthInSeconds");
            URL thumbnailURL = Helpers.getURLField(videoJson, "thumbnailURL");
            ArrayList<String> videoTags = new ArrayList<String>();
            if (tags != null) {
                for (Object tagObject : tags) {
                    videoTags.add((String)tagObject);
                }
            }
            video = new VideoDescriptorImpl(videoURL, mimeType, (TimePoint)createdAtDate);
            video.setCopyright(copyright);
            video.setLocale(locale);
            video.setTitle(title);
            video.setSubtitle(subtitle);
            video.setTags(videoTags);
            video.setLengthInSeconds(lengthInSeconds);
            video.setThumbnailURL(thumbnailURL);
        }
        return video;
    }
}

