/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.base.BoatFactory;
import com.sap.sailing.domain.base.CompetitorFactory;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.server.gateway.deserialization.impl.BoatClassJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.BoatJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.server.gateway.deserialization.impl.NationalityJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.PersonJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.TeamJsonDeserializer;
import com.sap.sse.common.Color;
import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.RGBColor;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.util.impl.UUIDHelper;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.UUID;
import java.util.logging.Logger;
import org.json.simple.JSONObject;

public class CompetitorJsonDeserializer
implements JsonDeserializer<DynamicCompetitor> {
    private final CompetitorFactory competitorWithBoatFactory;
    private final JsonDeserializer<DynamicTeam> teamJsonDeserializer;
    private final BoatJsonDeserializer boatJsonDeserializer;
    private final boolean storeDeserializedCompetitorsPersistently;
    private static final Logger logger = Logger.getLogger(CompetitorJsonDeserializer.class.getName());

    public static CompetitorJsonDeserializer create(SharedDomainFactory<?> baseDomainFactory) {
        return new CompetitorJsonDeserializer((CompetitorFactory)baseDomainFactory, new TeamJsonDeserializer(new PersonJsonDeserializer(new NationalityJsonDeserializer(baseDomainFactory))), new BoatJsonDeserializer((BoatFactory)baseDomainFactory, new BoatClassJsonDeserializer(baseDomainFactory)));
    }

    public CompetitorJsonDeserializer(CompetitorFactory competitorWithBoatFactory) {
        this(competitorWithBoatFactory, null, null);
    }

    public CompetitorJsonDeserializer(CompetitorFactory competitorWithBoatFactory, boolean storeDeserializedCompetitorsPersistently) {
        this(competitorWithBoatFactory, null, null, storeDeserializedCompetitorsPersistently);
    }

    public CompetitorJsonDeserializer(CompetitorFactory competitorWithBoatFactory, JsonDeserializer<DynamicTeam> teamJsonDeserializer, BoatJsonDeserializer boatDeserializer) {
        this(competitorWithBoatFactory, teamJsonDeserializer, boatDeserializer, true);
    }

    public CompetitorJsonDeserializer(CompetitorFactory competitorWithBoatFactory, JsonDeserializer<DynamicTeam> teamJsonDeserializer, BoatJsonDeserializer boatDeserializer, boolean storeDeserializedCompetitorsPersistently) {
        this.competitorWithBoatFactory = competitorWithBoatFactory;
        this.teamJsonDeserializer = teamJsonDeserializer;
        this.boatJsonDeserializer = boatDeserializer;
        this.storeDeserializedCompetitorsPersistently = storeDeserializedCompetitorsPersistently;
    }

    public DynamicCompetitor deserialize(JSONObject object) throws JsonDeserializationException {
        Serializable competitorId = (Serializable)object.get((Object)"id");
        try {
            Class<?> idClass = Class.forName((String)object.get((Object)"idtype"));
            if (Number.class.isAssignableFrom(idClass)) {
                Constructor<?> constructorFromString = idClass.getConstructor(String.class);
                competitorId = (Serializable)constructorFromString.newInstance(competitorId.toString());
            } else if (UUID.class.isAssignableFrom(idClass)) {
                competitorId = UUIDHelper.tryUuidConversion((Serializable)competitorId);
            }
            String name = (String)object.get((Object)"name");
            String shortName = (String)object.get((Object)"shortName");
            String displayColorAsString = (String)object.get((Object)"displayColor");
            String email = (String)object.get((Object)"email");
            String searchTag = (String)object.get((Object)"searchTag");
            URI flagImageURI = null;
            String flagImageURIAsString = (String)object.get((Object)"flagImageUri");
            if (flagImageURIAsString != null) {
                try {
                    flagImageURI = URI.create(flagImageURIAsString);
                }
                catch (IllegalArgumentException e) {
                    logger.warning("Illegal flag image URI " + e.getMessage());
                }
            }
            RGBColor displayColor = displayColorAsString == null || displayColorAsString.isEmpty() ? null : new RGBColor(displayColorAsString);
            DynamicTeam team = null;
            if (this.teamJsonDeserializer != null && object.get((Object)"team") != null) {
                team = (DynamicTeam)this.teamJsonDeserializer.deserialize(Helpers.getNestedObjectSafe(object, "team"));
            }
            DynamicBoat boat = this.getBoat(object, competitorId);
            Number timeOnTimeFactorAsNumber = (Number)object.get((Object)"timeOnTimeFactor");
            Double timeOnTimeFactor = timeOnTimeFactorAsNumber != null ? timeOnTimeFactorAsNumber.doubleValue() : 0.0;
            Number timeOnDistanceAllowanceInSecondsPerNauticalMileAsNumber = (Number)object.get((Object)"timeOnDistanceAllowanceInSecondsPerNauticalMile");
            Double timeOnDistanceAllowanceInSecondsPerNauticalMile = timeOnDistanceAllowanceInSecondsPerNauticalMileAsNumber != null ? timeOnDistanceAllowanceInSecondsPerNauticalMileAsNumber.doubleValue() : 0.0;
            Object result = boat == null ? this.competitorWithBoatFactory.getOrCreateCompetitor(competitorId, name, shortName, (Color)displayColor, email, flagImageURI, team, timeOnTimeFactor, (Duration)(timeOnDistanceAllowanceInSecondsPerNauticalMile == null ? null : new MillisecondsDurationImpl((long)(timeOnDistanceAllowanceInSecondsPerNauticalMile * 1000.0))), searchTag, this.storeDeserializedCompetitorsPersistently) : this.competitorWithBoatFactory.getOrCreateCompetitorWithBoat(competitorId, name, shortName, (Color)displayColor, email, flagImageURI, team, timeOnTimeFactor, (Duration)(timeOnDistanceAllowanceInSecondsPerNauticalMile == null ? null : new MillisecondsDurationImpl((long)(timeOnDistanceAllowanceInSecondsPerNauticalMile * 1000.0))), searchTag, boat, this.storeDeserializedCompetitorsPersistently);
            return result;
        }
        catch (Exception e) {
            throw new JsonDeserializationException((Throwable)e);
        }
    }

    protected DynamicBoat getBoat(JSONObject object, Serializable defaultId) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, JsonDeserializationException {
        DynamicBoat boat = this.boatJsonDeserializer != null && object.get((Object)"boat") != null ? this.boatJsonDeserializer.deserialize(Helpers.getNestedObjectSafe(object, "boat"), defaultId) : null;
        return boat;
    }
}

