/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.news.impl;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.news.EventNewsItem;
import com.sap.sailing.news.EventNewsProvider;
import com.sap.sailing.news.EventNewsProviderRegistry;
import com.sap.sailing.news.EventNewsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class EventNewsServiceImpl
implements EventNewsService {
    private static final int LIMIT = 25;
    private final EventNewsProviderRegistry providerRegistry;

    public EventNewsServiceImpl(EventNewsProviderRegistry providerRegistry) {
        this.providerRegistry = providerRegistry;
    }

    @Override
    public List<EventNewsItem> getNews(Event event) {
        ArrayList<? extends EventNewsItem> result = new ArrayList<EventNewsItem>();
        for (EventNewsProvider provider : this.providerRegistry.getEventNewsProvider()) {
            Collection<? extends EventNewsItem> news = provider.getNews(event);
            result.addAll(news);
        }
        Collections.sort(result);
        return result.subList(0, Math.min(25, result.size()));
    }
}

