/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.kmeans;

import com.sap.sse.common.scalablevalue.ComparableScalableValueWithDistance;
import com.sap.sse.common.scalablevalue.ScalableValue;
import com.sap.sse.common.scalablevalue.ScalableValueWithDistance;
import com.sap.sse.util.kmeans.KMeansClusterer;
import java.util.ArrayList;
import java.util.Iterator;

public class KMeansClustererWithEquidistantInitialization<ValueType, AveragesTo extends Comparable<AveragesTo>, T extends ComparableScalableValueWithDistance<ValueType, AveragesTo>>
extends KMeansClusterer<ValueType, AveragesTo, T> {
    public KMeansClustererWithEquidistantInitialization(int numberOfClusters, Iterable<T> elements) {
        super(numberOfClusters, elements, KMeansClustererWithEquidistantInitialization.getEquiDistantSeeds(numberOfClusters, elements));
    }

    private static <ValueType, AveragesTo extends Comparable<AveragesTo>, T extends ComparableScalableValueWithDistance<ValueType, AveragesTo>> Iterator<AveragesTo> getEquiDistantSeeds(int numberOfClusters, Iterable<T> elements) {
        Comparable min = null;
        ComparableScalableValueWithDistance minElement = null;
        Comparable max = null;
        ComparableScalableValueWithDistance maxElement = null;
        for (ComparableScalableValueWithDistance t : elements) {
            Comparable tVal = (Comparable)t.divide(1.0);
            if (min == null || min.compareTo(tVal) > 0) {
                minElement = t;
                min = tVal;
            }
            if (max != null && max.compareTo(tVal) >= 0) continue;
            maxElement = t;
            max = tVal;
        }
        ScalableValueWithDistance step = maxElement.add((ScalableValue)minElement.multiply(-1.0)).multiply(1.0 / (double)(numberOfClusters - 1));
        ArrayList<Comparable> seeds = new ArrayList<Comparable>();
        ComparableScalableValueWithDistance a = minElement;
        int i = 0;
        while (i < numberOfClusters) {
            seeds.add((Comparable)a.divide(1.0));
            a = a.add((ScalableValue)step);
            ++i;
        }
        return seeds.iterator();
    }
}

