/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.kmeans;

import com.sap.sse.common.scalablevalue.ScalableValue;
import com.sap.sse.common.scalablevalue.ScalableValueWithDistance;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class Cluster<E, ValueType, AveragesTo, T extends ScalableValueWithDistance<ValueType, AveragesTo>>
implements Iterable<E> {
    private final Set<E> elements;
    private final Function<E, T> mapper;
    private final AveragesTo mean;
    private ScalableValueWithDistance<ValueType, AveragesTo> sum;

    public Cluster(AveragesTo mean, Function<E, T> mapper) {
        this.mapper = mapper;
        this.elements = new HashSet();
        this.mean = mean;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }

    public void add(E e) {
        this.elements.add(e);
        ScalableValueWithDistance t = (ScalableValueWithDistance)this.mapper.apply(e);
        this.sum = this.sum == null ? t : this.sum.add((ScalableValue)t);
    }

    public double getDistanceFromMean(E e) {
        return ((ScalableValueWithDistance)this.mapper.apply(e)).getDistance(this.mean);
    }

    public AveragesTo getCentroid() {
        return (AveragesTo)(this.sum == null ? null : this.sum.divide((double)this.elements.size()));
    }

    public AveragesTo getMean() {
        return this.mean;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.elements.spliterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.elements.forEach(action);
    }

    public String toString() {
        return "{mean: " + this.getMean() + ", centroid: " + this.getCentroid() + ", size: " + this.size() + ", variance: " + this.getVariance() + "}";
    }

    private double getVariance() {
        return this.stream().mapToDouble(e -> this.getDistanceFromMean(e) * this.getDistanceFromMean(e)).average().getAsDouble();
    }

    public Stream<E> stream() {
        return this.elements.stream();
    }
}

