/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util;

import com.sap.sse.common.Base64Utils;
import com.sap.sse.common.media.MediaTagConstants;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public class ImageConverter {
    private static final Logger logger = Logger.getLogger(ImageConverter.class.getName());

    private InputStream imageToInputStream(BufferedImage image, String imageFormat) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, imageFormat, bos);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        byte[] arr = bos.toByteArray();
        return new ByteArrayInputStream(arr);
    }

    public BufferedImage resize(BufferedImage image, int minWidth, int maxWidth, int minHeight, int maxHeight) {
        int[] dimensions = this.calculateDimensions(image.getWidth(), image.getHeight(), minWidth, maxWidth, minHeight, maxHeight);
        BufferedImage resizedImage = dimensions != null ? this.resize(image, dimensions[0], dimensions[1]) : null;
        return resizedImage;
    }

    public int[] calculateDimensions(double width, double height, double minWidth, double maxWidth, double minHeight, double maxHeight) {
        int[] dimensions = new int[2];
        if (maxWidth >= 0.0 && maxHeight >= 0.0 && maxHeight > minHeight && maxWidth > minWidth && width > minWidth && height > minHeight) {
            if (maxWidth <= width || maxHeight <= height) {
                if (width / maxWidth > height / maxHeight) {
                    dimensions[1] = (int)maxWidth;
                    dimensions[1] = (int)(height / width * maxWidth);
                    if ((double)dimensions[1] >= minHeight) {
                        dimensions[0] = (int)maxWidth;
                    } else {
                        dimensions = null;
                    }
                } else {
                    dimensions[0] = (int)(width / height * maxHeight);
                    if ((double)dimensions[0] >= minWidth) {
                        dimensions[1] = (int)maxHeight;
                    } else {
                        dimensions = null;
                    }
                }
            } else {
                dimensions[0] = (int)width;
                dimensions[1] = (int)height;
            }
        } else {
            dimensions = null;
        }
        return dimensions;
    }

    private BufferedImage resize(BufferedImage image, int demandedWidth, int demandedHeight) {
        BufferedImage resizedImage = new BufferedImage(demandedWidth, demandedHeight, image.getType());
        Graphics2D g = resizedImage.createGraphics();
        AffineTransform transform = new AffineTransform();
        transform.scale((double)demandedWidth / (double)image.getWidth(), (double)demandedHeight / (double)image.getHeight());
        AffineTransformOp op = new AffineTransformOp(transform, 2);
        g.drawImage(image, op, 0, 0);
        g.dispose();
        return resizedImage;
    }

    public InputStream imageWithMetadataToInputStream(BufferedImage bufferdImage, IIOMetadata metadata, String imageFormat) throws IOException {
        byte[] bytes = null;
        if (metadata != null) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (ImageOutputStream ios = ImageIO.createImageOutputStream(new ByteArrayOutputStream());){
                    Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix(imageFormat);
                    while (writers.hasNext() && bytes == null) {
                        ImageWriter writer = writers.next();
                        if (writer == null) continue;
                        writer.setOutput(ios);
                        IIOImage iioImage = new IIOImage(bufferdImage, null, metadata);
                        ImageWriteParam param = writer.getDefaultWriteParam();
                        IIOMetadata streamMetadata = writer.getDefaultStreamMetadata(param);
                        writer.write(streamMetadata, iioImage, param);
                        writer.dispose();
                        bytes = new byte[Math.toIntExact(ios.length())];
                        ios.read(bytes);
                        if (!this.isZeroByteArray(bytes)) continue;
                        bytes = null;
                    }
                    if (bytes == null) {
                        throw new Exception("Saving file via FileWriter did not work, not able to write file with metadata, retrying with ImageIO.write()");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                bytes = null;
                logger.log(Level.INFO, e.getMessage());
            }
        }
        InputStream toReturn = bytes == null ? this.imageToInputStream(bufferdImage, imageFormat) : new ByteArrayInputStream(bytes);
        return toReturn;
    }

    public byte[] inputStreamToByteArray(InputStream inputStream) {
        byte[] byteArray = null;
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byteArray = buffer.toByteArray();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        return byteArray;
    }

    private boolean isZeroByteArray(byte[] bytes) {
        boolean toReturn = true;
        if (bytes != null) {
            int i = 0;
            while (toReturn && i < bytes.length) {
                if (bytes[i] != 0) {
                    toReturn = false;
                }
                ++i;
            }
        }
        return toReturn;
    }

    public String convertToBase64(InputStream inputStream, String imageFormat) throws IOException {
        return this.convertToBase64(this.bufferedImageToByteArray(this.loadBufferedImageFromInputStream(inputStream), imageFormat));
    }

    public String convertToBase64(BufferedImage image, String imageFormat) throws IOException {
        return this.convertToBase64(this.bufferedImageToByteArray(image, imageFormat));
    }

    private String convertToBase64(byte[] bytes) {
        return Base64Utils.toBase64((byte[])bytes);
    }

    private BufferedImage loadBufferedImageFromInputStream(InputStream inputStream) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(inputStream);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        return image;
    }

    public byte[] bufferedImageToByteArray(BufferedImage image, String imageFormat) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, imageFormat, baos);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        return baos.toByteArray();
    }

    public List<BufferedImage> convertImage(BufferedImage image, List<MediaTagConstants> resizingTasks) {
        ArrayList<BufferedImage> resizedImages = new ArrayList<BufferedImage>();
        for (MediaTagConstants tag : resizingTasks) {
            resizedImages.add(this.resize(image, tag.getMinWidth(), tag.getMaxWidth(), tag.getMinHeight(), tag.getMaxHeight()));
        }
        return resizedImages;
    }

    public ImageWithMetadata loadImage(InputStream inputStream, String imageFormat) {
        ImageConverter converter = new ImageConverter();
        BufferedImage image = null;
        IIOMetadata metadata = null;
        boolean loaded = false;
        byte[] bytes = converter.inputStreamToByteArray(inputStream);
        try {
            Iterator<ImageReader> readerIterator = ImageIO.getImageReadersBySuffix(imageFormat);
            while (readerIterator.hasNext() && !loaded) {
                ImageReader reader = readerIterator.next();
                reader.setInput(ImageIO.createImageInputStream(new ByteArrayInputStream(bytes)));
                metadata = reader.getImageMetadata(0);
                image = reader.read(0);
                boolean bl = loaded = metadata != null;
            }
            if (!loaded) {
                throw new Exception("Loading file via ImageReader did not work, not able to load metadata, retrying to load with ImageIO.read()");
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, e.getMessage());
        }
        if (!loaded) {
            image = converter.loadBufferedImageFromInputStream(new ByteArrayInputStream(bytes));
            metadata = null;
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Potential ressource leak");
        }
        return new ImageWithMetadata(image, metadata);
    }

    public class ImageWithMetadata {
        private final BufferedImage image;
        private final IIOMetadata metadata;

        public ImageWithMetadata(BufferedImage image, IIOMetadata metadata) {
            this.image = image;
            this.metadata = metadata;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public IIOMetadata getMetadata() {
            return this.metadata;
        }
    }
}

