/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util;

import com.sap.sse.common.Util;
import com.sap.sse.util.ParseHttpParameterException;
import javax.servlet.http.HttpServletRequest;

public abstract class HttpRequestUtils {
    private static final IntParser INT_PARSER = new IntParser();
    private static final LongParser LONG_PARSER = new LongParser();
    private static final FloatParser FLOAT_PARSER = new FloatParser();
    private static final DoubleParser DOUBLE_PARSER = new DoubleParser();
    private static final BooleanParser BOOLEAN_PARSER = new BooleanParser();
    private static final StringParser STRING_PARSER = new StringParser();
    private static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private static final String USER_AGENT_HEADER = "User-Agent";

    public static String getClientIP(HttpServletRequest req) {
        String result;
        String xForwardedFor = req.getHeader(X_FORWARDED_FOR_HEADER);
        if (Util.hasLength((String)xForwardedFor)) {
            String[] ips = xForwardedFor.split(", *");
            result = ips[ips.length - 1];
        } else {
            result = req.getRemoteAddr();
        }
        return result;
    }

    public static String getUserAgent(HttpServletRequest req) {
        return req.getHeader(USER_AGENT_HEADER);
    }

    public static Integer getIntParameter(HttpServletRequest req, String name) throws ParseHttpParameterException {
        Integer result = req.getParameter(name) == null ? null : Integer.valueOf(HttpRequestUtils.getRequiredIntParameter(req, name));
        return result;
    }

    public static int getIntParameter(HttpServletRequest req, String name, int defaultValue) {
        if (req.getParameter(name) == null) {
            return defaultValue;
        }
        try {
            return HttpRequestUtils.getRequiredIntParameter(req, name);
        }
        catch (ParseHttpParameterException ex) {
            return defaultValue;
        }
    }

    public static int[] getIntParameters(HttpServletRequest req, String name) {
        try {
            return HttpRequestUtils.getRequiredIntParameters(req, name);
        }
        catch (ParseHttpParameterException ex) {
            return new int[0];
        }
    }

    public static int getRequiredIntParameter(HttpServletRequest req, String name) throws ParseHttpParameterException {
        return INT_PARSER.parseInt(name, req.getParameter(name));
    }

    public static int[] getRequiredIntParameters(HttpServletRequest req, String name) throws ParseHttpParameterException {
        return INT_PARSER.parseInts(name, req.getParameterValues(name));
    }

    public static Long getLongParameter(HttpServletRequest req, String name) throws ParseHttpParameterException {
        Long result = req.getParameter(name) == null ? null : Long.valueOf(HttpRequestUtils.getRequiredLongParameter(req, name));
        return result;
    }

    public static long getLongParameter(HttpServletRequest req, String name, long defaultValue) {
        long result;
        if (req.getParameter(name) == null) {
            result = defaultValue;
        } else {
            try {
                result = HttpRequestUtils.getRequiredLongParameter(req, name);
            }
            catch (ParseHttpParameterException ex) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static long[] getLongParameters(HttpServletRequest req, String name) {
        long[] result;
        try {
            result = HttpRequestUtils.getRequiredLongParameters(req, name);
        }
        catch (ParseHttpParameterException ex) {
            result = new long[]{};
        }
        return result;
    }

    public static long getRequiredLongParameter(HttpServletRequest req, String name) throws ParseHttpParameterException {
        return LONG_PARSER.parseLong(name, req.getParameter(name));
    }

    public static long[] getRequiredLongParameters(HttpServletRequest req, String name) throws ParseHttpParameterException {
        return LONG_PARSER.parseLongs(name, req.getParameterValues(name));
    }

    public static Float getFloatParameter(HttpServletRequest req, String name) throws ParseHttpParameterException {
        Float result = req.getParameter(name) == null ? null : Float.valueOf(HttpRequestUtils.getRequiredFloatParameter(req, name));
        return result;
    }

    public static float getFloatParameter(HttpServletRequest req, String name, float defaultValue) {
        if (req.getParameter(name) == null) {
            return defaultValue;
        }
        try {
            return HttpRequestUtils.getRequiredFloatParameter(req, name);
        }
        catch (ParseHttpParameterException ex) {
            return defaultValue;
        }
    }

    public static float[] getFloatParameters(HttpServletRequest req, String name) {
        try {
            return HttpRequestUtils.getRequiredFloatParameters(req, name);
        }
        catch (ParseHttpParameterException ex) {
            return new float[0];
        }
    }

    public static float getRequiredFloatParameter(HttpServletRequest req, String name) throws ParseHttpParameterException {
        return FLOAT_PARSER.parseFloat(name, req.getParameter(name));
    }

    public static float[] getRequiredFloatParameters(HttpServletRequest req, String name) throws ParseHttpParameterException {
        return FLOAT_PARSER.parseFloats(name, req.getParameterValues(name));
    }

    public static Double getDoubleParameter(HttpServletRequest req, String name) throws ParseHttpParameterException {
        Double result = req.getParameter(name) == null ? null : Double.valueOf(HttpRequestUtils.getRequiredDoubleParameter(req, name));
        return result;
    }

    public static double getDoubleParameter(HttpServletRequest req, String name, double defaultValue) {
        double result;
        if (req.getParameter(name) == null) {
            result = defaultValue;
        } else {
            try {
                result = HttpRequestUtils.getRequiredDoubleParameter(req, name);
            }
            catch (ParseHttpParameterException ex) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static double[] getDoubleParameters(HttpServletRequest req, String name) {
        try {
            return HttpRequestUtils.getRequiredDoubleParameters(req, name);
        }
        catch (ParseHttpParameterException ex) {
            return new double[0];
        }
    }

    public static double getRequiredDoubleParameter(HttpServletRequest req, String name) throws ParseHttpParameterException {
        return DOUBLE_PARSER.parseDouble(name, req.getParameter(name));
    }

    public static double[] getRequiredDoubleParameters(HttpServletRequest req, String name) throws ParseHttpParameterException {
        return DOUBLE_PARSER.parseDoubles(name, req.getParameterValues(name));
    }

    public static Boolean getBooleanParameter(HttpServletRequest req, String name) throws ParseHttpParameterException {
        Boolean result = req.getParameter(name) == null ? null : (HttpRequestUtils.getRequiredBooleanParameter(req, name) ? Boolean.TRUE : Boolean.FALSE);
        return result;
    }

    public static boolean getBooleanParameter(HttpServletRequest req, String name, boolean defaultValue) {
        boolean result;
        if (req.getParameter(name) == null) {
            result = defaultValue;
        } else {
            try {
                result = HttpRequestUtils.getRequiredBooleanParameter(req, name);
            }
            catch (ParseHttpParameterException ex) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static boolean[] getBooleanParameters(HttpServletRequest req, String name) {
        try {
            return HttpRequestUtils.getRequiredBooleanParameters(req, name);
        }
        catch (ParseHttpParameterException ex) {
            return new boolean[0];
        }
    }

    public static boolean getRequiredBooleanParameter(HttpServletRequest req, String name) throws ParseHttpParameterException {
        return BOOLEAN_PARSER.parseBoolean(name, req.getParameter(name));
    }

    public static boolean[] getRequiredBooleanParameters(HttpServletRequest req, String name) throws ParseHttpParameterException {
        return BOOLEAN_PARSER.parseBooleans(name, req.getParameterValues(name));
    }

    public static String getStringParameter(HttpServletRequest req, String name) throws ParseHttpParameterException {
        String result = req.getParameter(name) == null ? null : HttpRequestUtils.getRequiredStringParameter(req, name);
        return result;
    }

    public static String getStringParameter(HttpServletRequest req, String name, String defaultValue) {
        String val = req.getParameter(name);
        return val != null ? val : defaultValue;
    }

    public static String[] getStringParameters(HttpServletRequest req, String name) {
        String[] result;
        try {
            result = HttpRequestUtils.getRequiredStringParameters(req, name);
        }
        catch (ParseHttpParameterException ex) {
            result = new String[]{};
        }
        return result;
    }

    public static String getRequiredStringParameter(HttpServletRequest req, String name) throws ParseHttpParameterException {
        return STRING_PARSER.validateRequiredString(name, req.getParameter(name));
    }

    public static String[] getRequiredStringParameters(HttpServletRequest req, String name) throws ParseHttpParameterException {
        return STRING_PARSER.validateRequiredStrings(name, req.getParameterValues(name));
    }

    private static class BooleanParser
    extends ParameterParser {
        private BooleanParser() {
        }

        @Override
        protected String getType() {
            return "boolean";
        }

        @Override
        protected Object doParse(String parameter) throws NumberFormatException {
            return parameter.equalsIgnoreCase("true") || parameter.equalsIgnoreCase("on") || parameter.equalsIgnoreCase("yes") || parameter.equals("1") ? Boolean.TRUE : Boolean.FALSE;
        }

        public boolean parseBoolean(String name, String parameter) throws ParseHttpParameterException {
            return (Boolean)this.parse(name, parameter);
        }

        public boolean[] parseBooleans(String name, String[] values) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, values);
            boolean[] parameters = new boolean[values.length];
            int i = 0;
            while (i < values.length) {
                parameters[i] = this.parseBoolean(name, values[i]);
                ++i;
            }
            return parameters;
        }
    }

    private static class DoubleParser
    extends ParameterParser {
        private DoubleParser() {
        }

        @Override
        protected String getType() {
            return "double";
        }

        @Override
        protected Object doParse(String parameter) throws NumberFormatException {
            return Double.valueOf(parameter);
        }

        public double parseDouble(String name, String parameter) throws ParseHttpParameterException {
            return ((Number)this.parse(name, parameter)).doubleValue();
        }

        public double[] parseDoubles(String name, String[] values) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, values);
            double[] parameters = new double[values.length];
            int i = 0;
            while (i < values.length) {
                parameters[i] = this.parseDouble(name, values[i]);
                ++i;
            }
            return parameters;
        }
    }

    private static class FloatParser
    extends ParameterParser {
        private FloatParser() {
        }

        @Override
        protected String getType() {
            return "float";
        }

        @Override
        protected Object doParse(String parameter) throws NumberFormatException {
            return Float.valueOf(parameter);
        }

        public float parseFloat(String name, String parameter) throws ParseHttpParameterException {
            return ((Number)this.parse(name, parameter)).floatValue();
        }

        public float[] parseFloats(String name, String[] values) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, values);
            float[] parameters = new float[values.length];
            int i = 0;
            while (i < values.length) {
                parameters[i] = this.parseFloat(name, values[i]);
                ++i;
            }
            return parameters;
        }
    }

    private static class IntParser
    extends ParameterParser {
        private IntParser() {
        }

        @Override
        protected String getType() {
            return "int";
        }

        @Override
        protected Object doParse(String s) throws NumberFormatException {
            return Integer.valueOf(s);
        }

        public int parseInt(String name, String parameter) throws ParseHttpParameterException {
            return ((Number)this.parse(name, parameter)).intValue();
        }

        public int[] parseInts(String name, String[] values) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, values);
            int[] parameters = new int[values.length];
            int i = 0;
            while (i < values.length) {
                parameters[i] = this.parseInt(name, values[i]);
                ++i;
            }
            return parameters;
        }
    }

    private static class LongParser
    extends ParameterParser {
        private LongParser() {
        }

        @Override
        protected String getType() {
            return "long";
        }

        @Override
        protected Object doParse(String parameter) throws NumberFormatException {
            return Long.valueOf(parameter);
        }

        public long parseLong(String name, String parameter) throws ParseHttpParameterException {
            return ((Number)this.parse(name, parameter)).longValue();
        }

        public long[] parseLongs(String name, String[] values) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, values);
            long[] parameters = new long[values.length];
            int i = 0;
            while (i < values.length) {
                parameters[i] = this.parseLong(name, values[i]);
                ++i;
            }
            return parameters;
        }
    }

    private static abstract class ParameterParser {
        private ParameterParser() {
        }

        protected final Object parse(String name, String parameter) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, parameter);
            try {
                return this.doParse(parameter);
            }
            catch (NumberFormatException ex) {
                throw new ParseHttpParameterException(name, "Required " + this.getType() + " parameter '" + name + "' with value of '" + parameter + "' is not a valid number.", ex);
            }
        }

        protected final void validateRequiredParameter(String name, Object parameter) throws ParseHttpParameterException {
            if (parameter == null) {
                throw new ParseHttpParameterException(name, "Required " + this.getType() + " parameter '" + name + "' is null.");
            }
        }

        protected abstract String getType();

        protected abstract Object doParse(String var1) throws NumberFormatException;
    }

    private static class StringParser
    extends ParameterParser {
        private StringParser() {
        }

        @Override
        protected String getType() {
            return "string";
        }

        @Override
        protected Object doParse(String parameter) throws NumberFormatException {
            return parameter;
        }

        public String validateRequiredString(String name, String value) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, value);
            return value;
        }

        public String[] validateRequiredStrings(String name, String[] values) throws ParseHttpParameterException {
            this.validateRequiredParameter(name, values);
            String[] parameters = new String[values.length];
            int i = 0;
            while (i < values.length) {
                parameters[i] = this.validateRequiredString(name, values[i]);
                ++i;
            }
            return parameters;
        }
    }
}

