/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util;

import com.sap.sse.common.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class CSVParser {
    private final String separator;

    public CSVParser() {
        this(",");
    }

    public CSVParser(String separator) {
        this.separator = separator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> parseLine(String line) {
        assert (line.indexOf("\n") < 0);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        boolean atStartOfToken = true;
        boolean inQuotedToken = false;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (atStartOfToken && c == '\"') {
                inQuotedToken = true;
                atStartOfToken = false;
            } else if (inQuotedToken) {
                if (c == '\"') {
                    if (i == line.length() - 1) {
                        inQuotedToken = false;
                        atStartOfToken = true;
                        result.add(token.toString());
                    } else if (line.substring(i + 1).startsWith(this.separator)) {
                        inQuotedToken = false;
                    } else {
                        if (line.charAt(i + 1) != '\"') throw new IllegalArgumentException("Non-doubled quote found in quoted string");
                        token.append(line.charAt(++i));
                    }
                } else {
                    token.append(c);
                }
            } else if (line.substring(i).startsWith(this.separator)) {
                atStartOfToken = true;
                result.add(token.toString());
                token.delete(0, token.length());
                i += this.separator.length() - 1;
            } else {
                token.append(c);
                atStartOfToken = false;
                if (i == line.length() - 1) {
                    result.add(token.toString());
                }
            }
            ++i;
        }
        return result;
    }

    public Iterable<List<String>> parseWithoutHeader(BufferedReader reader) throws IOException {
        String contentLine;
        ArrayList<List<String>> content = new ArrayList<List<String>>();
        while ((contentLine = reader.readLine()) != null) {
            content.add(this.parseLine(contentLine));
        }
        return content;
    }

    public Util.Pair<List<String>, Iterable<List<String>>> parseWithHeader(Reader reader) throws IOException {
        BufferedReader br = new BufferedReader(reader);
        List<String> header = this.parseLine(br.readLine());
        Iterable<List<String>> content = this.parseWithoutHeader(br);
        return new Util.Pair(header, content);
    }
}

