/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.pairinglist.impl;

import com.sap.sse.common.PairingListCreationException;
import com.sap.sse.common.Util;
import com.sap.sse.pairinglist.CompetitionFormat;
import com.sap.sse.pairinglist.PairingList;
import com.sap.sse.pairinglist.PairingListTemplate;
import java.util.ArrayList;
import java.util.List;

public class PairingListImpl<Flight, Group, Competitor, CompetitorAllocation>
implements PairingList<Flight, Group, Competitor, CompetitorAllocation> {
    private final PairingListTemplate pairingListTemplate;
    private final CompetitionFormat<Flight, Group, Competitor, CompetitorAllocation> competitionFormat;
    private final List<Competitor> competitors;

    public PairingListImpl(PairingListTemplate template, CompetitionFormat<Flight, Group, Competitor, CompetitorAllocation> competitionFormat) throws PairingListCreationException {
        int numberOfCompetitorAllocations = Util.size(competitionFormat.getCompetitorAllocation());
        if (numberOfCompetitorAllocations < competitionFormat.getMaxNumberOfCompetitorAllocationsNeeded()) {
            throw new PairingListCreationException("Too few competitor allocations (" + numberOfCompetitorAllocations + "). " + competitionFormat.getMaxNumberOfCompetitorAllocationsNeeded() + " are needed.");
        }
        this.pairingListTemplate = template;
        this.competitionFormat = competitionFormat;
        this.competitors = Util.asList(competitionFormat.getCompetitors());
    }

    @Override
    public Iterable<Util.Pair<Competitor, CompetitorAllocation>> getCompetitors(Flight flight, Group group) throws PairingListCreationException {
        if (this.competitors.isEmpty()) {
            throw new PairingListCreationException();
        }
        int[][] competitorIndices = this.pairingListTemplate.getPairingListTemplate();
        int flightIndex = Util.indexOf(this.competitionFormat.getFlights(), flight);
        int groupIndex = Util.indexOf(this.competitionFormat.getGroups(flight), group);
        int groupCount = Util.size(this.competitionFormat.getGroups(flight));
        ArrayList<Integer> competitorIndicesInRace = new ArrayList<Integer>();
        int[] nArray = competitorIndices[flightIndex * groupCount + groupIndex];
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer integer = nArray[n2];
            competitorIndicesInRace.add(integer);
            ++n2;
        }
        ArrayList<Util.Pair<Competitor, CompetitorAllocation>> result = new ArrayList<Util.Pair<Competitor, CompetitorAllocation>>();
        int slot = 0;
        while (slot < competitorIndicesInRace.size()) {
            Integer index = (Integer)competitorIndicesInRace.get(slot);
            Object competitor = index >= 0 && this.competitors.size() > index ? this.competitors.get(index) : null;
            Object allocation = Util.size(this.competitionFormat.getCompetitorAllocation()) > slot ? Util.get(this.competitionFormat.getCompetitorAllocation(), (int)slot) : null;
            result.add(new Util.Pair(competitor, allocation));
            ++slot;
        }
        return result;
    }
}

