/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.hanaexport.jaxrs.api;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.hanaexport.jaxrs.api.AbstractPreparedInsertStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class InsertRegattaStatement
extends AbstractPreparedInsertStatement<RegattaAndEvent> {
    protected InsertRegattaStatement(Connection connection) throws SQLException {
        super(connection.prepareStatement("INSERT INTO SAILING.\"Regatta\" (\"name\", \"boatClass\", \"scoringScheme\", \"rankingMetric\", \"eventId\") VALUES (?, ?, ?, ?, ?);"));
    }

    @Override
    public void parameterizeStatement(RegattaAndEvent regattaAndEvent) throws SQLException {
        Regatta regatta = regattaAndEvent.getRegatta();
        Event event = regattaAndEvent.getEvent();
        this.getPreparedStatement().setString(1, regatta.getName());
        this.getPreparedStatement().setString(2, regatta.getBoatClass().getName());
        this.getPreparedStatement().setString(3, regatta.getScoringScheme().getType().name());
        this.getPreparedStatement().setString(4, regatta.getRankingMetricType().name());
        this.getPreparedStatement().setString(5, event == null ? null : event.getId().toString());
    }

    static class RegattaAndEvent {
        private final Regatta regatta;
        private final Event event;

        public RegattaAndEvent(Regatta regatta, Event event) {
            this.regatta = regatta;
            this.event = event;
        }

        public Regatta getRegatta() {
            return this.regatta;
        }

        public Event getEvent() {
            return this.event;
        }
    }
}

