/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.hanaexport.jaxrs.api;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.hanaexport.jaxrs.api.AbstractPreparedInsertStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;

public class InsertEventStatement
extends AbstractPreparedInsertStatement<Event> {
    protected InsertEventStatement(Connection connection) throws SQLException {
        super(connection.prepareStatement("INSERT INTO SAILING.\"Event\" (\"id\", \"name\", \"startDate\", \"endDate\", \"venue\", \"isListed\", \"description\", \"location\") VALUES (?, ?, ?, ?, ?, ?, ?, new ST_GEOMETRY('POINT('|| ? || ' ' || ? ||')', 4326).ST_Transform(3857));"));
    }

    @Override
    public void parameterizeStatement(Event event) throws SQLException {
        this.getPreparedStatement().setString(1, event.getId().toString());
        this.getPreparedStatement().setString(2, event.getName());
        this.getPreparedStatement().setDate(3, event.getStartDate() == null ? null : new Date(event.getStartDate().asMillis()));
        this.getPreparedStatement().setDate(4, event.getEndDate() == null ? null : new Date(event.getEndDate().asMillis()));
        this.getPreparedStatement().setString(5, event.getVenue().getName());
        this.getPreparedStatement().setBoolean(6, event.isPublic());
        this.getPreparedStatement().setString(7, event.getDescription());
        Position location = event.getLocation();
        this.getPreparedStatement().setString(8, location != null ? String.format("%1.8f", location.getLngDeg()) : null);
        this.getPreparedStatement().setString(9, location != null ? String.format("%1.8f", location.getLatDeg()) : null);
    }
}

