/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.shared.util.impl.ArrayListNavigableSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableSet;

public class TimeRangeCache<T> {
    public static final int MAX_SIZE = 100;
    private final NavigableSet<Util.Pair<TimePoint, NavigableSet<Util.Pair<TimePoint, T>>>> timeRangeCache;
    private final LinkedHashMap<Util.Pair<TimePoint, TimePoint>, Void> lruCache;
    private final NamedReentrantReadWriteLock lock;
    private static final Comparator<Util.Pair<TimePoint, ?>> timePointInPairComparator = new Comparator<Util.Pair<TimePoint, ?>>(){

        @Override
        public int compare(Util.Pair<TimePoint, ?> o1, Util.Pair<TimePoint, ?> o2) {
            return ((TimePoint)o1.getA()).compareTo((Object)((TimePoint)o2.getA()));
        }
    };

    public TimeRangeCache(String nameForLockLogging) {
        this.lock = new NamedReentrantReadWriteLock("lock for TimeRangeCache for " + nameForLockLogging, true);
        this.timeRangeCache = new ArrayListNavigableSet(timePointInPairComparator);
        this.lruCache = new LinkedHashMap<Util.Pair<TimePoint, TimePoint>, Void>(10, 0.75f, true){
            private static final long serialVersionUID = -6568235517111733193L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Util.Pair<TimePoint, TimePoint>, Void> eldest) {
                boolean expunge;
                boolean bl = expunge = this.size() > 100;
                if (expunge) {
                    TimeRangeCache.this.removeCacheEntry((TimePoint)eldest.getKey().getA(), (TimePoint)eldest.getKey().getB());
                }
                return expunge;
            }
        };
    }

    public int size() {
        return this.lruCache.size();
    }

    private void removeCacheEntry(TimePoint from, TimePoint to) {
        Util.Pair entryForFrom;
        assert (this.lock.getWriteHoldCount() == 1);
        Util.Pair<TimePoint, NavigableSet<Util.Pair<TimePoint, T>>> entryForTo = this.timeRangeCache.floor(this.createDummy(to));
        if (((TimePoint)entryForTo.getA()).equals(to) && ((TimePoint)(entryForFrom = ((NavigableSet)entryForTo.getB()).ceiling(new Util.Pair((Object)from, null))).getA()).equals(from)) {
            ((NavigableSet)entryForTo.getB()).remove(entryForFrom);
            if (((NavigableSet)entryForTo.getB()).isEmpty()) {
                this.timeRangeCache.remove(entryForTo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Util.Pair<TimePoint, Util.Pair<TimePoint, T>> getEarliestFromAndResultAtOrAfterFrom(TimePoint from, TimePoint to) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            Util.Pair fromCeiling;
            Util.Pair result = null;
            Util.Pair<TimePoint, NavigableSet<Util.Pair<TimePoint, T>>> entryForTo = this.timeRangeCache.floor(this.createDummy(to));
            if (entryForTo != null && (fromCeiling = ((NavigableSet)entryForTo.getB()).ceiling(new Util.Pair((Object)from, null))) != null) {
                result = new Util.Pair((Object)((TimePoint)entryForTo.getA()), (Object)fromCeiling);
            }
            LinkedHashMap<Util.Pair<TimePoint, TimePoint>, Void> linkedHashMap = this.lruCache;
            synchronized (linkedHashMap) {
                this.lruCache.get(new Util.Pair((Object)from, (Object)to));
            }
            Util.Pair pair = result;
            return pair;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    public void invalidateAllAtOrLaterThan(TimePoint timePoint) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            Util.Pair<TimePoint, NavigableSet<Util.Pair<TimePoint, T>>> dummy = this.createDummy(timePoint);
            NavigableSet<Util.Pair<TimePoint, NavigableSet<Util.Pair<TimePoint, T>>>> toRemove = this.timeRangeCache.tailSet(dummy, true);
            Iterator<Util.Pair<TimePoint, NavigableSet<Util.Pair<TimePoint, T>>>> i = toRemove.iterator();
            while (i.hasNext()) {
                Util.Pair<TimePoint, NavigableSet<Util.Pair<TimePoint, T>>> entryToRemove = i.next();
                assert (((TimePoint)entryToRemove.getA()).compareTo((Object)timePoint) >= 0);
                for (Util.Pair fromAndResult : (NavigableSet)entryToRemove.getB()) {
                    this.lruCache.remove(new Util.Pair((Object)((TimePoint)fromAndResult.getA()), (Object)((TimePoint)entryToRemove.getA())));
                }
                i.remove();
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    private NavigableSet<Util.Pair<TimePoint, T>> getEntryForTo(TimePoint to) {
        NavigableSet result = null;
        Util.Pair<TimePoint, NavigableSet<Util.Pair<TimePoint, T>>> dummyForTo = this.createDummy(to);
        Util.Pair<TimePoint, NavigableSet<Util.Pair<TimePoint, T>>> entryForTo = this.timeRangeCache.floor(dummyForTo);
        if (entryForTo != null && ((TimePoint)entryForTo.getA()).equals(to)) {
            result = (NavigableSet)entryForTo.getB();
        }
        return result;
    }

    public void cache(TimePoint from, TimePoint to, T result) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            ArrayListNavigableSet entryForTo = this.getEntryForTo(to);
            if (entryForTo == null) {
                entryForTo = new ArrayListNavigableSet(timePointInPairComparator);
                Util.Pair pairForTo = new Util.Pair((Object)to, (Object)entryForTo);
                this.timeRangeCache.add(pairForTo);
            }
            entryForTo.add(new Util.Pair((Object)from, result));
            this.lruCache.put((Util.Pair<TimePoint, TimePoint>)new Util.Pair((Object)from, (Object)to), null);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    private Util.Pair<TimePoint, NavigableSet<Util.Pair<TimePoint, T>>> createDummy(TimePoint to) {
        return new Util.Pair((Object)to, null);
    }

    public void clear() {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            this.timeRangeCache.clear();
            this.lruCache.clear();
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }
}

