/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.domain.common.Position;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;

public interface LineDetails {
    public TimePoint getTimePoint();

    public Waypoint getWaypoint();

    public Distance getLength();

    public Bearing getAngleDifferenceFromPortToStarboardWhenApproachingLineToTrueWind();

    public NauticalSide getAdvantageousSideWhileApproachingLine();

    public Mark getStarboardMarkWhileApproachingLine();

    public Mark getPortMarkWhileApproachingLine();

    public Distance getAdvantage();

    public Position getPortMarkPosition();

    public Position getStarboardMarkPosition();

    default public Mark getAdvantageousMark() {
        return this.getAdvantageousSideWhileApproachingLine() == NauticalSide.PORT ? this.getPortMarkWhileApproachingLine() : this.getStarboardMarkWhileApproachingLine();
    }

    default public Position getAdvantageousMarkPosition() {
        return this.getAdvantageousSideWhileApproachingLine() == NauticalSide.PORT ? this.getPortMarkPosition() : this.getStarboardMarkPosition();
    }

    default public Bearing getBearingFromStarboardToPortWhenApproachingLine() {
        return this.getStarboardMarkPosition().getBearingGreatCircle(this.getPortMarkPosition());
    }

    default public Bearing getBearingFromPortToStarboardWhenApproachingLine() {
        return this.getPortMarkPosition().getBearingGreatCircle(this.getStarboardMarkPosition());
    }
}

