/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.racegroup;

import com.sap.sailing.domain.base.SeriesBase;
import com.sap.sailing.domain.base.racegroup.FilterableRace;
import com.sap.sailing.domain.base.racegroup.RaceGroup;
import com.sap.sse.common.Util;

public class RaceGroupSeries {
    private final RaceGroup raceGroup;
    private final SeriesBase series;
    private final int seriesOrder;

    public RaceGroupSeries(FilterableRace race) {
        this(race.getRaceGroup(), race.getSeries());
    }

    public RaceGroupSeries(RaceGroup raceGroup, SeriesBase series) {
        this.raceGroup = raceGroup;
        this.series = series;
        this.seriesOrder = RaceGroupSeries.getSeriesIndex(raceGroup, series);
    }

    private static int getSeriesIndex(RaceGroup raceGroup, SeriesBase series) {
        return Util.indexOf(raceGroup.getSeries(), (Object)series);
    }

    public RaceGroup getRaceGroup() {
        return this.raceGroup;
    }

    public SeriesBase getSeries() {
        return this.series;
    }

    public String getRaceGroupName() {
        return this.raceGroup.getName();
    }

    public String getSeriesName() {
        return this.series.getName();
    }

    public String getDisplayName() {
        return this.getDisplayName(false);
    }

    public String getDisplayName(boolean useDisplayName) {
        String name = this.raceGroup.getDisplayName();
        if (!useDisplayName || name == null || name.length() == 0) {
            name = this.raceGroup.getName();
        }
        if (this.series != null && !this.series.getName().equals("Default")) {
            name = String.valueOf(name) + " - " + this.series.getName();
        }
        return name;
    }

    public int getSeriesOrder() {
        return this.seriesOrder;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.raceGroup == null ? 0 : this.raceGroup.hashCode());
        result = 31 * result + (this.series == null ? 0 : this.series.hashCode());
        result = 31 * result + this.seriesOrder;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RaceGroupSeries other = (RaceGroupSeries)obj;
        if (this.raceGroup == null ? other.raceGroup != null : !this.raceGroup.equals(other.raceGroup)) {
            return false;
        }
        if (this.series == null ? other.series != null : !this.series.equals(other.series)) {
            return false;
        }
        return this.seriesOrder == other.seriesOrder;
    }
}

