/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.anniversary;

import com.sap.sailing.domain.anniversary.SimpleRaceInfo;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.EventType;
import com.sap.sse.common.TimePoint;
import java.net.URL;
import java.util.UUID;

public class DetailedRaceInfo
extends SimpleRaceInfo {
    private static final long serialVersionUID = 1L;
    private final String eventName;
    private final String leaderboardDisplayName;
    private final String leaderboardName;
    private final EventType eventType;

    public DetailedRaceInfo(RegattaAndRaceIdentifier identifier, String leaderboardName, String leaderboardDisplayName, TimePoint timePoint, UUID eventId, String eventName, EventType eventType, URL remoteUrl) {
        super(identifier, timePoint, remoteUrl, eventId);
        if (leaderboardName == null || eventId == null) {
            throw new IllegalStateException("DetailedRaceInfo Data is not allowed to contain any null values!");
        }
        this.leaderboardName = leaderboardName;
        this.leaderboardDisplayName = leaderboardDisplayName;
        this.eventName = eventName;
        this.eventType = eventType;
    }

    public DetailedRaceInfo(DetailedRaceInfo copy, URL remoteUrl) {
        this(copy.getIdentifier(), copy.getLeaderboardName(), copy.getLeaderboardDisplayName(), copy.getStartOfRace(), copy.getEventID(), copy.getEventName(), copy.getEventType(), remoteUrl);
    }

    public String getLeaderboardDisplayName() {
        return this.leaderboardDisplayName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getLeaderboardName() {
        return this.leaderboardName;
    }

    public String toString() {
        return "DetailedRaceInfo [identifier=" + this.getIdentifier() + ", leaderboardName=" + this.leaderboardName + ", startOfRace=" + this.getStartOfRace() + ", eventID=" + this.eventID + "]";
    }

    public EventType getEventType() {
        return this.eventType;
    }
}

