/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.state.racingprocedure;

import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.ReadonlyRacingProcedure;
import com.sap.sailing.domain.common.racelog.FlagPole;
import com.sap.sse.common.TimePoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FlagPoleState {
    private final List<FlagPole> currentState;
    private final List<FlagPole> nextState;
    private final TimePoint currentStateValidFrom;
    private final TimePoint nextStateValidFrom;
    private final boolean hasNextState;

    public FlagPoleState(List<FlagPole> currentState, TimePoint currentStateValidFrom) {
        this(currentState, currentStateValidFrom, null, null, false);
    }

    public FlagPoleState(List<FlagPole> currentState, TimePoint currentStateValidFrom, List<FlagPole> nextState, TimePoint nextStateValidFrom) {
        this(currentState, currentStateValidFrom, nextState, nextStateValidFrom, true);
    }

    private FlagPoleState(List<FlagPole> currentState, TimePoint currentStateValidFrom, List<FlagPole> nextState, TimePoint nextStateValidFrom, boolean hasNextState) {
        this.currentState = currentState;
        this.currentStateValidFrom = currentStateValidFrom;
        this.nextState = nextState;
        this.nextStateValidFrom = nextStateValidFrom;
        this.hasNextState = hasNextState;
    }

    public List<FlagPole> getCurrentState() {
        return this.currentState;
    }

    public List<FlagPole> getNextState() {
        return this.nextState;
    }

    public TimePoint getNextStateValidFrom() {
        return this.nextStateValidFrom;
    }

    public TimePoint getCurrentStateValidFrom() {
        return this.currentStateValidFrom;
    }

    public boolean hasNextState() {
        return this.hasNextState;
    }

    public static List<FlagPole> computeChanges(List<FlagPole> before, List<FlagPole> after) {
        before = before == null ? Collections.emptyList() : before;
        after = after == null ? Collections.emptyList() : after;
        ArrayList<FlagPole> beforeWithoutMatchInAfter = new ArrayList<FlagPole>(before);
        ArrayList<FlagPole> changes = new ArrayList<FlagPole>();
        for (FlagPole flagPole : after) {
            boolean hasSamePoleBefore = false;
            for (FlagPole flagPole2 : before) {
                if (flagPole.describesSameButForDisplayed(flagPole2)) {
                    beforeWithoutMatchInAfter.remove(flagPole2);
                }
                if (!flagPole.describesSame(flagPole2)) continue;
                hasSamePoleBefore = true;
                break;
            }
            if (hasSamePoleBefore) continue;
            changes.add(flagPole);
        }
        for (FlagPole flagPole : beforeWithoutMatchInAfter) {
            if (!flagPole.isDisplayed()) continue;
            changes.add(new FlagPole(flagPole.getUpperFlag(), flagPole.getLowerFlag(), false));
        }
        return changes;
    }

    public List<FlagPole> computeUpcomingChanges() {
        if (!this.hasNextState) {
            return Collections.emptyList();
        }
        return FlagPoleState.computeChanges(this.currentState, this.nextState);
    }

    public static boolean describesSameState(FlagPoleState left, FlagPoleState right) {
        if (left.hasNextState() != right.hasNextState()) {
            return false;
        }
        if (left.getCurrentState().size() != right.getCurrentState().size()) {
            return false;
        }
        if (FlagPoleState.describesSamePoles(left.getCurrentState(), right.getCurrentState())) {
            if (left.hasNextState()) {
                return left.getNextStateValidFrom().compareTo((Object)right.getNextStateValidFrom()) == 0 && FlagPoleState.describesSamePoles(left.getNextState(), right.getNextState());
            }
            return true;
        }
        return false;
    }

    private static boolean describesSamePoles(List<FlagPole> leftPoles, List<FlagPole> rightPoles) {
        int i = 0;
        while (i < leftPoles.size()) {
            FlagPole rightPole;
            FlagPole leftPole = leftPoles.get(i);
            if (!leftPole.describesSame(rightPole = rightPoles.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public FlagPoleState getPreviousState(ReadonlyRacingProcedure racingProcedure, TimePoint startTime) {
        if (this.currentStateValidFrom == null) {
            return this;
        }
        return racingProcedure.getActiveFlags(startTime, this.currentStateValidFrom.minus(1L));
    }

    public static FlagPole getMostInterestingFlagPole(List<FlagPole> poles) {
        return FlagPoleState.getMostInterestingFlagPole(poles, poles);
    }

    public static FlagPole getMostInterestingFlagPole(List<FlagPole> previousPoles, List<FlagPole> currentPoles) {
        List<FlagPole> changes = FlagPoleState.computeChanges(previousPoles, currentPoles);
        FlagPole poleRemoved = null;
        for (FlagPole changedPole : changes) {
            if (changedPole.isDisplayed()) {
                return changedPole;
            }
            poleRemoved = changedPole;
        }
        if (poleRemoved != null) {
            return poleRemoved;
        }
        for (FlagPole currentPole : currentPoles) {
            if (!currentPole.isDisplayed()) continue;
            return currentPole;
        }
        return currentPoles.size() == 0 ? null : currentPoles.get(0);
    }

    public boolean hasPoleChanged(FlagPole newPole) {
        boolean found = false;
        for (FlagPole current : this.currentState) {
            if (!current.describesSameButForDisplayed(newPole)) continue;
            found = true;
            if (current.isDisplayed() == newPole.isDisplayed()) continue;
            return true;
        }
        return !found && newPole.isDisplayed();
    }
}

