/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.analyzing.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFlagEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogAnalyzer;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class LastFlagsFinder
extends RaceLogAnalyzer<List<RaceLogFlagEvent>> {
    public LastFlagsFinder(RaceLog raceLog) {
        super(raceLog);
    }

    @Override
    protected List<RaceLogFlagEvent> performAnalysis() {
        Iterator<RaceLogEvent> iterator = this.getPassEventsDescending().iterator();
        RaceLogFlagEvent flagEvent = this.getNextFlagEvent(iterator);
        if (flagEvent != null) {
            return this.collectAllWithSameTimePoint(iterator, flagEvent);
        }
        return null;
    }

    private List<RaceLogFlagEvent> collectAllWithSameTimePoint(Iterator<RaceLogEvent> iterator, RaceLogFlagEvent flagEvent) {
        ArrayList<RaceLogFlagEvent> result = new ArrayList<RaceLogFlagEvent>();
        TimePoint logicalTime = flagEvent.getLogicalTimePoint();
        while (Util.compareToWithNull((Comparable)flagEvent.getLogicalTimePoint(), (Comparable)logicalTime, (boolean)false) == 0) {
            result.add(flagEvent);
            flagEvent = this.getNextFlagEvent(iterator);
            if (flagEvent == null) break;
        }
        return result;
    }

    private RaceLogFlagEvent getNextFlagEvent(Iterator<RaceLogEvent> iterator) {
        while (iterator.hasNext()) {
            RaceLogEvent event = iterator.next();
            if (!(event instanceof RaceLogFlagEvent)) continue;
            return (RaceLogFlagEvent)event;
        }
        return null;
    }

    public static RaceLogFlagEvent getMostRecent(List<RaceLogFlagEvent> events) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        ArrayList<RaceLogFlagEvent> sortedEvents = new ArrayList<RaceLogFlagEvent>(events);
        Collections.sort(sortedEvents, new Comparator<RaceLogFlagEvent>(){

            @Override
            public int compare(RaceLogFlagEvent left, RaceLogFlagEvent right) {
                int result = Util.compareToWithNull((Comparable)right.getLogicalTimePoint(), (Comparable)left.getLogicalTimePoint(), (boolean)false);
                if (result == 0 && (result = Boolean.compare(right.isDisplayed(), left.isDisplayed())) == 0) {
                    result = right.getId().toString().compareTo(left.getId().toString());
                }
                return result;
            }
        });
        return (RaceLogFlagEvent)sortedEvents.get(0);
    }
}

