/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.LogAnalyzer;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiLogAnalyzer<InterimResultT, FinalResultT>
implements LogAnalyzer<FinalResultT> {
    private final List<AbstractLog<?, ?>> logs;
    private final AnalyzerFactory<InterimResultT> analyzerFactory;
    private final ResultReducer<InterimResultT, FinalResultT> resultReducer;

    public MultiLogAnalyzer(AnalyzerFactory<InterimResultT> analyzerFactory, ResultReducer<InterimResultT, FinalResultT> resultReducer, AbstractLog<?, ?> ... logs) {
        this(analyzerFactory, resultReducer, Arrays.asList(logs));
    }

    public MultiLogAnalyzer(AnalyzerFactory<InterimResultT> analyzerFactory, ResultReducer<InterimResultT, FinalResultT> resultReducer, List<AbstractLog<?, ?>> logs) {
        this.logs = new ArrayList(logs);
        this.analyzerFactory = analyzerFactory;
        this.resultReducer = resultReducer;
    }

    @Override
    public FinalResultT analyze() {
        FinalResultT finalResult = this.resultReducer.getInitialFinalResultValue();
        for (AbstractLog<?, ?> log : this.logs) {
            if (log == null) continue;
            InterimResultT interimResult = this.analyzerFactory.createAnalyzer(log).analyze();
            finalResult = this.resultReducer.reduce(interimResult, finalResult);
        }
        return finalResult;
    }

    public static interface AnalyzerFactory<InterimResultT> {
        public LogAnalyzer<InterimResultT> createAnalyzer(AbstractLog<?, ?> var1);
    }

    public static abstract class CollectionReducer<T, C extends Collection<T>>
    implements ResultReducer<Collection<T>, C> {
        @Override
        public C reduce(Collection<T> interimResult, C reducedFinalResult) {
            Util.addAll(interimResult, reducedFinalResult);
            return reducedFinalResult;
        }
    }

    public static class ListReducer<T>
    extends CollectionReducer<T, List<T>> {
        @Override
        public List<T> getInitialFinalResultValue() {
            return new ArrayList();
        }
    }

    public static class MapWithValueCollectionReducer<K, V, C extends Collection<V>>
    implements ResultReducer<Map<K, C>, Map<K, C>> {
        @Override
        public Map<K, C> getInitialFinalResultValue() {
            return new HashMap();
        }

        @Override
        public Map<K, C> reduce(Map<K, C> interimResult, Map<K, C> reducedFinalResult) {
            for (Map.Entry<K, C> e : interimResult.entrySet()) {
                if (reducedFinalResult.containsKey(e.getKey())) {
                    ((Collection)reducedFinalResult.get(e.getKey())).addAll((Collection)e.getValue());
                    continue;
                }
                reducedFinalResult.put(e.getKey(), (Collection)e.getValue());
            }
            return reducedFinalResult;
        }
    }

    public static interface ResultReducer<InterimResultT, FinalResultT> {
        public FinalResultT getInitialFinalResultValue();

        public FinalResultT reduce(InterimResultT var1, FinalResultT var2);
    }

    public static class SetReducer<T>
    extends CollectionReducer<T, Set<T>> {
        @Override
        public Set<T> getInitialFinalResultValue() {
            return new HashSet();
        }
    }
}

