/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.LogAnalyzer;

public abstract class BaseLogAnalyzer<LogT extends AbstractLog<EventT, VisitorT>, EventT extends AbstractLogEvent<VisitorT>, VisitorT, ResultT>
implements LogAnalyzer<ResultT> {
    protected final LogT log;

    public BaseLogAnalyzer(LogT log) {
        this.log = log;
    }

    public LogT getLog() {
        return this.log;
    }

    @Override
    public ResultT analyze() {
        this.log.lockForRead();
        try {
            ResultT ResultT = this.performAnalysis();
            return ResultT;
        }
        finally {
            this.log.unlockAfterRead();
        }
    }

    protected abstract ResultT performAnalysis();

    protected Iterable<EventT> getAllEvents() {
        return this.log.getRawFixes();
    }

    protected Iterable<EventT> getAllEventsDescending() {
        return this.log.getRawFixesDescending();
    }
}

