/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.server.gateway.serialization.impl.AbstractTrackedRaceDataJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.MongoDbFriendlyPositionJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.WindJsonSerializer;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class RaceWindJsonSerializer
extends AbstractTrackedRaceDataJsonSerializer {
    public static final String WIND_SOURCES = "windSources";
    public static final String TYPE = "type";
    public static final String FIRST_POSITION = "firstPosition";
    public static final String START_TIME_POINT = "startUnixTime";
    public static final String END_TIME_POINT = "endUnixTime";
    public static final String SAMPLING_RATE = "samplingRate";
    public static final String FIXES = "fixes";
    private final MongoDbFriendlyPositionJsonSerializer positionSerializer = new MongoDbFriendlyPositionJsonSerializer();
    private final WindJsonSerializer windSerializer = new WindJsonSerializer((JsonSerializer)this.positionSerializer);

    public JSONObject serialize(TrackedRace trackedRace) {
        TimePoint finalFrom = trackedRace.getStartOfRace();
        TimePoint finalTo = Util.getEarliestOfTimePoints((TimePoint)trackedRace.getEndOfTracking(), (TimePoint)trackedRace.getEndOfRace());
        Set windSourcesToExclude = trackedRace.getWindSourcesToExclude();
        List highQualityWindSources = trackedRace.getWindSources().stream().filter(windSource -> windSource.getType() == WindSourceType.EXPEDITION && !windSourcesToExclude.contains(windSource)).collect(Collectors.toList());
        JSONArray windSourcesJson = new JSONArray();
        TimePoint earliestTimePoint = null;
        TimePoint latestTimePoint = null;
        Position firstPosition = null;
        double bestSamplingRate = Double.MAX_VALUE;
        for (WindSource windSource2 : highQualityWindSources) {
            WindTrack windTrack = trackedRace.getOrCreateWindTrack(windSource2);
            windTrack.lockForRead();
            try {
                Wind fix;
                Iterator iterator = windTrack.getFixes(finalFrom, true, finalTo, true).iterator();
                if (!iterator.hasNext() || (fix = (Wind)iterator.next()).getPosition() == null) continue;
                JSONArray windFixesJson = new JSONArray();
                TimePoint firstWindSourceTimePoint = fix.getTimePoint();
                TimePoint lastWindSourceTimePoint = null;
                Position firstWindSourcePosition = fix.getPosition();
                if (firstPosition == null) {
                    firstPosition = firstWindSourcePosition;
                }
                if (earliestTimePoint == null || earliestTimePoint.after(fix.getTimePoint())) {
                    earliestTimePoint = fix.getTimePoint();
                }
                do {
                    JSONObject windJson = this.windSerializer.serialize(fix);
                    windFixesJson.add((Object)windJson);
                    if (iterator.hasNext()) {
                        fix = (Wind)iterator.next();
                        continue;
                    }
                    lastWindSourceTimePoint = fix.getTimePoint();
                    if (latestTimePoint == null || latestTimePoint.before(fix.getTimePoint())) {
                        latestTimePoint = fix.getTimePoint();
                    }
                    fix = null;
                } while (fix != null);
                Duration duration = firstWindSourceTimePoint.until(lastWindSourceTimePoint);
                JSONObject windSourceJson = new JSONObject();
                windSourceJson.put((Object)TYPE, (Object)windSource2.getType().name());
                windSourceJson.put((Object)FIRST_POSITION, (Object)this.positionSerializer.serialize(firstWindSourcePosition));
                windSourceJson.put((Object)START_TIME_POINT, (Object)firstWindSourceTimePoint.asMillis());
                windSourceJson.put((Object)END_TIME_POINT, (Object)lastWindSourceTimePoint.asMillis());
                double samplingRate = duration.asSeconds() > 0.0 ? (double)windFixesJson.size() / duration.asSeconds() : 0.0;
                windSourceJson.put((Object)SAMPLING_RATE, (Object)samplingRate);
                windSourceJson.put((Object)FIXES, (Object)windFixesJson);
                windSourcesJson.add((Object)windSourceJson);
                if (!(bestSamplingRate > samplingRate)) continue;
                bestSamplingRate = samplingRate;
            }
            finally {
                windTrack.unlockAfterRead();
            }
        }
        JSONObject result = new JSONObject();
        if (!windSourcesJson.isEmpty()) {
            result.put((Object)FIRST_POSITION, (Object)this.positionSerializer.serialize(firstPosition));
            result.put((Object)START_TIME_POINT, (Object)earliestTimePoint.asMillis());
            result.put((Object)END_TIME_POINT, (Object)latestTimePoint.asMillis());
            result.put((Object)SAMPLING_RATE, (Object)bestSamplingRate);
            result.put((Object)WIND_SOURCES, (Object)windSourcesJson);
        }
        return result;
    }
}

