/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.server.gateway.serialization.impl.WindTrackJsonSerializer;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.util.RoundingUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class DefaultWindTrackJsonSerializer
implements WindTrackJsonSerializer {
    public static final String FIELD_ID = "id";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_PUBLICATION_URL = "publicationUrl";
    public static final String FIELD_VENUE = "venue";
    private final TimePoint fromTime;
    private final TimePoint toTime;
    private final WindSource windSource;
    private final int maxNumberOfFixes;

    public DefaultWindTrackJsonSerializer(int maxNumberOfFixes, TimePoint fromTime, TimePoint toTime, WindSource windSource) {
        this.maxNumberOfFixes = maxNumberOfFixes;
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.windSource = windSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject serialize(WindTrack windTrack) {
        JSONObject result = new JSONObject();
        JSONArray jsonWindFixes = new JSONArray();
        ArrayList<Wind> fixes = new ArrayList<Wind>();
        windTrack.lockForRead();
        try {
            Iterator windIter = windTrack.getFixesIterator(this.fromTime, true, this.toTime, false);
            int count = 0;
            while ((this.maxNumberOfFixes == -1 || count < this.maxNumberOfFixes) && windIter.hasNext()) {
                fixes.add((Wind)windIter.next());
            }
        }
        finally {
            windTrack.unlockAfterRead();
        }
        for (Wind wind : fixes) {
            JSONObject jsonWind = new JSONObject();
            jsonWind.put((Object)"trueBearing-deg", (Object)RoundingUtil.bearingDecimalFormatter.format(wind.getBearing().getDegrees()));
            jsonWind.put((Object)"speed-kts", (Object)RoundingUtil.speedDecimalFormatter.format(wind.getKnots()));
            jsonWind.put((Object)"speed-m/s", (Object)RoundingUtil.speedDecimalFormatter.format(wind.getMetersPerSecond()));
            if (wind.getTimePoint() != null) {
                jsonWind.put((Object)"timepoint-ms", (Object)wind.getTimePoint().asMillis());
                Wind averagedWind = windTrack.getAveragedWind(wind.getPosition(), wind.getTimePoint());
                jsonWind.put((Object)"dampenedTrueBearing-deg", (Object)RoundingUtil.bearingDecimalFormatter.format(averagedWind.getBearing().getDegrees()));
                jsonWind.put((Object)"dampenedSpeed-kts", (Object)RoundingUtil.speedDecimalFormatter.format(averagedWind.getKnots()));
                jsonWind.put((Object)"dampenedSpeed-m/s", (Object)RoundingUtil.speedDecimalFormatter.format(averagedWind.getMetersPerSecond()));
            }
            if (wind.getPosition() != null) {
                jsonWind.put((Object)"lat-deg", (Object)RoundingUtil.latLngDecimalFormatter.format(wind.getPosition().getLatDeg()));
                jsonWind.put((Object)"lng-deg", (Object)RoundingUtil.latLngDecimalFormatter.format(wind.getPosition().getLngDeg()));
            }
            jsonWindFixes.add((Object)jsonWind);
        }
        result.put((Object)(this.windSource.getType() + (this.windSource.getId() != null ? "-" + this.windSource.getId().toString() : "")), (Object)jsonWindFixes);
        return result;
    }
}

