/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.event;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import net.sf.marineapi.ais.message.AISMessage;
import net.sf.marineapi.ais.parser.AISMessageFactory;
import net.sf.marineapi.nmea.event.SentenceEvent;
import net.sf.marineapi.nmea.event.SentenceListener;
import net.sf.marineapi.nmea.sentence.AISSentence;
import net.sf.marineapi.nmea.sentence.Sentence;

public abstract class AbstractAISMessageListener<T extends AISMessage>
implements SentenceListener {
    private final Class<? extends AISMessage> expectedMessageType;
    private Queue<AISSentence> queue = new LinkedList<AISSentence>();
    private final AISMessageFactory factory = AISMessageFactory.getInstance();

    public AbstractAISMessageListener() {
        Class tClass;
        ParameterizedType superClass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] superClassTypeArgs = superClass.getActualTypeArguments();
        this.expectedMessageType = tClass = (Class)superClassTypeArgs[0];
    }

    @Override
    public void sentenceRead(SentenceEvent event) {
        Sentence s = event.getSentence();
        if (s.isAISSentence()) {
            this.handleAIS((AISSentence)s);
        }
    }

    private void handleAIS(AISSentence sentence) {
        if (sentence.isFirstFragment()) {
            this.queue.clear();
        }
        this.queue.add(sentence);
        if (sentence.isLastFragment()) {
            AISSentence[] sentences = this.queue.toArray(new AISSentence[this.queue.size()]);
            try {
                Class<?>[] interfaces;
                AISMessage message = this.factory.create(sentences);
                if (message != null && Arrays.asList(interfaces = message.getClass().getInterfaces()).contains(this.expectedMessageType)) {
                    AISMessage tMessage = message;
                    this.onMessage(tMessage);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public abstract void onMessage(T var1);

    @Override
    public void readingPaused() {
    }

    @Override
    public void readingStarted() {
    }

    @Override
    public void readingStopped() {
    }
}

