/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.declination.impl;

import com.sap.sailing.declination.Declination;
import com.sap.sailing.domain.common.Position;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;

public class DeclinationRecordImpl
implements Declination {
    private static final long serialVersionUID = 6918630656182340186L;
    private final Position position;
    private final TimePoint timePoint;
    private final Bearing bearing;
    private final Bearing annualChange;

    public DeclinationRecordImpl(Position position, TimePoint timePoint, Bearing bearing, Bearing annualChange) {
        this.position = position;
        this.timePoint = timePoint;
        this.bearing = bearing;
        this.annualChange = annualChange;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    public TimePoint getTimePoint() {
        return this.timePoint;
    }

    @Override
    public Bearing getBearing() {
        return this.bearing;
    }

    @Override
    public Bearing getAnnualChange() {
        return this.annualChange;
    }

    @Override
    public Bearing getBearingCorrectedTo(TimePoint timePoint) {
        return new DegreeBearingImpl(this.getBearing().getDegrees() + this.getAnnualChange().getDegrees() * (double)(timePoint.asMillis() - this.getTimePoint().asMillis()) / 1000.0 / 3600.0 / 24.0 / 365.0);
    }

    public String toString() {
        return this.getTimePoint() + "@" + this.getPosition() + ": " + this.getBearing() + ", " + this.getAnnualChange() + "/year";
    }
}

