/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.declination.impl;

import com.sap.sailing.declination.Declination;
import com.sap.sailing.declination.impl.DeclinationImporter;
import com.sap.sailing.declination.impl.DeclinationRecordImpl;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ColoradoImporter
extends DeclinationImporter {
    private static final String URL_PATTERN = "http://magcalc.geomag.info/?model=WMM2015&sourcePage=oldCalc&decimalLatitude=%f&decimalLongitude=%f&minYear=%d&minMonth=%d&minDay=%d";

    public Declination getDeclinationFromXml(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        XmlElementHandler handler = new XmlElementHandler();
        SAXParserFactory.newInstance().newSAXParser().parse(is, (DefaultHandler)handler);
        return handler.getDeclination();
    }

    @Override
    public Declination importRecord(Position position, TimePoint timePoint) throws IOException, ParserConfigurationException, SAXException {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTime(timePoint.asDate());
        URL url = new URL(String.format(URL_PATTERN, position.getLatDeg(), position.getLngDeg(), cal.get(1), cal.get(2) + 1, cal.get(5)));
        return this.getDeclinationFromXml(url.openStream());
    }

    private static class XmlElementHandler
    extends DefaultHandler {
        private double dateAsDecimalYear;
        private double latDeg;
        private double lngDeg;
        private double declinationDeg;
        private double annualDeclinationChangeDeg;
        private StringBuilder elementContent = new StringBuilder();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.elementContent.delete(0, this.elementContent.length());
            super.startElement(uri, localName, qName, attributes);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.elementContent.append(ch, start, length);
            super.characters(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String content = this.elementContent.toString();
            switch (qName) {
                case "DATE": {
                    this.dateAsDecimalYear = Double.valueOf(content);
                    break;
                }
                case "LATITUDE": {
                    this.latDeg = Double.valueOf(content);
                    break;
                }
                case "LONGITUDE": {
                    this.lngDeg = Double.valueOf(content);
                    break;
                }
                case "DECLINATION": {
                    this.declinationDeg = Double.valueOf(content);
                    break;
                }
                case "DECLINATION_SV": {
                    this.annualDeclinationChangeDeg = Double.valueOf(content);
                }
            }
            super.endElement(uri, localName, qName);
        }

        Declination getDeclination() {
            return new DeclinationRecordImpl((Position)new DegreePosition(this.latDeg, this.lngDeg), (TimePoint)new MillisecondsTimePoint((long)((this.dateAsDecimalYear - 1970.0) * 365.0 * 24.0 * 3600.0 * 1000.0)), (Bearing)new DegreeBearingImpl(this.declinationDeg), (Bearing)new DegreeBearingImpl(this.annualDeclinationChangeDeg));
        }
    }
}

